/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.filter;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class JsonSchemaValidationFilterTestCase
extends FunctionalTestCase {
    private static final String JSON_ACCEPT = "{\n  \"homeTeam\": \"BAR\",\n  \"awayTeam\": \"RMA\",\n  \"homeTeamScore\": 3,\n  \"awayTeamScore\": 0\n}";
    private static final String JSON_REJECT = "{\n  \"homeTeam\": \"BARCA\",\n  \"awayTeam\": \"RMA\",\n  \"homeTeamScore\": 3,\n  \"awayTeamScore\": 0\n}";
    private static final String JSON_BROKEN = "{\n  \"homeTeam\": BARCA\n}";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port");

    protected String getConfigFile() {
        return "json-filter-config.xml";
    }

    @Test
    public void validSchema() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HttpRequestOptions httpRequestOptions = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).build();
        MuleMessage message = client.send("http://localhost:" + this.dynamicPort.getNumber(), JsonSchemaValidationFilterTestCase.getTestMuleMessage((Object)JSON_ACCEPT), (OperationOptions)httpRequestOptions);
        Assert.assertEquals((long)200L, (long)((Integer)message.getInboundProperty("http.status")).intValue());
        Assert.assertEquals((Object)"accepted", (Object)message.getPayloadAsString());
    }

    @Test
    public void invalidSchema() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("http://localhost:" + this.dynamicPort.getNumber(), JsonSchemaValidationFilterTestCase.getTestMuleMessage((Object)JSON_REJECT));
        Assert.assertEquals((long)200L, (long)((Integer)message.getInboundProperty("http.status")).intValue());
        Assert.assertFalse((boolean)"accepted".equals(message.getPayloadAsString()));
    }

    @Test
    public void brokenJson() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("http://localhost:" + this.dynamicPort.getNumber(), JsonSchemaValidationFilterTestCase.getTestMuleMessage((Object)JSON_BROKEN));
        Assert.assertEquals((long)200L, (long)((Integer)message.getInboundProperty("http.status")).intValue());
        Assert.assertFalse((boolean)"accepted".equals(message.getPayloadAsString()));
    }
}

