/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.message;

import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transport.email.transformers.PlainTextDataSource;

public class AttachmentsPropagationTestCase
extends FunctionalTestCase
implements EventCallback {
    private static final String ATTACHMENT_CONTENT = "<content>";

    protected String getConfigFile() {
        return "org/mule/test/message/attachment-propagation.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        FunctionalTestComponent ftc = (FunctionalTestComponent)this.getComponent("SINGLE");
        ftc.setEventCallback((EventCallback)this);
        ftc = (FunctionalTestComponent)this.getComponent("CHAINED");
        ftc.setEventCallback((EventCallback)this);
    }

    public void eventReceived(MuleEventContext context, Object component) throws Exception {
        MuleMessage message = context.getMessage();
        for (String attachmentName : message.getInboundAttachmentNames()) {
            DataHandler inboundAttachment = message.getInboundAttachment(attachmentName);
            message.addOutboundAttachment(attachmentName, inboundAttachment);
        }
        String attachmentName = context.getFlowConstruct().getName();
        DataHandler dataHandler = new DataHandler((DataSource)new PlainTextDataSource("text/plain", ATTACHMENT_CONTENT));
        message.addOutboundAttachment(attachmentName, dataHandler);
        FunctionalTestComponent fc = (FunctionalTestComponent)component;
        fc.setReturnData((Object)message.getOutboundAttachmentNames());
    }

    @Test
    public void singleFlowShouldReceiveAttachment() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("vm://Single", (Object)"", null);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)((Set)result.getPayload()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"SINGLE"}));
        DataHandler attachment = result.getInboundAttachment("SINGLE");
        Assert.assertThat((Object)attachment, (Matcher)Matchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)attachment.getContent().toString(), (Matcher)Matchers.is((Object)ATTACHMENT_CONTENT));
    }

    @Test
    public void chainedFlowShouldReceiveAttachments() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("vm://Chained", (Object)"", null);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)((Set)result.getPayload()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"SINGLE", "CHAINED"}));
    }
}

