/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.message;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.test.integration.message.AbstractPropertyScopeTestCase;

public class JmsPropertyScopeTestCase
extends AbstractPropertyScopeTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/message/jms-property-scope.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/message/jms-property-scope-flow.xml"});
    }

    public JmsPropertyScopeTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Override
    @Test
    public void testRequestResponse() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = this.getTestMuleMessage();
        message.setOutboundProperty("foo", (Object)"fooValue");
        message.setReplyTo((Object)"jms://reply");
        client.dispatch("inbound", message);
        MuleMessage result = client.request("jms://reply", 10000L);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"test bar", (Object)result.getPayload());
        Assert.assertEquals((Object)"fooValue", (Object)result.getInboundProperty("foo"));
    }
}

