/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.resolvers;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.test.integration.resolvers.AbstractEntryPointResolverTestCase;

public class EntryPointResolverTestCase
extends AbstractEntryPointResolverTestCase {
    public EntryPointResolverTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/resolvers/entry-point-resolver-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/resolvers/entry-point-resolver-test-flow.xml"});
    }

    @Test
    public void testArrayEntryPointResolverOnModel() throws Exception {
        if (this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE)) {
            this.doTest("array", new String[]{"hello", "world"}, "array");
        }
    }

    @Test
    public void testArrayEntryPointResolverOnComponent() throws Exception {
        this.doTest("array2", new String[]{"hello", "world"}, "array");
    }

    @Test
    public void testCallableEntryPointResolverOnModel() throws Exception {
        if (this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE)) {
            this.doTest("callable", new Object(), "callable");
        }
    }

    @Test
    public void testCallableEntryPointResolverOnComponent() throws Exception {
        this.doTest("callable2", new Object(), "callable");
    }

    @Test
    public void testCustomEntryPointResolverOnModel() throws Exception {
        if (this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE)) {
            this.doTest("custom", new Object(), "custom");
        }
    }

    @Test
    public void testCustomEntryPointResolverOnComponent() throws Exception {
        this.doTest("custom2", new Object(), "custom");
    }

    @Test
    public void testMethodEntryPointResolverOnModel() throws Exception {
        if (this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE)) {
            this.doTest("method", new String(), "methodString");
            this.doTest("method", new Integer(0), "methodInteger");
        }
    }

    @Test
    public void testMethodEntryPointResolverOnComponent() throws Exception {
        this.doTest("method2", new String(), "methodString");
        this.doTest("method2", new Integer(0), "methodInteger");
    }

    @Test
    public void testNoArgumentsEntryPointResolverOnModel() throws Exception {
        if (this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE)) {
            this.doTest("no-arguments", new String(), "noArguments");
        }
    }

    @Test
    public void testNoArgumentsEntryPointResolverOnComponent() throws Exception {
        this.doTest("no-arguments2", new String(), "noArguments");
    }

    @Test
    public void testPropertyEntryPointResolverOnModel() throws Exception {
        if (this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE)) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("propertyName", "property");
            this.doTest("property", new Object(), "property", properties);
        }
    }

    @Test
    public void testPropertyEntryPointResolverOnComponent() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("propertyName", "property");
        this.doTest("property2", new Object(), "property", properties);
    }

    @Test
    public void testReflectionEntryPointResolverOnModel() throws Exception {
        if (this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE)) {
            this.doTest("reflection", new Object[]{new Integer(0), new String("String")}, "reflection");
        }
    }

    @Test
    public void testReflectionEntryPointResolverOnComponent() throws Exception {
        this.doTest("reflection2", new Object[]{new Integer(0), new String("String")}, "reflection");
    }

    @Test
    public void testLegacyEntryPointResolversOnModel() throws Exception {
        if (this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE)) {
            this.doTest("legacy", "hello world", "callable");
        }
    }

    @Test
    public void testLegacyEntryPointResolversOnComponent() throws Exception {
        this.doTest("legacy2", "hello world", "callable");
    }

    @Test
    public void testReflectionEntryPointResolverWithNullElementInArray() throws Exception {
        try {
            this.doTest("reflection2", new Object[]{new Integer(42), null}, "{NullPayload}");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.doTest("array2", new String[]{"hello", null, "world"}, "array");
    }
}

