/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.routing;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.context.notification.EndpointMessageNotificationListener;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.EndpointMessageNotification;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.FunctionalTestNotification;
import org.mule.tck.functional.FunctionalTestNotificationListener;
import org.mule.test.integration.routing.SimpleSerializableObject;
import org.mule.util.concurrent.Latch;

public class MessageChunkingTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/routing/message-chunking-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/routing/message-chunking-flow.xml"});
    }

    public MessageChunkingTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testMessageChunkingWithEvenSplit() throws Exception {
        this.doMessageChunking("0123456789", 5);
    }

    @Test
    public void testMessageChunkingWithOddSplit() throws Exception {
        this.doMessageChunking("01234567890", 6);
    }

    @Test
    public void testMessageChunkingWith100Splits() throws Exception {
        this.doMessageChunking("01234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789", 100);
    }

    @Test
    public void testMessageChunkingOneChunk() throws Exception {
        this.doMessageChunking("x", 1);
    }

    @Test
    public void testMessageChunkingObject() throws Exception {
        final AtomicInteger messagePartsCount = new AtomicInteger(0);
        final Latch chunkingReceiverLatch = new Latch();
        final SimpleSerializableObject simpleSerializableObject = new SimpleSerializableObject("Test String", true, 99);
        int parts = (int)Math.ceil((double)SerializationUtils.serialize((Serializable)simpleSerializableObject).length / 2.0);
        muleContext.registerListener((ServerNotificationListener)new FunctionalTestNotificationListener(){

            public void onNotification(ServerNotification notification) {
                Assert.assertEquals((Object)"ChunkingObjectReceiver", (Object)notification.getResourceIdentifier());
                Object reply = ((FunctionalTestNotification)notification).getEventContext().getMessage().getPayload();
                Assert.assertTrue((boolean)(reply instanceof SimpleSerializableObject));
                SimpleSerializableObject replySimpleSerializableObject = (SimpleSerializableObject)reply;
                Assert.assertEquals((Object)simpleSerializableObject.b, (Object)replySimpleSerializableObject.b);
                Assert.assertEquals((long)simpleSerializableObject.i, (long)replySimpleSerializableObject.i);
                Assert.assertEquals((Object)simpleSerializableObject.s, (Object)replySimpleSerializableObject.s);
                chunkingReceiverLatch.countDown();
            }
        }, "ChunkingObjectReceiver");
        muleContext.registerListener((ServerNotificationListener)new EndpointMessageNotificationListener<EndpointMessageNotification>(){

            public void onNotification(EndpointMessageNotification notification) {
                if (notification.getAction() == 801) {
                    messagePartsCount.getAndIncrement();
                }
                Assert.assertEquals((Object)"ChunkingObjectReceiver", (Object)notification.getResourceIdentifier());
            }
        }, "ChunkingObjectReceiver");
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://inbound.object.channel", (Object)simpleSerializableObject, null);
        Assert.assertTrue((boolean)chunkingReceiverLatch.await(20L, TimeUnit.SECONDS));
        Assert.assertEquals((long)parts, (long)messagePartsCount.get());
    }

    protected void doMessageChunking(final String data, int partsCount) throws Exception {
        final AtomicInteger messagePartsCount = new AtomicInteger(0);
        final Latch chunkingReceiverLatch = new Latch();
        muleContext.registerListener((ServerNotificationListener)new FunctionalTestNotificationListener(){

            public void onNotification(ServerNotification notification) {
                Assert.assertEquals((Object)"ChunkingReceiver", (Object)notification.getResourceIdentifier());
                Object reply = ((FunctionalTestNotification)notification).getReplyMessage();
                Assert.assertEquals((Object)(data + " Received"), (Object)reply);
                chunkingReceiverLatch.countDown();
            }
        }, "ChunkingReceiver");
        muleContext.registerListener((ServerNotificationListener)new EndpointMessageNotificationListener<EndpointMessageNotification>(){

            public void onNotification(EndpointMessageNotification notification) {
                if (notification.getAction() == 801) {
                    messagePartsCount.getAndIncrement();
                }
                Assert.assertEquals((Object)"ChunkingReceiver", (Object)notification.getResourceIdentifier());
            }
        }, "ChunkingReceiver");
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://inbound.channel", (Object)data, null);
        Assert.assertTrue((boolean)chunkingReceiverLatch.await(20L, TimeUnit.SECONDS));
        Assert.assertEquals((long)partsCount, (long)messagePartsCount.get());
    }
}

