/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.routing.outbound;

import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transport.NullPayload;

public class ChainingRouterRemoteSyncTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/routing/outbound/chaining-router-remote-sync.xml";
    }

    @Test
    public void testRemoteSync() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("vm://in", (MuleMessage)new DefaultMuleMessage((Object)"test", muleContext));
        Assert.assertNull((String)"Shouldn't have any exceptions", (Object)result.getExceptionPayload());
        Assert.assertEquals((Object)"test [REMOTESYNC RESPONSE] [REMOTESYNC RESPONSE 2]", (Object)result.getPayloadAsString());
    }

    @Test
    public void testRemoteSyncLastEndpointDispatch() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("vm://in2", (MuleMessage)new DefaultMuleMessage((Object)"test", muleContext));
        Assert.assertNull((String)"Shouldn't have any exceptions", (Object)result.getExceptionPayload());
        Assert.assertEquals((Object)NullPayload.getInstance(), (Object)result.getPayload());
        MuleMessage jmsMessage = client.request("jms://out2", 5000L);
        Assert.assertEquals((Object)"test [REMOTESYNC RESPONSE] [REMOTESYNC RESPONSE 2]", (Object)jmsMessage.getPayloadAsString());
        Assert.assertFalse((boolean)((Boolean)jmsMessage.getOutboundProperty("MULE_REMOTE_SYNC", (Object)false)));
    }
}

