/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.routing.outbound;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class ExpressionRecipientListAsyncTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/routing/outbound/expression-recipient-list-async-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/routing/outbound/expression-recipient-list-async-test-flow.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW_EL, "org/mule/test/integration/routing/outbound/expression-recipient-list-async-test-flow-el.xml"});
    }

    public ExpressionRecipientListAsyncTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testRecipientList() throws Exception {
        String message = "test";
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>(3);
        props.put("recipient1", "vm://service1.queue");
        props.put("recipient2", "vm://service2.queue");
        props.put("recipient3", "vm://service3.queue");
        client.dispatch("vm://distributor.queue", (Object)message, props);
        ArrayList<Object> results = new ArrayList<Object>(3);
        MuleMessage result = client.request("vm://collector.queue", 5000L);
        Assert.assertNotNull((Object)result);
        results.add(result.getPayload());
        result = client.request("vm://collector.queue", 3000L);
        Assert.assertNotNull((Object)result);
        results.add(result.getPayload());
        result = client.request("vm://collector.queue", 3000L);
        Assert.assertNotNull((Object)result);
        results.add(result.getPayload());
        Assert.assertTrue((boolean)results.contains("test 1 Received"));
        Assert.assertTrue((boolean)results.contains("test 2 Received"));
        Assert.assertTrue((boolean)results.contains("test 3 Received"));
    }
}

