/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.routing.replyto;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.junit4.FunctionalTestCase;

public class ReplyToWithSubflowTestCase
extends FunctionalTestCase {
    private static final String FLOW_PAYLOAD = "FLOW_PAYLOAD";
    private static final String SUB_FLOW_PAYLOAD = "SUB_FLOW_PAYLOAD";
    private static final String OUTPUT_QUEUE = "vm://outputQueue";
    private static final int DUPLICATE_RESPONSE_TIMEOUT = 500;

    protected String getConfigFile() {
        return "org/mule/test/integration/routing/replyto/replyto-with-subflow-test.xml";
    }

    @Test
    public void repliesOnlyOnceWhenUsingSyncSubflow() throws Exception {
        this.sendMessageAndExpectReply("syncSubFlow", "vm://syncInputQueue", SUB_FLOW_PAYLOAD);
    }

    @Test
    public void repliesOnlyOnceWhenUsingAsyncSubflow() throws Exception {
        this.sendMessageAndExpectReply("asyncSubFlow", "vm://asyncInputQueue", FLOW_PAYLOAD);
    }

    private void sendMessageAndExpectReply(String flow, String path, String expectedMessage) throws Exception {
        final CountDownLatch subFlowLatch = new CountDownLatch(1);
        this.getFunctionalTestComponent(flow).setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                subFlowLatch.countDown();
            }
        });
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        message.setReplyTo((Object)OUTPUT_QUEUE);
        muleContext.getClient().dispatch(path, (MuleMessage)message);
        message = muleContext.getClient().request(OUTPUT_QUEUE, 5000L);
        Assert.assertNotNull((String)"Message was not received", (Object)message);
        Assert.assertEquals((Object)expectedMessage, (Object)message.getPayload());
        subFlowLatch.await(30000L, TimeUnit.MILLISECONDS);
        message = muleContext.getClient().request(OUTPUT_QUEUE, 500L);
        Assert.assertNull((String)"Response was received twice", (Object)message);
    }
}

