/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.schedule;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.junit.Test;
import org.mule.api.AnnotatedObject;
import org.mule.api.context.notification.EndpointMessageNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.EndpointMessageNotification;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.probe.Prober;

public class PollScheduleNotificationTestCase
extends FunctionalTestCase {
    public static final QName NAME = new QName("http://www.mulesoft.org/schema/mule/documentation", "name");
    Prober prober = new PollingProber(5000L, 100L);

    protected String getConfigFile() {
        return "org/mule/test/integration/schedule/poll-notifications-config.xml";
    }

    @Test
    public void validateNotificationsAreSent() throws InterruptedException {
        final MyListener listener = new MyListener();
        muleContext.getNotificationManager().addListener((ServerNotificationListener)listener);
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                return listener.getNotifications().size() > 1 && "pollName".equals(listener.getNotifications().get(0));
            }

            public String describeFailure() {
                return "The notification was never sent";
            }
        });
    }

    class MyListener
    implements EndpointMessageNotificationListener<EndpointMessageNotification> {
        List<String> notifications = new ArrayList<String>();

        MyListener() {
        }

        public void onNotification(EndpointMessageNotification notification) {
            this.notifications.add((String)((AnnotatedObject)notification.getImmutableEndpoint()).getAnnotation(NAME));
        }

        public List<String> getNotifications() {
            return this.notifications;
        }
    }
}

