/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.schedule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.schedule.Scheduler;
import org.mule.api.schedule.Schedulers;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.probe.Prober;

public class PollScheduleTestCase
extends FunctionalTestCase {
    private static List<String> foo = new ArrayList<String>();
    private static List<String> bar = new ArrayList<String>();
    Prober workingPollProber = new PollingProber(5000L, 1000L);

    @BeforeClass
    public static void setProperties() {
        System.setProperty("frequency.days", "4");
        System.setProperty("frequency.millis", "2000");
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/schedule/polling-schedule-config.xml";
    }

    @Test
    public void test() throws Exception {
        this.workingPollProber.check(new Probe(){

            public boolean isSatisfied() {
                return foo.size() > 2 && PollScheduleTestCase.this.checkCollectionValues(foo, "foo") && bar.size() > 2 && PollScheduleTestCase.this.checkCollectionValues(bar, "bar");
            }

            public String describeFailure() {
                return "The collections foo and bar are not correctly filled";
            }
        });
        this.stopSchedulers();
        this.waitForPollElements();
        int fooElementsAfterStopping = foo.size();
        this.waitForPollElements();
        Assert.assertEquals((long)fooElementsAfterStopping, (long)foo.size());
        this.runSchedulersOnce();
        Thread.sleep(200L);
        Assert.assertEquals((long)(fooElementsAfterStopping + 1), (long)foo.size());
    }

    private void waitForPollElements() throws InterruptedException {
        Thread.sleep(2000L);
    }

    private boolean checkCollectionValues(List<String> coll, String value) {
        for (String s : coll) {
            if (s.equals(value)) continue;
            return false;
        }
        return true;
    }

    private void runSchedulersOnce() throws Exception {
        Collection schedulers = muleContext.getRegistry().lookupScheduler(Schedulers.flowConstructPollingSchedulers((String)"pollfoo"));
        for (Scheduler scheduler : schedulers) {
            scheduler.schedule();
        }
    }

    private void stopSchedulers() throws MuleException {
        Collection schedulers = muleContext.getRegistry().lookupScheduler(Schedulers.flowConstructPollingSchedulers((String)"pollfoo"));
        for (Scheduler scheduler : schedulers) {
            scheduler.stop();
        }
    }

    public static class BarComponent {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean process(String s) {
            List list = bar;
            synchronized (list) {
                if (bar.size() < 10) {
                    bar.add(s);
                    return true;
                }
            }
            return false;
        }
    }

    public static class FooComponent {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean process(String s) {
            List list = foo;
            synchronized (list) {
                if (foo.size() < 10) {
                    foo.add(s);
                    return true;
                }
            }
            return false;
        }
    }
}

