/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.service;

import java.util.concurrent.CountDownLatch;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.mule.api.MuleException;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.service.Service;
import org.mule.test.integration.service.ServiceInFlightMessagesTestCase;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.JmsSupport;

public class ServiceInFlightMessagesJMSTestCase
extends ServiceInFlightMessagesTestCase {
    protected TestJMSMessageListener listener;

    @Override
    protected String getConfigFile() {
        return "org/mule/test/integration/service/service-inflight-messages-jms.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.listener = this.createTestJMSConsumer();
    }

    @Override
    protected void stopService(Service service) throws Exception {
        service.stop();
        Thread.sleep(500L);
    }

    @Override
    protected void startService(Service service) throws Exception {
        service.start();
    }

    private TestJMSMessageListener createTestJMSConsumer() throws MuleException, JMSException {
        TestJMSMessageListener messageListener = new TestJMSMessageListener();
        this.createJMSMessageConsumer().setMessageListener((MessageListener)messageListener);
        return messageListener;
    }

    private MessageConsumer createJMSMessageConsumer() throws MuleException, JMSException {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("jms://out");
        JmsConnector jmsConnector = (JmsConnector)muleContext.getRegistry().lookupConnector("outPersistentConnector");
        JmsSupport jmsSupport = jmsConnector.getJmsSupport();
        MessageConsumer consumer = jmsSupport.createConsumer(jmsConnector.getSession((ImmutableEndpoint)endpoint), jmsSupport.createDestination(jmsConnector.getSession((ImmutableEndpoint)endpoint), (ImmutableEndpoint)endpoint), false, (ImmutableEndpoint)endpoint);
        return consumer;
    }

    @Override
    protected int getOutSize() throws Exception {
        return (int)(500L - this.listener.countdownLatch.getCount());
    }

    @Override
    protected void recreateAndStartMuleContext() throws Exception, MuleException {
        muleContext = this.createMuleContext();
        muleContext.start();
        this.createJMSMessageConsumer().setMessageListener((MessageListener)this.listener);
    }

    private class TestJMSMessageListener
    implements MessageListener {
        CountDownLatch countdownLatch = new CountDownLatch(500);

        public void onMessage(Message message) {
            this.countdownLatch.countDown();
        }
    }
}

