/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transaction;

import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.lifecycle.Callable;
import org.mule.construct.Flow;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.concurrent.Latch;

public class JmsConcurrentConsumerExecutionTestCase
extends FunctionalTestCase {
    public static final String MESSAGE = "some message";
    public static final int TIMEOUT = 10000;
    private static final Latch messageSuccessfulReceived = new Latch();
    private static final Latch messageFailureReceived = new Latch();

    protected String getConfigFile() {
        return "org/mule/test/integration/transaction/jms-concurrent-in-transaction.xml";
    }

    @Test
    @Ignore(value="MULE-6926")
    public void testTwoMessagesOneRollbackOneCommit() throws Exception {
        LocalMuleClient muleClient = muleContext.getClient();
        muleClient.dispatch("jms://in", (Object)"success", null);
        muleClient.dispatch("jms://in", (Object)"failure", null);
        if (!messageSuccessfulReceived.await(10000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"JMS messages didn't execute concurrently, might be using only one Session for more than one transaction");
        }
        if (!messageFailureReceived.await(10000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"JMS messages didn't execute concurrently, might be using only one Session for more than one transaction");
        }
        Flow flowWithTxConfigured = (Flow)this.getFlowConstruct("flowWithTxConfigured");
        flowWithTxConfigured.stop();
        MuleMessage muleMessage = muleClient.request("jms://in", 10000L);
        Assert.assertThat((Object)muleMessage, (Matcher)IsNull.notNullValue());
        muleMessage = muleClient.request("jms://in", 10000L);
        Assert.assertThat((Object)muleMessage, (Matcher)IsNull.nullValue());
    }

    public static class FailureComponent
    implements Callable {
        public Object onCall(MuleEventContext eventContext) throws Exception {
            try {
                throw new RuntimeException("something bad happend :)");
            }
            catch (Throwable throwable) {
                messageFailureReceived.release();
                messageSuccessfulReceived.await(10000L, TimeUnit.MILLISECONDS);
                throw throwable;
            }
        }
    }

    public static class SuccessComponent
    implements Callable {
        public Object onCall(MuleEventContext eventContext) throws Exception {
            messageSuccessfulReceived.release();
            messageFailureReceived.await(10000L, TimeUnit.MILLISECONDS);
            return eventContext.getMessage();
        }
    }
}

