/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transaction.xa;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.context.MuleContextAware;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.integration.transaction.xa.CompositeTransactionalTestSetUp;
import org.mule.test.integration.transaction.xa.JdbcDatabaseSetUp;
import org.mule.test.integration.transaction.xa.JmsBrokerSetUp;
import org.mule.test.integration.transaction.xa.JmsOutboundMessagesCounter;
import org.mule.test.integration.transaction.xa.QueueInboundMessageGenerator;
import org.mule.test.integration.transaction.xa.QueueOutboundMessagesCounter;
import org.mule.test.integration.transaction.xa.TransactionScenarios;
import org.mule.test.integration.transaction.xa.TransactionalTestSetUp;

@RunWith(value=Parameterized.class)
public class EndpointToEndpointXaTransactionTestCase
extends FunctionalTestCase {
    public static String transactionManagerConfigFile = "org/mule/test/integration/transaction/xa/jboss-transaction-manager-config.xml";
    @ClassRule
    public static DynamicPort port1 = new DynamicPort("port1");
    @ClassRule
    public static DynamicPort port2 = new DynamicPort("port2");
    private final String[] configFiles;
    private final TransactionalTestSetUp testSetUp;
    private final TransactionScenarios.InboundMessagesGenerator inboundMessagesCreator;
    private final TransactionScenarios.OutboundMessagesCounter outboundMessagesCounter;

    public EndpointToEndpointXaTransactionTestCase(String[] configFiles, TransactionalTestSetUp testSetUp, TransactionScenarios.InboundMessagesGenerator inboundMessagesCreator, TransactionScenarios.OutboundMessagesCounter outboundMessagesCounter) {
        this.configFiles = configFiles;
        this.testSetUp = testSetUp;
        this.inboundMessagesCreator = inboundMessagesCreator;
        this.outboundMessagesCounter = outboundMessagesCounter;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        JdbcDatabaseSetUp jdbcDatabaseSetUp = JdbcDatabaseSetUp.createDatabaseOne();
        TransactionScenarios.InboundMessagesGenerator jdbcInboundMessageCreator = jdbcDatabaseSetUp.createInboundMessageCreator();
        TransactionScenarios.OutboundMessagesCounter jdbcOutboundMessagesVerifier = jdbcDatabaseSetUp.createOutboundMessageCreator();
        JdbcDatabaseSetUp jdbcDatabaseSetUp2 = JdbcDatabaseSetUp.createDatabaseTwo();
        TransactionScenarios.OutboundMessagesCounter jdbcOutboundMessagesVerifier2 = jdbcDatabaseSetUp2.createOutboundMessageCreator();
        CompositeTransactionalTestSetUp createTwoDatabasesSetUp = new CompositeTransactionalTestSetUp(jdbcDatabaseSetUp, jdbcDatabaseSetUp2);
        JmsBrokerSetUp createFirstJmsBroker = new JmsBrokerSetUp(port1.getNumber());
        CompositeTransactionalTestSetUp createDatabaseAndJmsBrokerSetUp = new CompositeTransactionalTestSetUp(jdbcDatabaseSetUp, createFirstJmsBroker);
        JmsBrokerSetUp createSecondJmsBroker = new JmsBrokerSetUp(port2.getNumber());
        CompositeTransactionalTestSetUp createTowJmsBrokers = new CompositeTransactionalTestSetUp(createFirstJmsBroker, createSecondJmsBroker);
        return Arrays.asList({new String[]{"org/mule/test/integration/transaction/xa/xa-transaction-config.xml", "org/mule/test/integration/transaction/xa/vm-xa-transaction-config.xml", transactionManagerConfigFile}, null, new QueueInboundMessageGenerator(), new QueueOutboundMessagesCounter()}, {new String[]{"org/mule/test/integration/transaction/xa/xa-transaction-config.xml", "org/mule/test/integration/transaction/xa/vm-different-connectors-xa-transaction-config.xml", transactionManagerConfigFile}, null, new QueueInboundMessageGenerator(), new QueueOutboundMessagesCounter()}, {new String[]{"org/mule/test/integration/transaction/xa/xa-transaction-config.xml", "org/mule/test/integration/transaction/xa/jms-xa-transaction-config.xml", transactionManagerConfigFile}, createFirstJmsBroker, new QueueInboundMessageGenerator(), JmsOutboundMessagesCounter.createVerifierForBroker(port1.getNumber())}, {new String[]{"org/mule/test/integration/transaction/xa/xa-transaction-config.xml", "org/mule/test/integration/transaction/xa/jms-different-connectors-xa-transaction-config.xml", transactionManagerConfigFile}, createTowJmsBrokers, new QueueInboundMessageGenerator(), JmsOutboundMessagesCounter.createVerifierForBroker(port2.getNumber())}, {new String[]{"org/mule/test/integration/transaction/xa/xa-transaction-config.xml", "org/mule/test/integration/transaction/xa/jdbc-xa-transaction-config.xml", transactionManagerConfigFile}, jdbcDatabaseSetUp, jdbcInboundMessageCreator, jdbcOutboundMessagesVerifier}, {new String[]{"org/mule/test/integration/transaction/xa/xa-transaction-config.xml", "org/mule/test/integration/transaction/xa/jdbc-different-connectors-xa-transaction-config.xml", transactionManagerConfigFile}, createTwoDatabasesSetUp, jdbcInboundMessageCreator, jdbcOutboundMessagesVerifier2}, {new String[]{"org/mule/test/integration/transaction/xa/xa-transaction-config.xml", "org/mule/test/integration/transaction/xa/jdbc-to-jms-xa-transaction-config.xml", transactionManagerConfigFile}, createDatabaseAndJmsBrokerSetUp, jdbcInboundMessageCreator, JmsOutboundMessagesCounter.createVerifierForBroker(port1.getNumber())}, {new String[]{"org/mule/test/integration/transaction/xa/xa-transaction-config.xml", "org/mule/test/integration/transaction/xa/jms-to-jdbc-xa-transaction-config.xml", transactionManagerConfigFile}, createDatabaseAndJmsBrokerSetUp, new QueueInboundMessageGenerator(), jdbcOutboundMessagesVerifier}, {new String[]{"org/mule/test/integration/transaction/xa/xa-transaction-config.xml", "org/mule/test/integration/transaction/xa/vm-to-jdbc-xa-transaction-config.xml", transactionManagerConfigFile}, jdbcDatabaseSetUp, new QueueInboundMessageGenerator(), jdbcOutboundMessagesVerifier}, {new String[]{"org/mule/test/integration/transaction/xa/xa-transaction-config.xml", "org/mule/test/integration/transaction/xa/jdbc-to-vm-xa-transaction-config.xml", transactionManagerConfigFile}, jdbcDatabaseSetUp, jdbcInboundMessageCreator, new QueueOutboundMessagesCounter()});
    }

    protected String[] getConfigFiles() {
        return this.configFiles;
    }

    @Before
    public void injectMuleContext() {
        if (this.inboundMessagesCreator instanceof MuleContextAware) {
            ((MuleContextAware)this.inboundMessagesCreator).setMuleContext(muleContext);
        }
        if (this.outboundMessagesCounter instanceof MuleContextAware) {
            ((MuleContextAware)this.outboundMessagesCounter).setMuleContext(muleContext);
        }
    }

    @Test
    public void allCommit() {
        new TransactionScenarios(this.inboundMessagesCreator, this.outboundMessagesCounter).testNoFailureDuringFlowExecution();
    }

    @Test
    public void someRollbacksThenCommit() {
        new TransactionScenarios(this.inboundMessagesCreator, this.outboundMessagesCounter).testIntermittentFailureDuringFlowExecution();
    }

    @Test
    public void allRollbacks() {
        new TransactionScenarios(this.inboundMessagesCreator, this.outboundMessagesCounter).setVerificationTimeout(1000).testAlwaysFailureDuringFlowException();
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        if (this.testSetUp != null) {
            this.testSetUp.initialize();
        }
    }

    protected void doTearDownAfterMuleContextDispose() throws Exception {
        if (this.testSetUp != null) {
            this.testSetUp.finalice();
        }
    }
}

