/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transport.cxf;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.testmodels.mule.TestExceptionStrategy;
import org.mule.util.concurrent.Latch;

public class CxfAndXslTransformerOnSoapTestCase
extends AbstractServiceAndFlowTestCase {
    private static final String msg = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:emop=\"http://www.wcs.com/2010/07/14/emop\">  <soapenv:Header>\n    <header UserName=\"nothing\" Password=\"important\"/>\n  </soapenv:Header>\n  <soapenv:Body>\n    <emop:ScratchcardValidateAndPayRequestBody>\n       <ScratchcardNumber>1</ScratchcardNumber>\n       <VirnNumber>2</VirnNumber>\n    </emop:ScratchcardValidateAndPayRequestBody>\n  </soapenv:Body>\n</soapenv:Envelope>";
    private final AtomicInteger connectorExceptionCounter = new AtomicInteger();

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/transport/cxf/scratchcard-service-v1-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/transport/cxf/scratchcard-service-v1-flow.xml"});
    }

    public CxfAndXslTransformerOnSoapTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.connectorExceptionCounter.set(0);
    }

    @Test
    public void testUsesTransformersCorrectly() throws Exception {
        TestExceptionStrategy exceptionStrategy = new TestExceptionStrategy();
        muleContext.setExceptionListener((SystemExceptionHandler)exceptionStrategy);
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:28181/ScratchCardServiceV1", CxfAndXslTransformerOnSoapTestCase.getTestMuleMessage((Object)msg), (OperationOptions)HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build());
        Assert.assertNotNull((String)"The result shouln't have been null", (Object)result);
        String payloadAsString = result.getPayloadAsString();
        Assert.assertNotNull((String)"The payloadAsString shouln't have been null", (Object)payloadAsString);
        Assert.assertFalse((String)("There shouldn't be a fault in the payload: " + payloadAsString), (boolean)payloadAsString.contains("<soap:Fault>"));
        final Latch latch = new Latch();
        exceptionStrategy.setExceptionCallback(new TestExceptionStrategy.ExceptionCallback(){

            public void onException(Throwable t) {
                CxfAndXslTransformerOnSoapTestCase.this.connectorExceptionCounter.incrementAndGet();
                latch.countDown();
            }
        });
        latch.await(500L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((String)"There shouldn't have been any exceptions", (long)0L, (long)this.connectorExceptionCounter.get());
    }
}

