/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transport.cxf;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.transport.PropertyScope;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class CxfOverJMSTestCase
extends AbstractServiceAndFlowTestCase {
    private static final String req = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><ns2:echo xmlns:ns2=\"http://simple.component.mule.org/\"><ns2:echo>hello</ns2:echo></ns2:echo></soap:Body></soap:Envelope>";

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/transport/cxf/cxf-over-jms-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/transport/cxf/cxf-over-jms-config-flow.xml"});
    }

    public CxfOverJMSTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testCxf() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("jms://TestComponent", (MuleMessage)new DefaultMuleMessage((Object)req, muleContext));
        MuleMessage message = client.request("jms://testout", 10000L);
        Assert.assertNotNull((Object)message.getPayload());
        Assert.assertTrue((message.getPayloadAsString().indexOf("return>hello") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testCxfClientOverJMS() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)"hello", muleContext);
        msg.setProperty("method", (Object)"echo", PropertyScope.INVOCATION);
        client.dispatch("cxf:jms://TestComponent2", (MuleMessage)msg);
        MuleMessage message = client.request("jms://testout", 10000L);
        Assert.assertNotNull((String)"message reply is null", (Object)message);
        Assert.assertNotNull((String)"message payload is null", (Object)message.getPayload());
        Assert.assertTrue((boolean)message.getPayloadAsString().equals("hello"));
    }

    @Ignore
    @Test
    public void testCxfOverJMSSyncProxy() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:63081/services/testBridge", (MuleMessage)new DefaultMuleMessage((Object)req, muleContext));
        Assert.assertNotNull((Object)result.getPayload());
        Assert.assertTrue((boolean)result.getPayloadAsString().contains("<ns2:echo>hello</ns2:echo>"));
    }
}

