/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.watermark;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.schedule.Scheduler;
import org.mule.api.schedule.SchedulerFactoryPostProcessor;
import org.mule.api.schedule.Schedulers;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.ObjectStoreManager;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.probe.Prober;
import org.mule.util.store.ObjectStorePartition;

public class WatermarkPollingTestCase
extends FunctionalTestCase {
    private static final String OS_KEY1 = "test1";
    private static final String OS_KEY2 = "test2";
    private static final String OS_KEY3 = "test3";
    private static final String OS_KEY4 = "test4";
    private static final String OS_KEY5 = "test5";
    private static final String OS_KEY6 = "test6";
    private static final String OS_KEY7 = "test7";
    private static final String OS_KEY8 = "test8";
    private static final String PRE_EXISTENT_OS_VALUE = "testValue";
    private static final String DEFAULT_VALUE_WHEN_KEY_NOT_PRESENT = "noKey";
    private static final String MODIFIED_KEY_VALUE = "keyPresent";
    private static final String RESULT_OF_UPDATE_EXPRESSION = "valueUpdated";
    private final Prober prober = new PollingProber(3000L, 500L);
    private static final List<String> foo = new ArrayList<String>();

    protected String getConfigFile() {
        return "org/mule/test/integration/watermark/watermark-polling-config.xml";
    }

    @Before
    public void cleanFoo() {
        foo.clear();
    }

    @Test
    public void testThatOsIsUserObjectStore() {
        ObjectStore defaultUserObjectStore = (ObjectStore)muleContext.getRegistry().lookupObject("_defaultUserObjectStore");
        Assert.assertEquals((Object)defaultUserObjectStore, (Object)((ObjectStorePartition)this.getDefaultObjectStore()).getBaseStore());
    }

    @Test
    public void pollWithNoKeyInTheObjectStore() throws Exception {
        this.executePollOf("nameNotDefinedWatermarkObjectStoreFlow");
        this.prober.check((Probe)new ObjectStoreProbe((ObjectStore)this.getDefaultObjectStore()){

            @Override
            boolean evaluate(ObjectStore<Serializable> os) throws ObjectStoreException {
                return os.contains((Serializable)((Object)WatermarkPollingTestCase.OS_KEY1)) && WatermarkPollingTestCase.DEFAULT_VALUE_WHEN_KEY_NOT_PRESENT.equals(os.retrieve((Serializable)((Object)WatermarkPollingTestCase.OS_KEY1)));
            }

            public String describeFailure() {
                return "The object store does not contain the key test1";
            }
        });
    }

    @Test
    public void pollChangeKeyValueWithNoKeyInTheObjectStore() throws Exception {
        this.executePollOf("changeWatermarkWihtNotDefinedWatermarkObjectStoreFlow");
        this.prober.check((Probe)new ObjectStoreProbe((ObjectStore)this.getDefaultObjectStore()){

            @Override
            boolean evaluate(ObjectStore<Serializable> os) throws ObjectStoreException {
                return os.contains((Serializable)((Object)WatermarkPollingTestCase.OS_KEY2)) && WatermarkPollingTestCase.MODIFIED_KEY_VALUE.equals(os.retrieve((Serializable)((Object)WatermarkPollingTestCase.OS_KEY2)));
            }

            public String describeFailure() {
                return "The object store does not contain the key test2";
            }
        });
    }

    @Test
    public void pollUsingWatermark() throws Exception {
        this.getDefaultObjectStore().store((Serializable)((Object)OS_KEY3), (Serializable)((Object)PRE_EXISTENT_OS_VALUE));
        this.executePollOf("usingWatermarkFlow");
        this.prober.check((Probe)new ObjectStoreProbe((ObjectStore)this.getDefaultObjectStore()){

            @Override
            boolean evaluate(ObjectStore<Serializable> os) throws ObjectStoreException {
                return os.contains((Serializable)((Object)WatermarkPollingTestCase.OS_KEY3)) && WatermarkPollingTestCase.MODIFIED_KEY_VALUE.equals(os.retrieve((Serializable)((Object)WatermarkPollingTestCase.OS_KEY3))) && foo.contains(WatermarkPollingTestCase.PRE_EXISTENT_OS_VALUE);
            }

            public String describeFailure() {
                return "The object store does not contain the key test3";
            }
        });
    }

    @Test
    public void watermarkWithKeyAsAnExpression() throws Exception {
        this.getDefaultObjectStore().store((Serializable)((Object)OS_KEY4), (Serializable)((Object)PRE_EXISTENT_OS_VALUE));
        this.executePollOf("watermarkWithKeyAsAnExpression");
        this.prober.check((Probe)new ObjectStoreProbe((ObjectStore)this.getDefaultObjectStore()){

            @Override
            boolean evaluate(ObjectStore<Serializable> os) throws ObjectStoreException {
                return os.contains((Serializable)((Object)WatermarkPollingTestCase.OS_KEY4)) && WatermarkPollingTestCase.MODIFIED_KEY_VALUE.equals(os.retrieve((Serializable)((Object)WatermarkPollingTestCase.OS_KEY4)));
            }

            public String describeFailure() {
                return "The object store does not contain the key test4";
            }
        });
    }

    @Test
    public void watermarkWithUpdateExpression() throws Exception {
        this.getDefaultObjectStore().store((Serializable)((Object)OS_KEY5), (Serializable)((Object)PRE_EXISTENT_OS_VALUE));
        this.executePollOf("watermarkWithUpdateExpression");
        this.prober.check((Probe)new ObjectStoreProbe((ObjectStore)this.getDefaultObjectStore()){

            @Override
            boolean evaluate(ObjectStore<Serializable> os) throws ObjectStoreException {
                return os.contains((Serializable)((Object)WatermarkPollingTestCase.OS_KEY5)) && WatermarkPollingTestCase.RESULT_OF_UPDATE_EXPRESSION.equals(os.retrieve((Serializable)((Object)WatermarkPollingTestCase.OS_KEY5))) && foo.contains(WatermarkPollingTestCase.RESULT_OF_UPDATE_EXPRESSION);
            }

            public String describeFailure() {
                return "The object store does not contain the key test5";
            }
        });
    }

    @Test
    public void watermarkWithObjectStore() throws Exception {
        ObjectStore os = (ObjectStore)muleContext.getRegistry().lookupObject("_defaultInMemoryObjectStore");
        os.store((Serializable)((Object)OS_KEY8), (Serializable)((Object)PRE_EXISTENT_OS_VALUE));
        this.executePollOf("watermarkWithObjectStore");
        this.prober.check((Probe)new ObjectStoreProbe(os){

            @Override
            boolean evaluate(ObjectStore<Serializable> os) throws ObjectStoreException {
                return os.contains((Serializable)((Object)WatermarkPollingTestCase.OS_KEY8)) && WatermarkPollingTestCase.RESULT_OF_UPDATE_EXPRESSION.equals(os.retrieve((Serializable)((Object)WatermarkPollingTestCase.OS_KEY8))) && foo.contains(WatermarkPollingTestCase.RESULT_OF_UPDATE_EXPRESSION);
            }

            public String describeFailure() {
                return "The object store does not contain the key test8";
            }
        });
    }

    @Test
    public void failingFlowWithWatermark() throws Exception {
        this.getDefaultObjectStore().store((Serializable)((Object)OS_KEY6), (Serializable)((Object)PRE_EXISTENT_OS_VALUE));
        this.executePollOf("failingFlowWithWatermark");
        this.prober.check((Probe)new ObjectStoreProbe((ObjectStore)this.getDefaultObjectStore()){

            @Override
            boolean evaluate(ObjectStore<Serializable> os) throws ObjectStoreException {
                return os.contains((Serializable)((Object)WatermarkPollingTestCase.OS_KEY6)) && WatermarkPollingTestCase.PRE_EXISTENT_OS_VALUE.equals(os.retrieve((Serializable)((Object)WatermarkPollingTestCase.OS_KEY6))) && !foo.contains(WatermarkPollingTestCase.RESULT_OF_UPDATE_EXPRESSION);
            }

            public String describeFailure() {
                return "The object store does not contain the key test6";
            }
        });
    }

    @Test
    public void failingFlowWithCatchedExceptionWatermark() throws Exception {
        this.getDefaultObjectStore().store((Serializable)((Object)OS_KEY7), (Serializable)((Object)PRE_EXISTENT_OS_VALUE));
        this.executePollOf("failingFlowCachedExceptionWatermark");
        this.prober.check((Probe)new ObjectStoreProbe((ObjectStore)this.getDefaultObjectStore()){

            @Override
            boolean evaluate(ObjectStore<Serializable> os) throws ObjectStoreException {
                return os.contains((Serializable)((Object)WatermarkPollingTestCase.OS_KEY7)) && "catchedException".equals(os.retrieve((Serializable)((Object)WatermarkPollingTestCase.OS_KEY7))) && !foo.contains(WatermarkPollingTestCase.RESULT_OF_UPDATE_EXPRESSION);
            }

            public String describeFailure() {
                return "The object store does not contain the key test7";
            }
        });
    }

    @Test(expected=AssertionError.class)
    public void watermarkWithAsyncProcessing() throws Exception {
        this.executePollOf("watermarkWithAsyncProcessing");
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                return foo.contains(WatermarkPollingTestCase.RESULT_OF_UPDATE_EXPRESSION);
            }

            public String describeFailure() {
                return "The async mp was never called, which is what was expected";
            }
        });
    }

    @Test(expected=AssertionError.class)
    public void watermarkWithNullDefaultExpression() throws Exception {
        this.executePollOf("usingWatermarkFlowWithNullValue");
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                return !foo.isEmpty();
            }

            public String describeFailure() {
                return "The foo collection is empty, which was expected";
            }
        });
    }

    @Test
    public void usingWatermarkFlowWithNullUpdateValue() throws Exception {
        this.executePollOf("usingWatermarkFlowWithNullUpdateValue");
        this.prober.check((Probe)new ObjectStoreProbe((ObjectStore)this.getDefaultObjectStore()){

            @Override
            boolean evaluate(ObjectStore<Serializable> os) throws ObjectStoreException {
                return foo.contains("defaultValue") && !os.contains((Serializable)((Object)"testUpdateAsNull"));
            }

            public String describeFailure() {
                return "The object store is storing null values";
            }
        });
    }

    @Test
    public void minSelectorWithList() throws Exception {
        this.assertVariableInOS("minSelectorWithList", new Character('A'), "The min value wasn't 'A'");
    }

    @Test
    public void maxSelectorWithList() throws Exception {
        this.assertVariableInOS("maxSelectorWithList", new Character('C'), "The max value wasn't 'C'");
    }

    @Test
    public void firstSelectorWithList() throws Exception {
        this.assertVariableInOS("firstSelectorWithList", (Serializable)((Object)"Apple"), "The first value wasn't 'Apple'");
    }

    @Test
    public void lastSelectorWithList() throws Exception {
        this.assertVariableInOS("lastSelectorWithList", (Serializable)((Object)"Coconut"), "The last value wasn't 'Coconut'");
    }

    @Test
    public void minSelectorWithIterator() throws Exception {
        this.assertVariableInOS("minSelectorWithIterator", new Character('A'), "The min value wasn't 'A'");
    }

    @Test
    public void maxSelectorWithIterator() throws Exception {
        this.assertVariableInOS("maxSelectorWithIterator", new Character('C'), "The max value wasn't 'C'");
    }

    @Test
    public void firstSelectorWithIterator() throws Exception {
        this.assertVariableInOS("firstSelectorWithIterator", (Serializable)((Object)"Apple"), "The first value wasn't 'Apple'");
    }

    @Test
    public void lastSelectorWithIterator() throws Exception {
        this.assertVariableInOS("lastSelectorWithIterator", (Serializable)((Object)"Coconut"), "The last value wasn't 'Coconut'");
    }

    private void assertVariableInOS(final String variableName, final Serializable expected, final String failureDescription) throws Exception {
        this.executePollOf(variableName);
        this.prober.check((Probe)new ObjectStoreProbe(this.getDefaultObjectStore()){

            @Override
            boolean evaluate(ObjectStore<Serializable> os) throws ObjectStoreException {
                return os.contains((Serializable)((Object)variableName)) && expected.equals(os.retrieve((Serializable)((Object)variableName)));
            }

            public String describeFailure() {
                return failureDescription;
            }
        });
    }

    private ObjectStore<Serializable> getDefaultObjectStore() {
        ObjectStoreManager mgr = (ObjectStoreManager)muleContext.getRegistry().get("_muleObjectStoreManager");
        return mgr.getObjectStore("mule.watermark");
    }

    private void executePollOf(String flowName) throws Exception {
        Collection schedulers = muleContext.getRegistry().lookupScheduler(Schedulers.flowConstructPollingSchedulers((String)flowName));
        for (Scheduler scheduler : schedulers) {
            scheduler.schedule();
        }
    }

    private abstract class ObjectStoreProbe
    implements Probe {
        private final ObjectStore<Serializable> os;

        public ObjectStoreProbe(ObjectStore<Serializable> os) {
            this.os = os;
        }

        public boolean isSatisfied() {
            try {
                return this.evaluate(this.os);
            }
            catch (ObjectStoreException e) {
                return false;
            }
        }

        abstract boolean evaluate(ObjectStore<Serializable> var1) throws ObjectStoreException;
    }

    public static class PollStopper
    implements SchedulerFactoryPostProcessor {
        public Scheduler process(Object job, final Scheduler scheduler) {
            return new Scheduler(){

                public void schedule() throws Exception {
                    scheduler.schedule();
                }

                public void dispose() {
                    scheduler.dispose();
                }

                public void initialise() throws InitialisationException {
                    scheduler.initialise();
                }

                public void setName(String name) {
                    scheduler.setName(name);
                }

                public String getName() {
                    return scheduler.getName();
                }

                public void start() throws MuleException {
                }

                public void stop() throws MuleException {
                }
            };
        }
    }

    public static class FooComponent {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(String s) {
            List list = foo;
            synchronized (list) {
                foo.add(s);
            }
        }
    }
}

