/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessageCollection;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.store.ObjectStoreException;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.store.PartitionedInMemoryObjectStore;

public class CollectionAggregatorRouterCustomStoreTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "collection-aggregator-router-custom-store.xml";
    }

    @Test
    public void eventGroupWithCustomStore() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        List<String> list = Arrays.asList("first", "second");
        this.runFlow("splitter", CollectionAggregatorRouterCustomStoreTestCase.getTestMuleMessage(list));
        MuleMessageCollection request = (MuleMessageCollection)client.request("vm://out", 10000L);
        Assert.assertNotNull((Object)request);
        Assert.assertEquals((long)list.size(), (long)request.size());
        Assert.assertThat((Object)CustomPartitionableObjectStore.askedForKey, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)CustomPartitionableObjectStore.askedForPartition, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
    }

    public static class CustomPartitionableObjectStore
    extends PartitionedInMemoryObjectStore<Serializable> {
        private static Serializable askedForKey;
        private static Serializable askedForPartition;

        public Serializable retrieve(Serializable key, String partitionKey) throws ObjectStoreException {
            askedForKey = key;
            askedForPartition = partitionKey;
            return super.retrieve(key, partitionKey);
        }
    }
}

