/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.test.routing.CustomRouteResolver;
import org.mule.test.routing.DynamicRouterTestCase;
import org.mule.test.routing.IdentifiableCustomRouteResolver;

public class DynamicRoundRobinTestCase
extends DynamicRouterTestCase {
    private static final String DYNAMIC_ROUND_ROBIN = "dynamicRoundRobin";
    private static final String DYNAMIC_ROUND_ROBIN_CUSTOM_ID = "dynamicRoundRobinWithCustomId";
    private static final String MULTIPLE_ROUND_ROBIN = "multipleDynamicRoundRobin";
    private static final String MULTIPLE_ROUND_ROBIN_WITH_ID = "multipleDynamicRoundRobinWithId";
    private static final String ID = "id";
    private static final String FIRST_ROUTER_VAR = "first-router";
    private static final boolean FIRST_ROUTER = true;
    private static final int ID_1 = 1;
    private static final int ID_2 = 2;
    private static final int ID_3 = 3;

    protected String getConfigFile() {
        return "org/mule/test/integration/routing/dynamic-round-robin-config.xml";
    }

    @Test
    public void withRoutes() throws Exception {
        this.initCustomResolver();
        Flow testFlow = this.getTestFlow(DYNAMIC_ROUND_ROBIN);
        this.runFlowAndAssertResponse(testFlow, "a");
        this.runFlowAndAssertResponse(testFlow, "b");
        this.runFlowAndAssertResponse(testFlow, "c");
        this.runFlowAndAssertResponse(testFlow, "d");
        this.runFlowAndAssertResponse(testFlow, "a");
        this.runFlowAndAssertResponse(testFlow, "b");
        this.runFlowAndAssertResponse(testFlow, "c");
        this.runFlowAndAssertResponse(testFlow, "d");
    }

    @Test
    public void withRoutesAndCustomId() throws Exception {
        this.initIdentifiableCustomRouteResolver();
        Flow testFlow = this.getTestFlow(DYNAMIC_ROUND_ROBIN_CUSTOM_ID);
        this.runFlowAndAssertResponse(testFlow, Collections.singletonMap(ID, 1), "a");
        this.runFlowAndAssertResponse(testFlow, Collections.singletonMap(ID, 1), "b");
        this.runFlowAndAssertResponse(testFlow, Collections.singletonMap(ID, 2), "a");
        this.runFlowAndAssertResponse(testFlow, Collections.singletonMap(ID, 1), "c");
        this.runFlowAndAssertResponse(testFlow, Collections.singletonMap(ID, 2), "b");
        this.runFlowAndAssertResponse(testFlow, Collections.singletonMap(ID, 3), "a");
        this.runFlowAndAssertResponse(testFlow, Collections.singletonMap(ID, 1), "d");
        this.runFlowAndAssertResponse(testFlow, Collections.singletonMap(ID, 2), "c");
    }

    @Test
    public void testMultipleDynamicRouters() throws Exception {
        this.initCustomResolver();
        Flow testFlow = this.getTestFlow(MULTIPLE_ROUND_ROBIN);
        this.runFlowAndAssertResponse(testFlow, Collections.singletonMap(FIRST_ROUTER_VAR, true), "a");
        this.runFlowAndAssertResponse(testFlow, Collections.singletonMap(FIRST_ROUTER_VAR, true), "b");
        this.runFlowAndAssertResponse(testFlow, Collections.singletonMap(FIRST_ROUTER_VAR, false), "a");
        this.runFlowAndAssertResponse(testFlow, Collections.singletonMap(FIRST_ROUTER_VAR, true), "c");
        this.runFlowAndAssertResponse(testFlow, Collections.singletonMap(FIRST_ROUTER_VAR, false), "b");
    }

    @Test
    public void testMultipleDynamicRoutersWithId() throws Exception {
        this.initIdentifiableCustomRouteResolver();
        Flow testFlow = this.getTestFlow(MULTIPLE_ROUND_ROBIN_WITH_ID);
        this.runFlowAndAssertResponse(testFlow, this.getFlowVarsMap(true, 1), "a");
        this.runFlowAndAssertResponse(testFlow, this.getFlowVarsMap(true, 1), "b");
        this.runFlowAndAssertResponse(testFlow, this.getFlowVarsMap(true, 2), "a");
        this.runFlowAndAssertResponse(testFlow, this.getFlowVarsMap(false, 1), "a");
        this.runFlowAndAssertResponse(testFlow, this.getFlowVarsMap(false, 2), "a");
        this.runFlowAndAssertResponse(testFlow, this.getFlowVarsMap(false, 1), "b");
    }

    private Map<String, Object> getFlowVarsMap(boolean firstRouter, int id) {
        HashMap<String, Object> flowVars = new HashMap<String, Object>();
        flowVars.put(FIRST_ROUTER_VAR, firstRouter);
        flowVars.put(ID, id);
        return flowVars;
    }

    private void initCustomResolver() {
        CustomRouteResolver.routes.add(new CustomRouteResolver.AddLetterMessageProcessor("a"));
        CustomRouteResolver.routes.add(new CustomRouteResolver.AddLetterMessageProcessor("b"));
        CustomRouteResolver.routes.add(new CustomRouteResolver.AddLetterMessageProcessor("c"));
        CustomRouteResolver.routes.add(new CustomRouteResolver.AddLetterMessageProcessor("d"));
    }

    private void initIdentifiableCustomRouteResolver() {
        IdentifiableCustomRouteResolver.routes.add(new IdentifiableCustomRouteResolver.AddLetterMessageProcessor("a"));
        IdentifiableCustomRouteResolver.routes.add(new IdentifiableCustomRouteResolver.AddLetterMessageProcessor("b"));
        IdentifiableCustomRouteResolver.routes.add(new IdentifiableCustomRouteResolver.AddLetterMessageProcessor("c"));
        IdentifiableCustomRouteResolver.routes.add(new IdentifiableCustomRouteResolver.AddLetterMessageProcessor("d"));
    }

    private MuleEvent runFlowAndAssertResponse(Flow flow, Map<String, Object> flowVars, Object expectedMessage) throws Exception {
        MuleEvent event = DynamicRoundRobinTestCase.getTestEvent((Object)"Test Message");
        if (flowVars != null) {
            for (String key : flowVars.keySet()) {
                event.setFlowVariable(key, flowVars.get(key));
            }
        }
        MuleEvent response = flow.process(event);
        Assert.assertThat((Object)response.getMessageAsString(), (Matcher)Is.is((Object)expectedMessage));
        return response;
    }

    @Override
    public String getFlowName() {
        return DYNAMIC_ROUND_ROBIN;
    }
}

