/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.RandomStringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMessageCollection;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.client.MuleClient;
import org.mule.api.expression.RequiredValueException;
import org.mule.api.transport.PropertyScope;
import org.mule.tck.functional.FlowAssert;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

public class ForeachTestCase
extends FunctionalTestCase {
    @Rule
    public SystemProperty systemProperty = new SystemProperty("batch.size", "3");
    private MuleClient client;
    static String sampleXml = "<PurchaseOrder><Address><Name>Ellen Adams</Name></Address><Items><Item PartNumber=\"872-AA\"><Price>140</Price></Item><Item PartNumber=\"926-AA\"><Price>35</Price></Item></Items></PurchaseOrder>";

    @Before
    public void setUp() throws Exception {
        this.client = muleContext.getClient();
    }

    protected String getConfigFile() {
        return "foreach-test.xml";
    }

    @Test
    public void defaultConfiguration() throws Exception {
        ArrayList<String> payload = new ArrayList<String>();
        payload.add("julio");
        payload.add("sosa");
        MuleMessage result = this.client.send("vm://input-1", payload, null);
        Assert.assertTrue((boolean)(result.getPayload() instanceof Collection));
        Collection resultPayload = (Collection)result.getPayload();
        Assert.assertEquals((long)2L, (long)resultPayload.size());
        Assert.assertSame(payload, (Object)resultPayload);
        MuleMessage out = this.client.request("vm://out", (long)this.getTestTimeoutSecs());
        Assert.assertTrue((boolean)(out.getPayload() instanceof String));
        Assert.assertEquals((Object)"julio", (Object)out.getPayload());
        out = this.client.request("vm://out", (long)this.getTestTimeoutSecs());
        Assert.assertTrue((boolean)(out.getPayload() instanceof String));
        Assert.assertEquals((Object)"sosa", (Object)out.getPayload());
    }

    @Test
    public void defaultConfigurationPlusMP() throws Exception {
        ArrayList<String> payload = new ArrayList<String>();
        payload.add("syd");
        payload.add("barrett");
        MuleMessage result = this.client.send("vm://input-2", payload, null);
        Assert.assertTrue((boolean)(result.getPayload() instanceof Collection));
        Collection resultPayload = (Collection)result.getPayload();
        Assert.assertEquals((long)3L, (long)resultPayload.size());
        Assert.assertSame(payload, (Object)resultPayload);
        MuleMessage out = this.client.request("vm://out", (long)this.getTestTimeoutSecs());
        Assert.assertTrue((boolean)(out.getPayload() instanceof String));
        Assert.assertEquals((Object)"syd", (Object)out.getPayload());
        out = this.client.request("vm://out", (long)this.getTestTimeoutSecs());
        Assert.assertTrue((boolean)(out.getPayload() instanceof String));
        Assert.assertEquals((Object)"barrett", (Object)out.getPayload());
    }

    @Test
    public void defaultConfigurationExpression() throws Exception {
        ArrayList<String> names = new ArrayList<String>();
        names.add("residente");
        names.add("visitante");
        HashMap<String, ArrayList<String>> props = new HashMap<String, ArrayList<String>>();
        props.put("names", names);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"message payload", props, muleContext);
        MuleMessage result = this.client.send("vm://input-3", (MuleMessage)message);
        Assert.assertTrue((boolean)(result.getPayload() instanceof String));
        Assert.assertEquals((long)names.size(), (long)((Collection)message.getOutboundProperty("names")).size());
        MuleMessage out = this.client.request("vm://out", (long)this.getTestTimeoutSecs());
        Assert.assertTrue((boolean)(out.getPayload() instanceof String));
        Assert.assertEquals((Object)"residente", (Object)out.getPayload());
        out = this.client.request("vm://out", (long)this.getTestTimeoutSecs());
        Assert.assertTrue((boolean)(out.getPayload() instanceof String));
        Assert.assertEquals((Object)"visitante", (Object)out.getPayload());
    }

    @Test
    public void partitionedConfiguration() throws Exception {
        ArrayList<String> payload = new ArrayList<String>();
        payload.add("gulp");
        payload.add("oktubre");
        payload.add("un baion");
        payload.add("bang bang");
        payload.add("la mosca");
        MuleMessage result = this.client.send("vm://input-4", payload, null);
        Assert.assertTrue((boolean)(result.getPayload() instanceof Collection));
        Collection resultPayload = (Collection)result.getPayload();
        Assert.assertEquals((long)5L, (long)resultPayload.size());
        Assert.assertSame(payload, (Object)resultPayload);
        MuleMessage out = this.client.request("vm://out", (long)this.getTestTimeoutSecs());
        Assert.assertTrue((boolean)(out.getPayload() instanceof Collection));
        Collection outPayload = (Collection)out.getPayload();
        Assert.assertEquals((long)3L, (long)outPayload.size());
        out = this.client.request("vm://out", (long)this.getTestTimeoutSecs());
        Assert.assertTrue((boolean)(out.getPayload() instanceof Collection));
        outPayload = (Collection)out.getPayload();
        Assert.assertEquals((long)2L, (long)outPayload.size());
    }

    @Test
    public void rootMessageConfiguration() throws Exception {
        ArrayList<String> payload = new ArrayList<String>();
        payload.add("pyotr");
        payload.add("ilych");
        DefaultMuleMessage parent = new DefaultMuleMessage(payload, muleContext);
        MuleMessage result = this.client.send("vm://input-5", (MuleMessage)parent);
        Assert.assertTrue((boolean)(result.getPayload() instanceof Collection));
        Collection resultPayload = (Collection)result.getPayload();
        Assert.assertEquals((long)2L, (long)resultPayload.size());
        Assert.assertSame(payload, (Object)resultPayload);
        Assert.assertSame((Object)parent.getPayload(), (Object)((MuleMessage)result.getInboundProperty("parent")).getPayload());
    }

    @Test
    public void counterConfiguration() throws Exception {
        ArrayList<String> payload = new ArrayList<String>();
        payload.add("wolfgang");
        payload.add("amadeus");
        payload.add("mozart");
        DefaultMuleMessage parent = new DefaultMuleMessage(payload, muleContext);
        MuleMessage result = this.client.send("vm://input-6", (MuleMessage)parent);
        Assert.assertTrue((boolean)(result.getPayload() instanceof Collection));
        Collection resultPayload = (Collection)result.getPayload();
        Assert.assertEquals((long)3L, (long)resultPayload.size());
        Assert.assertSame(payload, (Object)resultPayload);
        Assert.assertEquals((long)((Integer)result.getInboundProperty("msg-last-index")).intValue(), (long)3L);
    }

    @Test
    public void messageCollectionConfiguration() throws Exception {
        DefaultMessageCollection msgCollection = new DefaultMessageCollection(muleContext);
        for (int i = 0; i < 10; ++i) {
            DefaultMuleMessage msg = new DefaultMuleMessage((Object)("message-" + i), muleContext);
            msg.setProperty("out", (Object)("out" + (i + 1)), PropertyScope.OUTBOUND);
            msgCollection.addMessage((MuleMessage)msg);
        }
        MuleMessage result = this.client.send("vm://input-7", (MuleMessage)msgCollection);
        Assert.assertEquals((long)10L, (long)((Integer)result.getInboundProperty("totalMessages")).intValue());
        Assert.assertEquals((Object)msgCollection.getPayload(), (Object)result.getPayload());
        FlowAssert.verify((String)"message-collection-config");
    }

    @Test
    public void messageCollectionConfigurationOneWay() throws Exception {
        DefaultMessageCollection msgCollection = new DefaultMessageCollection(muleContext);
        for (int i = 0; i < 10; ++i) {
            DefaultMuleMessage msg = new DefaultMuleMessage((Object)("message-" + i), muleContext);
            msg.setProperty("out", (Object)("out" + (i + 1)), PropertyScope.OUTBOUND);
            msgCollection.addMessage((MuleMessage)msg);
        }
        this.client.dispatch("vm://input-71", (MuleMessage)msgCollection);
        FlowAssert.verify((String)"message-collection-config-one-way");
    }

    @Test
    public void mapPayload() throws Exception {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("name", "david");
        payload.put("surname", "bowie");
        DefaultMuleMessage parent = new DefaultMuleMessage(payload, muleContext);
        MuleMessage result = this.client.send("vm://input-8", (MuleMessage)parent);
        Assert.assertTrue((boolean)(result.getPayload() instanceof Map));
        Map resultPayload = (Map)result.getPayload();
        Assert.assertEquals((long)payload.size(), (long)resultPayload.size());
        Assert.assertEquals((long)payload.size(), (long)((Integer)result.getInboundProperty("totalMessages")).intValue());
        Assert.assertSame(payload, (Object)resultPayload);
    }

    @Test
    public void mapExpression() throws Exception {
        ArrayList<String> names = new ArrayList<String>();
        names.add("Sergei");
        names.add("Vasilievich");
        names.add("Rachmaninoff");
        HashMap<String, ArrayList<String>> props = new HashMap<String, ArrayList<String>>();
        props.put("names", names);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"message payload", props, muleContext);
        MuleMessage result = this.client.send("vm://input-9", (MuleMessage)message);
        Assert.assertTrue((boolean)(result.getPayload() instanceof String));
        Assert.assertEquals((long)names.size(), (long)((Collection)message.getOutboundProperty("names")).size());
        Assert.assertEquals((long)names.size(), (long)((Integer)result.getInboundProperty("totalMessages")).intValue());
    }

    @Test
    public void xmlUpdate() throws Exception {
        this.client.send("vm://input-10", (Object)sampleXml, null);
        FlowAssert.verify((String)"process-order-update");
    }

    @Test
    public void xmlUpdateByteArray() throws Exception {
        byte[] xmlba = sampleXml.getBytes();
        this.client.send("vm://input-10", (Object)xmlba, null);
        FlowAssert.verify((String)"process-order-update");
    }

    @Test
    public void xmlUpdateInputStream() throws Exception {
        ByteArrayInputStream xmlis = new ByteArrayInputStream(sampleXml.getBytes());
        this.client.send("vm://input-10-is", (Object)xmlis, null);
        FlowAssert.verify((String)"process-order-update-is");
    }

    @Test
    public void xmlUpdateMel() throws Exception {
        this.client.send("vm://input-10-mel", (Object)sampleXml, null);
        FlowAssert.verify((String)"process-order-update-mel");
    }

    @Test
    public void jsonUpdate() throws Exception {
        String json = "{\"order\": {\"name\": \"Ellen\", \"email\": \"ellen@mail.com\", \"items\": [{\"key1\": \"value1\"}, {\"key2\": \"value2\"}] } }";
        this.client.send("vm://input-11", (Object)json, null);
        FlowAssert.verify((String)"process-json-update");
    }

    @Test
    public void arrayPayload() throws Exception {
        String[] payload = new String[]{"uno", "dos", "tres"};
        DefaultMuleMessage parent = new DefaultMuleMessage((Object)payload, muleContext);
        MuleMessage result = this.client.send("vm://input-12", (MuleMessage)parent);
        Assert.assertTrue((boolean)(result.getPayload() instanceof String[]));
        String[] resultPayload = (String[])result.getPayload();
        Assert.assertEquals((long)payload.length, (long)resultPayload.length);
        Assert.assertSame((Object)payload, (Object)resultPayload);
        FlowAssert.verify((String)"array-expression-config");
    }

    @Test
    public void variableScope() throws Exception {
        ArrayList<String> payload = new ArrayList<String>();
        payload.add("pedro");
        payload.add("rodolfo");
        payload.add("roque");
        DefaultMuleMessage parent = new DefaultMuleMessage(payload, muleContext);
        MuleMessage result = this.client.send("vm://input-13", (MuleMessage)parent);
        Assert.assertTrue((String)"Counter variable should not be visible outside foreach scope.", (result.getExceptionPayload() != null && result.getExceptionPayload().getException().getCause() instanceof RequiredValueException ? 1 : 0) != 0);
    }

    @Test
    public void twoOneAfterAnother() throws Exception {
        ArrayList<String> payload = new ArrayList<String>();
        payload.add("rosa");
        payload.add("maria");
        payload.add("florencia");
        DefaultMuleMessage parent = new DefaultMuleMessage(payload, muleContext);
        MuleMessage result = this.client.send("vm://input-14", (MuleMessage)parent);
        Assert.assertTrue((boolean)(result.getPayload() instanceof Collection));
        Collection resultPayload = (Collection)result.getPayload();
        Assert.assertEquals((long)3L, (long)resultPayload.size());
        Assert.assertSame(payload, (Object)resultPayload);
        Assert.assertEquals((long)3L, (long)((Integer)result.getInboundProperty("msg-total-messages")).intValue());
    }

    @Test
    public void nestedConfig() throws Exception {
        List<List<String>> payload = this.createNestedPayload();
        DefaultMuleMessage parent = new DefaultMuleMessage(payload, muleContext);
        MuleMessage result = this.client.send("vm://input-15", (MuleMessage)parent);
        Assert.assertTrue((boolean)(result.getPayload() instanceof Collection));
        Collection resultPayload = (Collection)result.getPayload();
        Assert.assertEquals((long)3L, (long)resultPayload.size());
        Assert.assertSame(payload, (Object)resultPayload);
        for (int i = 0; i < payload.size(); ++i) {
            for (int j = 0; j < payload.get(i).size(); ++j) {
                MuleMessage out = this.client.request("vm://out", (long)this.getTestTimeoutSecs());
                Assert.assertTrue((boolean)(out.getPayload() instanceof String));
                Assert.assertEquals((Object)payload.get(i).get(j), (Object)out.getPayload());
            }
        }
    }

    @Test
    public void nestedCounters() throws Exception {
        List<List<String>> payload = this.createNestedPayload();
        DefaultMuleMessage parent = new DefaultMuleMessage(payload, muleContext);
        MuleMessage result = this.client.send("vm://input-16", (MuleMessage)parent);
        Assert.assertTrue((boolean)(result.getPayload() instanceof Collection));
        Collection resultPayload = (Collection)result.getPayload();
        Assert.assertEquals((long)3L, (long)resultPayload.size());
        Assert.assertSame(payload, (Object)resultPayload);
        for (int i = 0; i < payload.size(); ++i) {
            MuleMessage out;
            for (int j = 0; j < payload.get(i).size(); ++j) {
                out = this.client.request("vm://out", (long)this.getTestTimeoutSecs());
                Assert.assertEquals((String)"The nested counters are not consistent.", (long)(j + 1), (long)((Integer)out.getInboundProperty("j")).intValue());
            }
            out = this.client.request("vm://out", (long)this.getTestTimeoutSecs());
            Assert.assertEquals((String)"The nested counters are not consistent", (long)(i + 1), (long)((Integer)out.getInboundProperty("i")).intValue());
        }
    }

    private List<List<String>> createNestedPayload() {
        ArrayList<List<String>> payload = new ArrayList<List<String>>();
        ArrayList<String> elem1 = new ArrayList<String>();
        ArrayList<String> elem2 = new ArrayList<String>();
        ArrayList<String> elem3 = new ArrayList<String>();
        elem1.add("a1");
        elem1.add("a2");
        elem1.add("a3");
        elem2.add("b1");
        elem2.add("b2");
        elem3.add("c1");
        payload.add(elem1);
        payload.add(elem2);
        payload.add(elem3);
        return payload;
    }

    @Test
    public void propertiesRestored() throws Exception {
        String[] payload = new String[]{"uno", "dos", "tres"};
        DefaultMuleMessage parent = new DefaultMuleMessage((Object)payload, muleContext);
        MuleMessage result = this.client.send("vm://input-17", (MuleMessage)parent);
        Assert.assertTrue((boolean)(result.getPayload() instanceof String[]));
        String[] resultPayload = (String[])result.getPayload();
        Assert.assertEquals((long)payload.length, (long)resultPayload.length);
        Assert.assertSame((Object)payload, (Object)resultPayload);
        FlowAssert.verify((String)"foreach-properties-restored");
    }

    @Test
    public void mvelList() throws Exception {
        DefaultMuleMessage parent = new DefaultMuleMessage(null, muleContext);
        this.client.send("vm://input-18", (MuleMessage)parent);
        MuleMessage out = this.client.request("vm://out", (long)this.getTestTimeoutSecs());
        Assert.assertTrue((boolean)(out.getPayload() instanceof String));
        String outPayload = (String)out.getPayload();
        Assert.assertEquals((Object)"foo", (Object)outPayload);
        out = this.client.request("vm://out", (long)this.getTestTimeoutSecs());
        Assert.assertTrue((boolean)(out.getPayload() instanceof String));
        outPayload = (String)out.getPayload();
        Assert.assertEquals((Object)"bar", (Object)outPayload);
    }

    @Test
    public void mvelMap() throws Exception {
        DefaultMuleMessage parent = new DefaultMuleMessage(null, muleContext);
        this.client.send("vm://input-19", (MuleMessage)parent);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("key1", "val1");
        m.put("key2", "val2");
        MuleMessage out = this.client.request("vm://out", (long)this.getTestTimeoutSecs());
        Assert.assertTrue((boolean)(out.getPayload() instanceof String));
        String outPayload = (String)out.getPayload();
        Assert.assertTrue((boolean)m.containsValue(outPayload));
        out = this.client.request("vm://out", (long)this.getTestTimeoutSecs());
        Assert.assertTrue((boolean)(out.getPayload() instanceof String));
        outPayload = (String)out.getPayload();
        Assert.assertTrue((boolean)m.containsValue(outPayload));
    }

    @Test
    public void mvelCollection() throws Exception {
        DefaultMuleMessage parent = new DefaultMuleMessage(null, muleContext);
        this.client.send("vm://input-20", (MuleMessage)parent);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("key1", "val1");
        m.put("key2", "val2");
        MuleMessage out = this.client.request("vm://out", (long)this.getTestTimeoutSecs());
        Assert.assertTrue((boolean)(out.getPayload() instanceof String));
        String outPayload = (String)out.getPayload();
        Assert.assertTrue((boolean)m.containsValue(outPayload));
        out = this.client.request("vm://out", (long)this.getTestTimeoutSecs());
        Assert.assertTrue((boolean)(out.getPayload() instanceof String));
        outPayload = (String)out.getPayload();
        Assert.assertTrue((boolean)m.containsValue(outPayload));
    }

    @Test
    public void mvelArray() throws Exception {
        DefaultMuleMessage parent = new DefaultMuleMessage(null, muleContext);
        this.client.send("vm://input-21", (MuleMessage)parent);
        MuleMessage out = this.client.request("vm://out", (long)this.getTestTimeoutSecs());
        Assert.assertTrue((boolean)(out.getPayload() instanceof String));
        String outPayload = (String)out.getPayload();
        Assert.assertEquals((Object)"foo", (Object)outPayload);
        FlowAssert.verify((String)"mvel-array");
        out = this.client.request("vm://out", (long)this.getTestTimeoutSecs());
        Assert.assertTrue((boolean)(out.getPayload() instanceof String));
        outPayload = (String)out.getPayload();
        Assert.assertEquals((Object)"bar", (Object)outPayload);
    }

    @Test
    public void mvelError() throws Exception {
        try {
            this.runFlow("mvel-error");
            Assert.fail((String)"MessagingException expected");
        }
        catch (MessagingException me) {
            Assert.assertThat((Object)((String)me.getInfo().get("Element")), (Matcher)CoreMatchers.startsWith((String)"/mvel-error/processors/0 @"));
        }
    }

    @Test
    public void requestReply() throws Exception {
        DefaultMuleMessage parent = new DefaultMuleMessage(null, muleContext);
        MuleMessage msg = this.client.send("vm://input-22", (MuleMessage)parent);
        junit.framework.Assert.assertNotNull((Object)msg);
        Assert.assertEquals((Object)msg.getProperty("processedMessages", PropertyScope.SESSION), (Object)"0123");
    }

    @Test
    public void foreachWithAsync() throws Exception {
        int size = 20;
        ArrayList<String> list = new ArrayList<String>(20);
        for (int i = 0; i < 20; ++i) {
            list.add(RandomStringUtils.randomAlphabetic((int)10));
        }
        CountDownLatch latch = new CountDownLatch(20);
        MuleEvent event = ForeachTestCase.getTestEvent(list);
        event.setFlowVariable("latch", (Object)latch);
        this.testFlow("foreachWithAsync", event);
        latch.await(10L, TimeUnit.SECONDS);
    }

    @Test
    public void initializesForeachOnSubFLow() throws Exception {
        this.getSubFlow("sub-flow-with-foreach");
    }
}

