/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.MuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinTestCase
extends FunctionalTestCase {
    private static final Logger logger = LoggerFactory.getLogger(RoundRobinTestCase.class);
    private static final int NUMBER_OF_MESSAGES = 10;
    private static final int NUMBER_OF_WRITERS = 10;
    private static final int NUMBER_OF_ENDPOINTS = 5;
    private MuleClient client;

    protected String getConfigFile() {
        return "round-robin-test.xml";
    }

    @Test
    public void testRoundRobin() throws Exception {
        this.client = muleContext.getClient();
        ArrayList<Thread> writers = new ArrayList<Thread>();
        for (int i = 0; i < 10; ++i) {
            writers.add(new Thread(new MessageWriter(i)));
        }
        for (Thread writer : writers) {
            writer.start();
        }
        for (Thread writer : writers) {
            writer.join();
        }
        int j = 0;
        for (int i = 0; i < 100; ++i) {
            String path = "vm://output" + j;
            MuleMessage msg = this.client.request(path, 0L);
            Assert.assertNotNull((Object)msg);
            logger.debug(path + ": " + msg.getPayloadAsString());
            j = (j + 1) % 5;
        }
    }

    class MessageWriter
    implements Runnable {
        private int id;

        MessageWriter(int id) {
            this.id = id;
        }

        @Override
        public void run() {
            for (int i = 0; i < 10; ++i) {
                try {
                    RoundRobinTestCase.this.client.send("vm://input", (Object)("Writer " + this.id + " Message " + i), null);
                    continue;
                }
                catch (MuleException ex) {
                    logger.info("Unexpected exception dispatching message", (Throwable)ex);
                }
            }
        }
    }
}

