/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMessageCollection;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.ExceptionPayload;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.AggregationContext;
import org.mule.api.routing.ResponseTimeoutException;
import org.mule.api.transport.DispatchException;
import org.mule.construct.Flow;
import org.mule.module.http.api.HttpConstants;
import org.mule.routing.AggregationStrategy;
import org.mule.routing.CompositeRoutingException;
import org.mule.tck.functional.FlowAssert;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.concurrent.Latch;

public class ScatterGatherRouterTestCase
extends FunctionalTestCase {
    private static final String EXCEPTION_MESSAGE_TITLE_PREFIX = "Exception(s) were found for route(s): " + SystemUtils.LINE_SEPARATOR;
    private static Set<Thread> capturedThreads;
    @Rule
    public DynamicPort httpPort = new DynamicPort("http.port");

    protected String getConfigFile() {
        return "scatter-gather-test.xml";
    }

    protected void doSetUp() throws Exception {
        capturedThreads = new HashSet<Thread>();
    }

    @Test
    public void minimalConfiguration() throws Exception {
        this.testFlow("minimalConfig", ScatterGatherRouterTestCase.getTestEvent((Object)""));
    }

    @Test(expected=MessagingException.class)
    public void consumablePayload() throws Exception {
        this.testFlow("minimalConfig", ScatterGatherRouterTestCase.getTestEvent((Object)new ByteArrayInputStream("hello world".getBytes())));
    }

    @Test
    public void timeout() throws Exception {
        try {
            this.runFlow("timeout");
            Assert.fail((String)"Was expecting a timeout");
        }
        catch (CompositeRoutingException e) {
            MuleEvent response = e.getEvent();
            ExceptionPayload ep = response.getMessage().getExceptionPayload();
            Assert.assertThat((Object)ep, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            Assert.assertThat((Object)((Object)e), (Matcher)CoreMatchers.sameInstance((Object)ep.getException()));
            Map exceptions = e.getExceptions();
            Assert.assertThat((Object)1, (Matcher)CoreMatchers.is((Object)exceptions.size()));
            Assert.assertThat(exceptions.get(2), (Matcher)CoreMatchers.instanceOf(ResponseTimeoutException.class));
        }
    }

    @Test
    public void routeWithException() throws Exception {
        this.assertRouteException("routeWithException", EXCEPTION_MESSAGE_TITLE_PREFIX + "\t1: org.mule.tck.exceptions.FunctionalTestException: Functional Test Service Exception. Component that caused exception is:", "}.");
    }

    @Test
    public void routeWithExceptionWithMessage() throws Exception {
        this.assertRouteException("routeWithExceptionWithMessage", EXCEPTION_MESSAGE_TITLE_PREFIX + "\t1: org.mule.tck.exceptions.FunctionalTestException: I'm a message. Component that caused exception is:", "}.");
    }

    @Test
    public void routeWithNonMuleException() throws Exception {
        this.assertRouteException("routeWithNonMuleException", EXCEPTION_MESSAGE_TITLE_PREFIX + "\t1: java.lang.NullPointerException: nonMule. Component that caused exception is:", "}.");
    }

    @Test
    public void routeWithMelException() throws Exception {
        this.assertRouteException("routeWithMelException", EXCEPTION_MESSAGE_TITLE_PREFIX + "\t1: Execution of the expression \"invalidExpr\" failed. (org.mule.api.expression.ExpressionRuntimeException).", ").");
    }

    @Test
    public void routeWithExceptionInSequentialProcessing() throws Exception {
        this.assertRouteException("routeWithExceptionInSequentialProcessing", EXCEPTION_MESSAGE_TITLE_PREFIX + "\t1: org.mule.tck.exceptions.FunctionalTestException: Functional Test Service Exception. Component that caused exception is:", "}.");
    }

    private void assertRouteException(String flow, String exceptionMessageStart, String exceptionMessageEnd) throws Exception {
        try {
            this.runFlow(flow);
            Assert.fail((String)"Was expecting a failure");
        }
        catch (CompositeRoutingException e) {
            MuleEvent response = e.getEvent();
            ExceptionPayload ep = response.getMessage().getExceptionPayload();
            Assert.assertThat((Object)ep, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            Assert.assertThat((Object)((Object)e), (Matcher)CoreMatchers.sameInstance((Object)ep.getException()));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)exceptionMessageStart));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.endsWith((String)exceptionMessageEnd));
            Map exceptions = e.getExceptions();
            Assert.assertThat((Object)1, (Matcher)CoreMatchers.is((Object)exceptions.size()));
            Assert.assertThat(exceptions.get(1), (Matcher)CoreMatchers.instanceOf(DispatchException.class));
        }
    }

    @Test
    public void customMergeStrategyByName() throws Exception {
        this.testFlow("customMergeStrategyByName", ScatterGatherRouterTestCase.getTestEvent((Object)""));
    }

    @Test
    public void customMergeStrategyByRef() throws Exception {
        this.testFlow("customMergeStrategyByRef", ScatterGatherRouterTestCase.getTestEvent((Object)""));
    }

    @Test
    public void sequentialProcessing() throws Exception {
        this.runFlow("sequentialProcessing", "");
        Assert.assertThat(capturedThreads, (Matcher)Matchers.hasSize((int)1));
        FlowAssert.verify((String)"customThreadingProfile");
    }

    @Test
    public void requestResponseInboundEndpoint() throws Exception {
        muleContext.getClient().send("vm://requestResponseInboundEndpoint", ScatterGatherRouterTestCase.getTestEvent((Object)"").getMessage());
        FlowAssert.verify((String)"requestResponseInboundEndpoint");
    }

    @Test
    public void oneWayInboundEndpoint() throws Exception {
        muleContext.getClient().send("vm://oneWayInboundEndpoint", ScatterGatherRouterTestCase.getTestEvent((Object)"").getMessage());
        FlowAssert.verify((String)"oneWayInboundEndpoint");
    }

    @Test
    public void routesWithForeachAndInboundEndpoint() throws Exception {
        String[] payload = new String[]{"apple", "banana", "orange"};
        muleContext.getClient().send("vm://routesWithForeachAndInboundEndpoint", ScatterGatherRouterTestCase.getTestEvent(Arrays.asList(payload)).getMessage());
        FlowAssert.verify((String)"routesWithForeachAndInboundEndpoint");
    }

    @Test
    public void exceptionStrategy() throws Exception {
        this.testFlow("exceptionStrategy", ScatterGatherRouterTestCase.getTestEvent((Object)""));
    }

    @Test
    public void failedEventInAggregationStrategy() throws Exception {
        this.runFlow("failedEventInAggregationStrategy", ScatterGatherRouterTestCase.getTestEvent((Object)""));
    }

    @Test
    public void failingMergeStrategy() throws Exception {
        try {
            this.runFlow("failingMergeStrategy", ScatterGatherRouterTestCase.getTestEvent((Object)""));
            Assert.fail((String)"Was expecting a exception");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(UnsupportedOperationException.class));
        }
    }

    @Test
    public void messageProperties() throws Exception {
        this.testFlow("messageProperties", ScatterGatherRouterTestCase.getTestEvent((Object)""));
    }

    @Test
    public void oneWayRouteWithSingleResponse() throws Exception {
        muleContext.getClient().send("vm://oneWayRouteWithSingleResponse", ScatterGatherRouterTestCase.getTestEvent((Object)"").getMessage());
        FlowAssert.verify((String)"oneWayRouteWithSingleResponse");
    }

    @Test
    public void oneWayRouteWithMultipleResponses() throws Exception {
        muleContext.getClient().send("vm://oneWayRouteWithMultipleResponses", ScatterGatherRouterTestCase.getTestEvent((Object)"").getMessage());
        FlowAssert.verify((String)"oneWayRouteWithMultipleResponses");
    }

    @Test
    public void expressionFilterRoute() throws Exception {
        muleContext.getClient().send("vm://expressionFilterRoute", ScatterGatherRouterTestCase.getTestEvent((Object)"").getMessage());
        FlowAssert.verify((String)"expressionFilterRoute");
    }

    @Test
    public void doesThreading() throws Exception {
        MuleEvent event = ScatterGatherRouterTestCase.getTestEvent((Object)"");
        event.setFlowVariable("latch", (Object)new Latch());
        this.testFlow("doesThreading", event);
        Assert.assertThat(capturedThreads, (Matcher)Matchers.hasSize((int)3));
    }

    @Test
    public void oneWayRoutesOnly() throws Exception {
        muleContext.getClient().send("vm://oneWayRoutesOnly", ScatterGatherRouterTestCase.getTestEvent((Object)"").getMessage());
        FlowAssert.verify((String)"oneWayRoutesOnly");
    }

    @Test
    public void setsVariablesAfterRouting() throws Exception {
        this.runFlow("setsVariablesAfterRouting");
        FlowAssert.verify((String)"setsVariablesAfterRouting");
    }

    @Test
    public void returnsCorrectDataType() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        message.setOutboundProperty("Content-Type", (Object)"application/json");
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)Mockito.mock(Flow.class));
        MuleMessage response = this.runFlow("dataType", (MuleEvent)event).getMessage();
        Assert.assertThat((Object)response, (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(DefaultMessageCollection.class)));
        Assert.assertThat((Object)((DefaultMessageCollection)response).size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)((DefaultMessageCollection)response).getMessage(0).getDataType().getMimeType(), (Matcher)CoreMatchers.is((Object)"text/plain"));
        Assert.assertThat((Object)((DefaultMessageCollection)response).getMessage(1).getDataType().getMimeType(), (Matcher)CoreMatchers.is((Object)"*/*"));
        Assert.assertThat((Object)((DefaultMessageCollection)response).getMessage(2).getDataType().getMimeType(), (Matcher)CoreMatchers.is((Object)"*/*"));
    }

    @Test
    public void nonBlockingFallbackToBlocking() throws Exception {
        Response response = Request.Get((String)("http://localhost:" + this.httpPort.getNumber() + "/ok")).execute();
        HttpResponse httpResponse = response.returnResponse();
        Assert.assertThat((Object)httpResponse.getStatusLine().getStatusCode(), (Matcher)CoreMatchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        Assert.assertThat((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), (Matcher)Matchers.not((Matcher)Matchers.isEmptyOrNullString()));
    }

    @Test
    public void nonBlockingFallbackToBlockingError() throws Exception {
        Response response = Request.Get((String)("http://localhost:" + this.httpPort.getNumber() + "/error")).execute();
        HttpResponse httpResponse = response.returnResponse();
        Assert.assertThat((Object)httpResponse.getStatusLine().getStatusCode(), (Matcher)CoreMatchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        Assert.assertThat((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), (Matcher)CoreMatchers.is((Object)"error"));
    }

    public static class FlatteningTestAggregationStrategy
    implements AggregationStrategy {
        public MuleEvent aggregate(AggregationContext context) throws MuleException {
            MuleEvent event = context.getOriginalEvent();
            event.getMessage().setPayload((Object)context.getEvents());
            return event;
        }
    }

    public static class ThreadCaptor
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            Latch latch;
            capturedThreads.add(Thread.currentThread());
            if (capturedThreads.size() > 1 && (latch = (Latch)event.getFlowVariable("latch")) != null) {
                latch.release();
            }
            return event;
        }
    }

    public static class FailingAggregationStrategy
    implements AggregationStrategy {
        public MuleEvent aggregate(AggregationContext context) throws MuleException {
            throw new UnsupportedOperationException();
        }
    }

    public static class TestAggregationStrategy
    implements AggregationStrategy {
        public MuleEvent aggregate(AggregationContext context) throws MuleException {
            StringBuilder builder = new StringBuilder();
            for (MuleEvent event : context.getEvents()) {
                if (builder.length() > 0) {
                    builder.append(' ');
                }
                builder.append(event.getMessage().getPayload());
            }
            context.getOriginalEvent().getMessage().setPayload((Object)builder.toString());
            return context.getOriginalEvent();
        }
    }
}

