/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.tck.junit4.FunctionalTestCase;

public class UntilSuccessfulWithSplitterTestCase
extends FunctionalTestCase {
    private static final int TIMEOUT = 5;
    private static Multiset<String> seenPayloads;
    private static CountDownLatch latch;

    protected String getConfigFile() {
        return "until-successful-with-splitter.xml";
    }

    protected void doSetUp() throws Exception {
        seenPayloads = HashMultiset.create();
        latch = new CountDownLatch(2);
    }

    @Test
    public void withSplitter() throws Exception {
        this.runFlow("withSplitter");
        Assert.assertThat((Object)latch.await(5L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)seenPayloads.count((Object)"a"), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)seenPayloads.count((Object)"b"), (Matcher)CoreMatchers.is((Object)2));
    }

    public static class FailAtFirstAttempt
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            String payload = event.getMessageAsString();
            seenPayloads.add((Object)payload);
            if (seenPayloads.count((Object)payload) == 1) {
                throw new RuntimeException("first time");
            }
            latch.countDown();
            return event;
        }
    }
}

