/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.tck;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.expression.ExpressionManager;
import org.mule.expression.DefaultExpressionManager;
import org.mule.tck.functional.AssertionMessageProcessor;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=MockitoJUnitRunner.class)
public class AssertionMessageProcessorTestCase
extends AbstractMuleTestCase {
    protected FlowConstruct flowConstruct;
    protected ExpressionManager expressionManager;
    protected final String TRUE_EXPRESSION = "trueExpression";
    protected final String FALSE_EXPRESSION = "falseExpression";
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected MuleContext muleContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected MuleEvent mockEvent;
    @Mock
    protected MuleMessage muleMessage;

    @Before
    public void initialise() {
        Mockito.when((Object)this.mockEvent.getMessage()).thenReturn((Object)this.muleMessage);
        Mockito.when((Object)this.muleMessage.getMuleContext()).thenReturn((Object)this.muleContext);
        this.expressionManager = (ExpressionManager)Mockito.mock(DefaultExpressionManager.class);
        Mockito.when((Object)this.expressionManager.isValidExpression(Matchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.expressionManager.evaluateBoolean((String)Matchers.eq((Object)"trueExpression"), (MuleEvent)Matchers.any(MuleEvent.class), Matchers.anyBoolean(), Matchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.expressionManager.evaluateBoolean((String)Matchers.eq((Object)"falseExpression"), (MuleEvent)Matchers.any(MuleEvent.class), Matchers.anyBoolean(), Matchers.anyBoolean())).thenReturn((Object)false);
        Mockito.when((Object)this.muleContext.getExpressionManager()).thenReturn((Object)this.expressionManager);
        this.flowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        Mockito.when((Object)this.flowConstruct.getMuleContext()).thenReturn((Object)this.muleContext);
        Mockito.when((Object)this.flowConstruct.getName()).thenReturn((Object)"MockedFlowConstruct");
    }

    @Test
    public void startAssertionMessageProcessor() throws Exception {
        AssertionMessageProcessor asp = this.createAssertionMessageProcessor();
        asp.setFlowConstruct(this.flowConstruct);
        asp.start();
    }

    @Test
    public void processDummyEvent() throws Exception {
        AssertionMessageProcessor asp = this.createAssertionMessageProcessor();
        asp.setFlowConstruct(this.flowConstruct);
        asp.start();
        asp.process(this.mockEvent);
    }

    @Test
    public void processValidEvent() throws Exception {
        AssertionMessageProcessor asp = this.createAssertionMessageProcessor();
        asp.setFlowConstruct(this.flowConstruct);
        asp.setExpression("trueExpression");
        asp.start();
        asp.process(this.mockEvent);
        Assert.assertFalse((boolean)asp.expressionFailed());
        Assert.assertFalse((boolean)asp.countFailOrNullEvent());
    }

    @Test
    public void processInvalidEvent() throws Exception {
        AssertionMessageProcessor asp = this.createAssertionMessageProcessor();
        asp.setFlowConstruct(this.flowConstruct);
        asp.setExpression("falseExpression");
        asp.start();
        asp.process(this.mockEvent);
        Assert.assertTrue((boolean)asp.expressionFailed());
        Assert.assertFalse((boolean)asp.countFailOrNullEvent());
    }

    @Test
    public void processZeroEvents() throws Exception {
        AssertionMessageProcessor asp = this.createAssertionMessageProcessor();
        asp.setFlowConstruct(this.flowConstruct);
        asp.setExpression("trueExpression");
        asp.start();
        Assert.assertFalse((boolean)asp.expressionFailed());
        Assert.assertTrue((boolean)asp.countFailOrNullEvent());
    }

    @Test
    public void processSomeValidEvents() throws Exception {
        AssertionMessageProcessor asp = this.createAssertionMessageProcessor();
        asp.setFlowConstruct(this.flowConstruct);
        asp.setExpression("trueExpression");
        asp.start();
        asp.process(this.mockEvent);
        asp.process(this.mockEvent);
        asp.process(this.mockEvent);
        Assert.assertFalse((boolean)asp.expressionFailed());
        Assert.assertFalse((boolean)asp.countFailOrNullEvent());
    }

    @Test
    public void processSomeInvalidEvent() throws Exception {
        AssertionMessageProcessor asp = this.createAssertionMessageProcessor();
        asp.setFlowConstruct(this.flowConstruct);
        asp.setExpression("trueExpression");
        asp.start();
        asp.process(this.mockEvent);
        asp.process(this.mockEvent);
        asp.setExpression("falseExpression");
        asp.process(this.mockEvent);
        asp.setExpression("trueExpression");
        asp.process(this.mockEvent);
        Assert.assertTrue((boolean)asp.expressionFailed());
        Assert.assertFalse((boolean)asp.countFailOrNullEvent());
    }

    @Test
    public void processMoreThanCountEvents() throws Exception {
        AssertionMessageProcessor asp = this.createAssertionMessageProcessor();
        asp.setFlowConstruct(this.flowConstruct);
        asp.setExpression("trueExpression");
        asp.setCount(5);
        asp.start();
        for (int i = 0; i < 6; ++i) {
            asp.process(this.mockEvent);
        }
        Assert.assertFalse((boolean)asp.expressionFailed());
        Assert.assertTrue((boolean)asp.countFailOrNullEvent());
    }

    @Test
    public void processLessThanCountEvents() throws Exception {
        AssertionMessageProcessor asp = this.createAssertionMessageProcessor();
        asp.setFlowConstruct(this.flowConstruct);
        asp.setExpression("trueExpression");
        asp.setCount(5);
        asp.start();
        for (int i = 0; i < 4; ++i) {
            asp.process(this.mockEvent);
        }
        Assert.assertFalse((boolean)asp.expressionFailed());
        Assert.assertTrue((boolean)asp.countFailOrNullEvent());
    }

    @Test
    public void processExactCountEvents() throws Exception {
        AssertionMessageProcessor asp = this.createAssertionMessageProcessor();
        asp.setFlowConstruct(this.flowConstruct);
        asp.setExpression("trueExpression");
        asp.setCount(5);
        asp.start();
        for (int i = 0; i < 5; ++i) {
            asp.process(this.mockEvent);
        }
        Assert.assertFalse((boolean)asp.expressionFailed());
        Assert.assertFalse((boolean)asp.countFailOrNullEvent());
    }

    @Test
    public void processNullEvent() throws Exception {
        AssertionMessageProcessor asp = this.createAssertionMessageProcessor();
        asp.setFlowConstruct(this.flowConstruct);
        asp.setExpression("trueExpression");
        asp.setCount(5);
        asp.start();
        asp.process(null);
        Assert.assertFalse((boolean)asp.expressionFailed());
        Assert.assertTrue((boolean)asp.countFailOrNullEvent());
    }

    protected AssertionMessageProcessor createAssertionMessageProcessor() {
        return new AssertionMessageProcessor();
    }
}

