/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.transformers;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.DefaultMuleContext;
import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.registry.TransformerResolver;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.Transformer;
import org.mule.config.builders.AbstractConfigurationBuilder;
import org.mule.registry.MuleRegistryHelper;
import org.mule.tck.junit4.FunctionalTestCase;

public class ConvertersNotRegisteredTwiceTestCase
extends FunctionalTestCase {
    private MuleRegistryHelper registryHelper;

    protected String[] getConfigFiles() {
        return new String[0];
    }

    protected void addBuilders(List<ConfigurationBuilder> builders) {
        super.addBuilders(builders);
        builders.add(0, (ConfigurationBuilder)new AbstractConfigurationBuilder(){

            protected void doConfigure(MuleContext muleContext) throws Exception {
                ConvertersNotRegisteredTwiceTestCase.this.registryHelper = (MuleRegistryHelper)muleContext.getRegistry();
                ConvertersNotRegisteredTwiceTestCase.this.registryHelper = (MuleRegistryHelper)Mockito.spy((Object)ConvertersNotRegisteredTwiceTestCase.this.registryHelper);
                ((DefaultMuleContext)muleContext).setMuleRegistry(ConvertersNotRegisteredTwiceTestCase.this.registryHelper);
            }
        });
    }

    @Test
    public void noDuplicates() {
        ArgumentCaptor transformerResolverCaptor = ArgumentCaptor.forClass(TransformerResolver.class);
        ((MuleRegistryHelper)Mockito.verify((Object)this.registryHelper, (VerificationMode)Mockito.atLeastOnce())).registerTransformerResolver((TransformerResolver)transformerResolverCaptor.capture());
        this.assertNoDuplicatesNorEmpty(transformerResolverCaptor.getAllValues());
        ArgumentCaptor converterArgumentCaptor = ArgumentCaptor.forClass(Converter.class);
        ((MuleRegistryHelper)Mockito.verify((Object)this.registryHelper, (VerificationMode)Mockito.atLeastOnce())).notifyTransformerResolvers((Transformer)converterArgumentCaptor.capture(), (TransformerResolver.RegistryAction)org.mockito.Matchers.same((Object)TransformerResolver.RegistryAction.ADDED));
        this.assertNoDuplicatesNorEmpty(converterArgumentCaptor.getAllValues());
    }

    private <T> void assertNoDuplicatesNorEmpty(Collection<T> collection) {
        Assert.assertThat((Object)collection.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        HashSet<T> noDuplicates = new HashSet<T>(collection);
        Assert.assertThat(noDuplicates, (Matcher)Matchers.hasSize((int)collection.size()));
    }
}

