/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.transformers;

import groovyjarjarasm.asm.ClassWriter;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.expression.ExpressionConfig;
import org.mule.expression.transformers.ExpressionArgument;
import org.mule.expression.transformers.ExpressionTransformer;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class ExpressionTransformerTestCase
extends AbstractMuleContextTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpressionEvaluationClassLoader() throws ClassNotFoundException, TransformerException {
        ExpressionTransformer transformer = new ExpressionTransformer();
        transformer.setMuleContext(muleContext);
        transformer.addArgument(new ExpressionArgument("test", new ExpressionConfig("payload instanceof org.MyClass", "groovy", null), false));
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(new MyClassClassLoader());
            transformer.initialise();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        Assert.assertFalse((boolean)((Boolean)transformer.transform((Object)"test")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpressionEvaluationClassLoaderEL() throws ClassNotFoundException, TransformerException {
        ExpressionTransformer transformer = new ExpressionTransformer();
        transformer.setMuleContext(muleContext);
        transformer.addArgument(new ExpressionArgument("test", new ExpressionConfig("payload is org.MyClass", null, null), false));
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(new MyClassClassLoader());
            transformer.initialise();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        Assert.assertFalse((boolean)((Boolean)transformer.transform((Object)"test")));
    }

    @Test
    public void testNullPayloadIsConsideredAsNullResult() throws Exception {
        ExpressionTransformer transformer = new ExpressionTransformer();
        transformer.setMuleContext(muleContext);
        transformer.setReturnSourceIfNull(true);
        ExpressionConfig config = new ExpressionConfig("null", "groovy", null);
        ExpressionArgument argument = new ExpressionArgument("test", config, false);
        argument.setMuleContext(muleContext);
        transformer.addArgument(argument);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test", muleContext);
        Object result = transformer.transformMessage((MuleMessage)message, null);
        Assert.assertTrue((boolean)(result instanceof MuleMessage));
        MuleMessage transformedMessage = (MuleMessage)result;
        Assert.assertEquals((Object)"Test", (Object)transformedMessage.getPayload());
    }

    @Test
    public void testNullPayloadIsConsideredAsNullResultEL() throws Exception {
        ExpressionTransformer transformer = new ExpressionTransformer();
        transformer.setMuleContext(muleContext);
        transformer.setReturnSourceIfNull(true);
        ExpressionConfig config = new ExpressionConfig("null", null, null);
        ExpressionArgument argument = new ExpressionArgument("test", config, true);
        argument.setMuleContext(muleContext);
        transformer.addArgument(argument);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test", muleContext);
        Object result = transformer.transformMessage((MuleMessage)message, null);
        Assert.assertTrue((boolean)(result instanceof MuleMessage));
        MuleMessage transformedMessage = (MuleMessage)result;
        Assert.assertEquals((Object)"Test", (Object)transformedMessage.getPayload());
    }

    class MyClassClassLoader
    extends ClassLoader {
        MyClassClassLoader() {
        }

        @Override
        protected Class<?> findClass(String className) throws ClassNotFoundException {
            if (className.equals("org.MyClass")) {
                ClassWriter cw = new ClassWriter(2);
                cw.visit(49, 1, "org/MyClass", null, "java/lang/Object", null);
                return this.defineClass(className, cw.toByteArray(), 0, cw.toByteArray().length);
            }
            return super.findClass(className);
        }
    }
}

