/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.transformers;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.SimpleDataType;

public class GraphTransformerResolutionTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/transformers/graph-transformer-resolution-config.xml";
    }

    @Test
    public void resolvesNonDirectTransformation() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://testInput", (Object)new A("Hello"), null);
        Assert.assertTrue((boolean)(response.getPayload() instanceof C));
        Assert.assertEquals((Object)"HelloAFromB", (Object)((C)response.getPayload()).value);
    }

    public static class BtoCConverter
    extends AbstractTransformer
    implements DiscoverableTransformer {
        public BtoCConverter() {
            this.registerSourceType((DataType)new SimpleDataType(B.class));
            this.setReturnDataType((DataType)new SimpleDataType(C.class));
        }

        protected Object doTransform(Object src, String enc) throws TransformerException {
            return new C(((B)src).value + "FromB");
        }

        public int getPriorityWeighting() {
            return 10;
        }

        public void setPriorityWeighting(int weighting) {
        }
    }

    public static class AtoBConverter
    extends AbstractTransformer
    implements DiscoverableTransformer {
        public AtoBConverter() {
            this.registerSourceType((DataType)new SimpleDataType(A.class));
            this.setReturnDataType((DataType)new SimpleDataType(B.class));
        }

        protected Object doTransform(Object src, String enc) throws TransformerException {
            return new B(((A)src).value + "A");
        }

        public int getPriorityWeighting() {
            return 10;
        }

        public void setPriorityWeighting(int weighting) {
        }
    }

    public static class C {
        private final String value;

        public C(String value) {
            this.value = value;
        }
    }

    public static class B {
        private final String value;

        public B(String value) {
            this.value = value;
        }
    }

    public static class A {
        private final String value;

        public A(String value) {
            this.value = value;
        }
    }
}

