/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.simple;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.transformer.simple.MessagePropertiesTransformer;
import org.mule.transformer.types.TypedValue;

public class MessagePropertiesTransformerTestCase
extends FunctionalTestCase {
    public static final String BAR_PROPERTY = "bar";
    public static final String FOO_PROPERTY = "foo";
    public static final String TEXT_BAZ_MIME_TYPE = "text/baz";
    public static final String FOO_VALUE = "fooValue";

    protected String getConfigFile() {
        return "message-properties-transformer-config.xml";
    }

    @Test
    public void testOverwriteFlagEnabledByDefault() throws Exception {
        MessagePropertiesTransformer t = new MessagePropertiesTransformer();
        HashMap<String, TypedValue> add = new HashMap<String, TypedValue>();
        add.put("addedProperty", new TypedValue((Object)"overwrittenValue", DataType.STRING_DATA_TYPE));
        t.setAddTypedProperties(add);
        t.setMuleContext(muleContext);
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)"message", muleContext);
        msg.setOutboundProperty("addedProperty", (Object)"originalValue");
        MuleEventContext ctx = MessagePropertiesTransformerTestCase.getTestEventContext((Object)msg);
        msg = ctx.getMessage();
        DefaultMuleMessage transformed = (DefaultMuleMessage)t.transform((Object)msg, (String)null);
        Assert.assertSame((Object)msg, (Object)transformed);
        Assert.assertEquals((Object)msg.getUniqueId(), (Object)transformed.getUniqueId());
        Assert.assertEquals((Object)msg.getPayload(), (Object)transformed.getPayload());
        this.compareProperties((MuleMessage)msg, (MuleMessage)transformed);
        Assert.assertEquals((Object)"overwrittenValue", (Object)transformed.getOutboundProperty("addedProperty"));
    }

    @Test
    public void testOverwriteFalsePreservesOriginal() throws Exception {
        MessagePropertiesTransformer t = new MessagePropertiesTransformer();
        HashMap<String, TypedValue> add = new HashMap<String, TypedValue>();
        add.put("addedProperty", new TypedValue((Object)"overwrittenValue", DataType.STRING_DATA_TYPE));
        t.setAddTypedProperties(add);
        t.setOverwrite(false);
        t.setMuleContext(muleContext);
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)"message", muleContext);
        msg.setProperty("addedProperty", (Object)"originalValue", PropertyScope.INVOCATION);
        DefaultMuleMessage transformed = (DefaultMuleMessage)t.transform((Object)msg, (String)null);
        Assert.assertSame((Object)msg, (Object)transformed);
        Assert.assertEquals((Object)msg.getUniqueId(), (Object)transformed.getUniqueId());
        Assert.assertEquals((Object)msg.getPayload(), (Object)transformed.getPayload());
        this.compareProperties((MuleMessage)msg, (MuleMessage)transformed);
        Assert.assertEquals((Object)"originalValue", (Object)transformed.getInvocationProperty("addedProperty"));
    }

    @Test
    public void testExpressionsInAddProperties() throws Exception {
        MessagePropertiesTransformer t = new MessagePropertiesTransformer();
        HashMap<String, TypedValue> add = new HashMap<String, TypedValue>();
        add.put("Foo", new TypedValue((Object)"#[header:public-house]", DataType.STRING_DATA_TYPE));
        t.setAddTypedProperties(add);
        t.setMuleContext(muleContext);
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)"message", muleContext);
        msg.setOutboundProperty("public-house", (Object)"Bar");
        DefaultMuleMessage transformed = (DefaultMuleMessage)t.transform((Object)msg, (String)null);
        Assert.assertSame((Object)msg, (Object)transformed);
        Assert.assertEquals((Object)msg.getUniqueId(), (Object)transformed.getUniqueId());
        Assert.assertEquals((Object)msg.getPayload(), (Object)transformed.getPayload());
        this.compareProperties((MuleMessage)msg, (MuleMessage)transformed);
        Assert.assertEquals((Object)"Bar", (Object)transformed.getOutboundProperty("Foo"));
    }

    @Test
    public void testRenameProperties() throws Exception {
        MessagePropertiesTransformer t = new MessagePropertiesTransformer();
        HashMap<String, String> add = new HashMap<String, String>();
        add.put("Foo", "Baz");
        t.setRenameProperties(add);
        t.setScope(PropertyScope.INVOCATION);
        t.setMuleContext(muleContext);
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)"message", muleContext);
        msg.setInvocationProperty("Foo", (Object)"Bar");
        DefaultMuleMessage transformed = (DefaultMuleMessage)t.transform((Object)msg);
        Assert.assertSame((Object)msg, (Object)transformed);
        Assert.assertEquals((Object)msg.getUniqueId(), (Object)transformed.getUniqueId());
        Assert.assertEquals((Object)msg.getPayload(), (Object)transformed.getPayload());
        this.compareProperties((MuleMessage)msg, (MuleMessage)transformed);
        Assert.assertEquals((Object)"Bar", (Object)transformed.getInvocationProperty("Baz"));
    }

    @Test
    public void testDelete() throws Exception {
        MessagePropertiesTransformer t = new MessagePropertiesTransformer();
        t.setDeleteProperties(new String[]{"badProperty"});
        t.setMuleContext(muleContext);
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)"message", muleContext);
        msg.setOutboundProperty("badProperty", (Object)"badValue");
        Assert.assertEquals((Object)"badValue", (Object)msg.getOutboundProperty("badProperty"));
        DefaultMuleMessage transformed = (DefaultMuleMessage)t.transform((Object)msg, (String)null);
        Assert.assertSame((Object)msg, (Object)transformed);
        Assert.assertEquals((Object)msg.getUniqueId(), (Object)transformed.getUniqueId());
        Assert.assertEquals((Object)msg.getPayload(), (Object)transformed.getPayload());
        this.compareProperties((MuleMessage)msg, (MuleMessage)transformed);
        Assert.assertFalse((boolean)transformed.getInvocationPropertyNames().contains("badValue"));
        Assert.assertFalse((boolean)transformed.getInboundPropertyNames().contains("badValue"));
        Assert.assertFalse((boolean)transformed.getOutboundPropertyNames().contains("badValue"));
        Assert.assertFalse((boolean)transformed.getSessionPropertyNames().contains("badValue"));
    }

    @Test
    public void testTransformerConfig() throws Exception {
        MessagePropertiesTransformer transformer = (MessagePropertiesTransformer)muleContext.getRegistry().lookupTransformer("testTransformer");
        transformer.setMuleContext(muleContext);
        Assert.assertNotNull((Object)transformer);
        Assert.assertNotNull((Object)transformer.getAddProperties());
        Assert.assertNotNull((Object)transformer.getDeleteProperties());
        Assert.assertEquals((long)2L, (long)transformer.getAddProperties().size());
        Assert.assertEquals((long)2L, (long)transformer.getDeleteProperties().size());
        Assert.assertEquals((long)1L, (long)transformer.getRenameProperties().size());
        Assert.assertTrue((boolean)transformer.isOverwrite());
        TypedValue typedValue = (TypedValue)transformer.getAddProperties().get("Content-Type");
        Assert.assertThat((Object)((String)typedValue.getValue()), (Matcher)Matchers.equalTo((Object)"text/baz;charset=UTF-16BE"));
        Assert.assertThat((Object)typedValue.getDataType(), (Matcher)DataTypeMatcher.like(Object.class, (String)"*/*", null));
        typedValue = (TypedValue)transformer.getAddProperties().get("key");
        Assert.assertThat((Object)((String)typedValue.getValue()), (Matcher)Matchers.equalTo((Object)"value"));
        Assert.assertThat((Object)typedValue.getDataType(), (Matcher)DataTypeMatcher.like(String.class, (String)"*/*", null));
        Assert.assertEquals((Object)"test-property1", transformer.getDeleteProperties().get(0));
        Assert.assertEquals((Object)"test-property2", transformer.getDeleteProperties().get(1));
        Assert.assertEquals((Object)"Faz", transformer.getRenameProperties().get("Foo"));
        Assert.assertEquals((Object)PropertyScope.OUTBOUND, (Object)transformer.getScope());
    }

    @Test
    public void setsDataTypeFromConfig() throws Exception {
        MessagePropertiesTransformer transformer = (MessagePropertiesTransformer)muleContext.getRegistry().lookupTransformer("addPropertyWithDataType");
        transformer.setMuleContext(muleContext);
        Assert.assertNotNull((Object)transformer.getAddProperties());
        Assert.assertEquals((long)1L, (long)transformer.getAddProperties().size());
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)"Test Message", muleContext);
        DefaultMuleMessage transformed = (DefaultMuleMessage)transformer.transform((Object)msg);
        Assert.assertThat((Object)FOO_VALUE, (Matcher)Matchers.equalTo((Object)transformed.getOutboundProperty(FOO_PROPERTY)));
        Assert.assertThat((Object)transformed.getPropertyDataType(FOO_PROPERTY, PropertyScope.OUTBOUND), (Matcher)DataTypeMatcher.like(String.class, (String)TEXT_BAZ_MIME_TYPE, (String)StandardCharsets.UTF_16BE.name()));
    }

    @Test
    public void copiesDataTypeOnRenameProperty() throws Exception {
        MessagePropertiesTransformer transformer = (MessagePropertiesTransformer)muleContext.getRegistry().lookupTransformer("renamePropertyWithDataType");
        transformer.setMuleContext(muleContext);
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)"Test Message", muleContext);
        DefaultMuleMessage transformed = (DefaultMuleMessage)transformer.transform((Object)msg);
        Assert.assertThat((Object)FOO_VALUE, (Matcher)Matchers.equalTo((Object)transformed.getOutboundProperty(BAR_PROPERTY)));
        Assert.assertThat((Object)transformed.getPropertyDataType(BAR_PROPERTY, PropertyScope.OUTBOUND), (Matcher)DataTypeMatcher.like(String.class, (String)TEXT_BAZ_MIME_TYPE, (String)StandardCharsets.UTF_16BE.name()));
    }

    @Test
    public void testDeleteUsingPropertyName() throws Exception {
        String expression = "badProperty";
        String[] validProperties = new String[]{"somethingnotsobad"};
        String[] invalidProperties = new String[]{"badProperty"};
        this.doTestMessageTransformationWithExpression("badProperty", validProperties, invalidProperties);
    }

    @Test
    public void testDeletePropertiesStartingWithExpression() throws Exception {
        String expression = "^bad.*";
        String[] validProperties = new String[]{"somethingnotsobad"};
        String[] invalidProperties = new String[]{"badProperty", "badThing"};
        this.doTestMessageTransformationWithExpression("^bad.*", validProperties, invalidProperties);
    }

    @Test
    public void testDeletePropertiesCaseInsensitiveRegex() throws Exception {
        String expression = "(?i)^BAD.*";
        String[] validProperties = new String[]{"somethingnotsobad"};
        String[] invalidProperties = new String[]{"badProperty", "badThing"};
        this.doTestMessageTransformationWithExpression("(?i)^BAD.*", validProperties, invalidProperties);
    }

    @Test
    public void testDeletePropertiesEndingWithExpression() throws Exception {
        String expression = ".*bad$";
        String[] validProperties = new String[]{"badProperty", "badThing"};
        String[] invalidProperties = new String[]{"somethingnotsobad"};
        this.doTestMessageTransformationWithExpression(".*bad$", validProperties, invalidProperties);
    }

    @Test
    public void testDeletePropertiesContainingExpression() throws Exception {
        String expression = ".*bad.*";
        String[] validProperties = new String[]{};
        String[] invalidProperties = new String[]{"badProperty", "badThing", "somethingnotsobad"};
        this.doTestMessageTransformationWithExpression(".*bad.*", validProperties, invalidProperties);
    }

    @Test
    public void testDeletePropertiesUsingWildcard() throws Exception {
        String expression = "bad*";
        String[] validProperties = new String[]{"somethingnotsobad"};
        String[] invalidProperties = new String[]{"badProperty", "badThing"};
        this.doTestMessageTransformationWithExpression("bad*", validProperties, invalidProperties);
    }

    private void doTestMessageTransformationWithExpression(String expression, String[] validProperties, String[] invalidProperties) throws TransformerException {
        MessagePropertiesTransformer t = this.createTransformerWithExpression(expression);
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)"message", muleContext);
        this.addPropertiesToMessage(validProperties, msg);
        this.addPropertiesToMessage(invalidProperties, msg);
        DefaultMuleMessage transformed = (DefaultMuleMessage)t.transform((Object)msg);
        Assert.assertSame((Object)msg, (Object)transformed);
        Assert.assertEquals((Object)msg.getUniqueId(), (Object)transformed.getUniqueId());
        Assert.assertEquals((Object)msg.getPayload(), (Object)transformed.getPayload());
        this.assertMessageContainsExpectedProperties(validProperties, invalidProperties, transformed);
    }

    private void assertMessageContainsExpectedProperties(String[] validProperties, String[] invalidProperties, DefaultMuleMessage transformed) {
        for (String property : validProperties) {
            Assert.assertTrue((String)("Should contain property: " + property), (boolean)transformed.getOutboundPropertyNames().contains(property));
        }
        for (String property : invalidProperties) {
            Assert.assertFalse((String)("Should not contain property: " + property), (boolean)transformed.getOutboundPropertyNames().contains(property));
        }
    }

    private MessagePropertiesTransformer createTransformerWithExpression(String expression) {
        MessagePropertiesTransformer t = new MessagePropertiesTransformer();
        t.setDeleteProperties(new String[]{expression});
        t.setMuleContext(muleContext);
        return t;
    }

    private void addPropertiesToMessage(String[] validProperties, DefaultMuleMessage msg) {
        for (String property : validProperties) {
            msg.setOutboundProperty(property, (Object)"defaultPropertyValue");
        }
    }

    private void compareProperties(MuleMessage msg, MuleMessage transformed) {
        Assert.assertEquals((Object)msg.getInvocationPropertyNames(), (Object)transformed.getInvocationPropertyNames());
        Assert.assertEquals((Object)msg.getInboundPropertyNames(), (Object)transformed.getInboundPropertyNames());
        Assert.assertEquals((Object)msg.getOutboundPropertyNames(), (Object)transformed.getOutboundPropertyNames());
        Assert.assertEquals((Object)msg.getSessionPropertyNames(), (Object)transformed.getSessionPropertyNames());
    }
}

