/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.simple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.construct.Flow;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transformer.AbstractTransformer;

public class RegistryTransformerLifecycleTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "simple-transformer-config.xml";
    }

    @Test
    public void testLifecycleInSpring() throws Exception {
        TransformerLifecycleTracker transformer = (TransformerLifecycleTracker)muleContext.getRegistry().lookupTransformer("lifecycle");
        Assert.assertNotNull((Object)((Object)transformer));
        muleContext.dispose();
        this.assertInitialise(transformer);
    }

    @Test
    public void testLifecycleInFlowInSpring() throws Exception {
        Flow flow = (Flow)muleContext.getRegistry().lookupFlowConstruct("flow");
        TransformerLifecycleTracker transformer = (TransformerLifecycleTracker)((Object)flow.getMessageProcessors().get(0));
        Assert.assertNotNull((Object)((Object)transformer));
        muleContext.dispose();
        this.assertLifecycle(transformer);
    }

    @Test
    public void testLifecycleInTransientRegistry() throws Exception {
        TransformerLifecycleTracker transformer = new TransformerLifecycleTracker();
        transformer.setProperty("foo");
        muleContext.getRegistry().registerTransformer((Transformer)transformer);
        muleContext.dispose();
    }

    @Test
    public void testLifecycleInFlowTransientRegistry() throws Exception {
        Flow flow = new Flow("flow", muleContext);
        TransformerLifecycleTracker transformer = new TransformerLifecycleTracker();
        transformer.setProperty("foo");
        flow.setMessageProcessors(Collections.singletonList(transformer));
        muleContext.getRegistry().registerFlowConstruct((FlowConstruct)flow);
        muleContext.dispose();
        this.assertLifecycle(transformer);
    }

    private void assertLifecycle(TransformerLifecycleTracker transformer) {
        Assert.assertEquals((Object)"[setProperty, initialise, dispose]", (Object)transformer.getTracker().toString());
    }

    private void assertInitialise(TransformerLifecycleTracker transformer) {
        Assert.assertEquals((Object)"[setProperty, initialise]", (Object)transformer.getTracker().toString());
    }

    public static class TransformerLifecycleTracker
    extends AbstractTransformer
    implements Disposable {
        private final List<String> tracker = new ArrayList<String>();
        private String property;

        protected Object doTransform(Object src, String encoding) throws TransformerException {
            this.tracker.add("doTransform");
            return null;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.tracker.add("setProperty");
        }

        public List<String> getTracker() {
            return this.tracker;
        }

        public void initialise() throws InitialisationException {
            this.tracker.add("initialise");
        }

        public void dispose() {
            this.tracker.add("dispose");
        }
    }
}

