/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.test.integration.routing.outbound;

import org.mule.functional.functional.FlowAssert;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.tck.testmodels.fruit.Orange;

import org.junit.Test;

public class ExpressionSplitterAsyncTestCase extends AbstractIntegrationTestCase {

  @Override
  protected String getConfigFile() {
    return "org/mule/test/integration/routing/outbound/expression-splitter-async-test-flow.xml";
  }

  @Test
  public void testSplitter() throws Exception {
    FruitBowl fruitBowl = new FruitBowl(new Apple(), new Banana());
    fruitBowl.addFruit(new Orange());

    flowRunner("Distributor").withPayload(fruitBowl).run();

    FlowAssert.verify();
  }
}
