/*
 * Decompiled with CFR 0.152.
 */
package org.mule.issues;

import io.qameta.allure.Issue;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.transformer.AbstractMessageTransformer;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;

@Ignore(value="See MULE-9195")
@Issue(value="MULE-9195")
public class MessageRootIdPropagationTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");

    protected String getConfigFile() {
        return "org/mule/issues/message-root-id.xml";
    }

    @Test
    public void testRootIDs() throws Exception {
        RootIDGatherer.initialize();
        FlowRunner runner = (FlowRunner)((FlowRunner)this.flowRunner("flow1").withPayload((Object)"Hello")).withOutboundProperty("where", (Serializable)((Object)"client"));
        RootIDGatherer.process(runner.buildEvent().getMessage());
        runner.run();
        Thread.sleep(1000L);
        Assert.assertEquals((long)6L, (long)RootIDGatherer.getMessageCount());
        Assert.assertEquals((long)1L, (long)RootIDGatherer.getIds().size());
    }

    public static class RootIDGatherer
    extends AbstractMessageTransformer {
        static int messageCount;
        static Map<String, Message> idMap;
        static int counter;

        public static void initialize() {
            idMap = new HashMap<String, Message>();
            messageCount = 0;
        }

        public static synchronized void process(Message msg) {
            ++messageCount;
            String where = (String)msg.getPayload().getValue();
            if (where == null) {
                where = "location_" + counter++;
            }
            idMap.put(where, msg);
        }

        public Object transformMessage(CoreEvent event, Charset outputEncoding) {
            RootIDGatherer.process(event.getMessage());
            return event.getMessage().getPayload().getValue();
        }

        public static Set<Message> getIds() {
            return new HashSet<Message>(idMap.values());
        }

        public static int getMessageCount() {
            return messageCount;
        }

        public static Map<String, Message> getIdMap() {
            return idMap;
        }
    }
}

