/*
 * Decompiled with CFR 0.152.
 */
package org.mule.shutdown;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.component.TestConnectorQueueHandler;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.exception.MuleException;
import org.mule.shutdown.AbstractShutdownTimeoutRequestResponseTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

public class ExpiredShutdownTimeoutOneWayTestCase
extends AbstractShutdownTimeoutRequestResponseTestCase {
    @Rule
    public SystemProperty contextShutdownTimeout = new SystemProperty("contextShutdownTimeout", "100");

    protected String getConfigFile() {
        return "shutdown-timeout-one-way-config.xml";
    }

    @Test
    public void testStaticComponent() throws Exception {
        this.doShutDownTest("staticComponentFlow");
    }

    @Test
    public void testScriptComponent() throws Exception {
        this.doShutDownTest("scriptComponentFlow");
    }

    @Test
    public void testExpressionTransformer() throws Exception {
        this.doShutDownTest("expressionTransformerFlow");
    }

    private void doShutDownTest(String flowName) throws MuleException, InterruptedException {
        TestConnectorQueueHandler queueHandler = new TestConnectorQueueHandler(this.registry);
        boolean[] results = new boolean[]{false};
        Thread t = new Thread(() -> {
            try {
                ((FlowRunner)this.flowRunner(flowName).withPayload((Object)"Test Message")).dispatch();
                results[0] = queueHandler.read("response", 5000L) == null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        t.start();
        waitLatch.await();
        muleContext.stop();
        t.join();
        Assert.assertTrue((String)"Was able to process message ", (boolean)results[0]);
    }
}

