/*
 * Decompiled with CFR 0.152.
 */
package org.mule.shutdown;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.component.TestConnectorQueueHandler;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.shutdown.AbstractShutdownTimeoutRequestResponseTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

public class ValidShutdownTimeoutOneWayTestCase
extends AbstractShutdownTimeoutRequestResponseTestCase {
    @Rule
    public SystemProperty contextShutdownTimeout = new SystemProperty("contextShutdownTimeout", "5000");

    protected String getConfigFile() {
        return "shutdown-timeout-one-way-config.xml";
    }

    protected boolean isGracefulShutdown() {
        return true;
    }

    @Test
    public void testStaticComponent() throws Exception {
        this.doShutDownTest("staticComponentResponse", "staticComponentFlow");
    }

    @Test
    public void testScriptComponent() throws Exception {
        this.doShutDownTest("scriptComponentResponse", "scriptComponentFlow");
    }

    @Test
    public void testExpressionTransformer() throws Exception {
        this.doShutDownTest("expressionTransformerResponse", "expressionTransformerFlow");
    }

    private void doShutDownTest(String payload, String flowName) throws MuleException, InterruptedException {
        TestConnectorQueueHandler queueHandler = new TestConnectorQueueHandler(this.registry);
        boolean[] results = new boolean[]{false};
        Thread t = new Thread(() -> {
            try {
                ((FlowRunner)this.flowRunner(flowName).withPayload((Object)payload)).dispatch();
                Message response = queueHandler.read("response", 5000L).getMessage();
                results[0] = payload.equals(this.getPayloadAsString(response));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        t.start();
        waitLatch.await();
        muleContext.stop();
        t.join();
        Assert.assertTrue((String)"Was not able to process message ", (boolean)results[0]);
    }
}

