/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components;

import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Named;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.execution.ComponentExecutionException;
import org.mule.runtime.api.component.execution.ExecutableComponent;
import org.mule.runtime.api.component.execution.ExecutionResult;
import org.mule.runtime.api.component.execution.InputEvent;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.test.AbstractIntegrationTestCase;

public class FlowExecutionTestCase
extends AbstractIntegrationTestCase {
    @Inject
    @Named(value="flow")
    private ExecutableComponent flow;
    @Inject
    @Named(value="flowWithErrorContinue")
    private ExecutableComponent flowWithErrorContinue;
    @Inject
    @Named(value="flowWithErrorPropagate")
    private ExecutableComponent flowWithErrorPropagate;

    protected String getConfigFile() {
        return "org/mule/test/components/flow-execution-config.xml";
    }

    @Test
    public void executeFlow() throws Exception {
        this.executeTest(this.flow, Optional.empty());
    }

    @Test
    public void executeFlowWithErrorContinue() throws Exception {
        this.executeTest(this.flowWithErrorContinue, Optional.empty());
    }

    @Test
    public void executeFlowWithErrorPropagate() throws Exception {
        this.executeTest(this.flowWithErrorPropagate, Optional.of("EXPRESSION"));
    }

    private void executeTest(ExecutableComponent executableComponent, Optional<String> errorIdentifierExpected) throws InterruptedException, ExecutionException {
        Event resultEvent;
        try {
            resultEvent = ((ExecutionResult)executableComponent.execute(this.createInputEvent()).get()).getEvent();
            errorIdentifierExpected.ifPresent(error -> Assert.fail());
        }
        catch (ExecutionException e) {
            resultEvent = ((ComponentExecutionException)e.getCause()).getEvent();
        }
        Assert.assertThat((Object)resultEvent.getError().isPresent(), (Matcher)Is.is((Object)errorIdentifierExpected.isPresent()));
        Assert.assertThat((Object)resultEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)3));
        Event finalResultEvent = resultEvent;
        errorIdentifierExpected.ifPresent(errorIdentifier -> Assert.assertThat((Object)((Error)finalResultEvent.getError().get()).getErrorType().getIdentifier(), (Matcher)Is.is((Object)errorIdentifier)));
    }

    private InputEvent createInputEvent() {
        return InputEvent.create().addVariable("myVar", (Object)2).message(Message.builder().payload(TypedValue.of((Object)1)).build());
    }
}

