/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.test.AbstractIntegrationTestCase;

public class PrototypeLifecycleTestCase
extends AbstractIntegrationTestCase {
    private static final Map<LifecycleTracker, Map<String, AtomicInteger>> trackers = new HashMap<LifecycleTracker, Map<String, AtomicInteger>>();

    protected String getConfigFile() {
        return "prototype-lifecycle-config.xml";
    }

    @Test
    public void lifecycleNotAppliedTwiceWhenAskedForInRegistry() throws Exception {
        this.flowRunner("mainFlow").run();
        MatcherAssert.assertThat((Object)trackers.size(), (Matcher)Matchers.is((Object)1));
        this.assertCountersAreAllOne();
    }

    private void assertCountersAreAllOne() {
        trackers.values().forEach(trackingMap -> trackingMap.values().forEach(counter -> MatcherAssert.assertThat((Object)counter.get(), (Matcher)Matchers.is((Object)1))));
    }

    public static class LifecycleTracker
    extends AbstractComponent
    implements Processor,
    Initialisable,
    Startable {
        public void initialise() throws InitialisationException {
            this.addToMap();
            this.incrementLifecycleCount("initialise");
        }

        public void start() throws MuleException {
            this.addToMap();
            this.incrementLifecycleCount("start");
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            return event;
        }

        private void addToMap() {
            if (!trackers.containsKey((Object)this)) {
                trackers.put(this, new HashMap());
            }
        }

        private void incrementLifecycleCount(String phase) {
            Map myMap = (Map)trackers.get((Object)this);
            if (myMap.containsKey(phase)) {
                ((AtomicInteger)myMap.get(phase)).getAndIncrement();
            } else {
                AtomicInteger newCounter = new AtomicInteger();
                newCounter.getAndIncrement();
                myMap.put(phase, newCounter);
            }
        }
    }
}

