/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.SimpleMemoryObjectStore;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.test.AbstractIntegrationTestCase;

public class IdempotentMessageValidatorNamespaceHandlerTestCase
extends AbstractIntegrationTestCase {
    protected String getConfigFile() {
        return "org/mule/test/config/idempotent-message-validator-config.xml";
    }

    @Test
    public void testCustomObjectStore() throws Exception {
        this.testPojoObjectStore("customObjectStore");
    }

    private void testPojoObjectStore(String flowName) throws Exception {
        Processor filter = this.idempotentMessageFilterFromFlow(flowName);
        ObjectStore store = this.getObjectStore(filter);
        Assert.assertThat((Object)store, (Matcher)Matchers.instanceOf(CustomObjectStore.class));
        CustomObjectStore customStore = (CustomObjectStore)store;
        Assert.assertEquals((Object)("the-value:" + flowName), (Object)customStore.getCustomProperty());
    }

    private Processor idempotentMessageFilterFromFlow(String flowName) throws Exception {
        FlowConstruct flow = (FlowConstruct)this.registry.lookupByName(flowName).get();
        Assert.assertTrue((boolean)(flow instanceof Flow));
        Flow simpleFlow = (Flow)flow;
        List processors = simpleFlow.getProcessors();
        Assert.assertEquals((long)1L, (long)processors.size());
        Processor firstMP = (Processor)processors.get(0);
        Assert.assertThat((Object)firstMP.getClass().getName(), (Matcher)Matchers.equalTo((Object)"org.mule.runtime.core.internal.routing.IdempotentMessageValidator"));
        return firstMP;
    }

    private ObjectStore getObjectStore(Processor router) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = router.getClass().getMethod("getObjectStore", new Class[0]);
        return (ObjectStore)method.invoke((Object)router, new Object[0]);
    }

    public static class CustomObjectStore
    extends SimpleMemoryObjectStore<Serializable> {
        private String customProperty;

        public String getCustomProperty() {
            return this.customProperty;
        }

        public void setCustomProperty(String value) {
            this.customProperty = value;
        }
    }
}

