/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config.spring.parsers;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Named;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.component.TestConnectorQueueHandler;
import org.mule.runtime.api.component.execution.ComponentExecutionException;
import org.mule.runtime.api.component.execution.ExecutableComponent;
import org.mule.runtime.api.component.execution.ExecutionResult;
import org.mule.runtime.api.component.execution.InputEvent;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.IntegrationTestCaseRunnerConfig;

@Feature(value="Routers")
@Story(value="Processor Chain Router")
public class ProcessorChainRouterTestCase
extends AbstractIntegrationTestCase
implements IntegrationTestCaseRunnerConfig {
    @Inject
    @Named(value="compositeChainRouter")
    private ExecutableComponent compositeChainRouter;
    @Inject
    @Named(value="compositeChainRouterError")
    private ExecutableComponent compositeChainRouterError;
    @Inject
    @Named(value="chainRouter")
    private ExecutableComponent chainRouter;
    @Inject
    @Named(value="chainRouterError")
    private ExecutableComponent chainRouterError;
    @Inject
    @Named(value="chainRouterComponents")
    private ExecutableComponent chainRouterComponents;
    @Inject
    @Named(value="byPassFlow")
    private ExecutableComponent byPassFlow;
    @Inject
    @Named(value="flowRefCompositeChainRouter")
    private ExecutableComponent flowRefCompositeChainRouter;

    protected String getConfigFile() {
        return "org/mule/config/spring/parsers/processor-chain-router-config.xml";
    }

    @Test
    public void executeCompositeRouterUsingInputEvent() throws Exception {
        InputEvent event = this.createInputEvent();
        CompletableFuture completableFuture = this.compositeChainRouter.execute(event);
        Event returnedEvent = ((ExecutionResult)completableFuture.get()).getEvent();
        this.assertProcessorChainResult(returnedEvent);
    }

    @Test
    public void executeCompositeRouterUsingEvent() throws Exception {
        Event flowResultEvent = ((ExecutionResult)this.byPassFlow.execute(this.createInputEvent()).get()).getEvent();
        CompletableFuture completableFuture = this.compositeChainRouter.execute(flowResultEvent);
        Event returnedEvent = (Event)completableFuture.get();
        this.assertProcessorChainResult(returnedEvent);
    }

    @Test
    @Description(value="Ensure that when composite processor chain is used with more complex/async components such as nested flow-ref there are no dead-locks.")
    public void nestedFlowRefUsingInputEvent() throws Exception {
        InputEvent event = this.createInputEvent();
        CompletableFuture completableFuture = this.flowRefCompositeChainRouter.execute(event);
        Event returnedEvent = ((ExecutionResult)completableFuture.get()).getEvent();
        this.assertProcessorChainResult(returnedEvent);
    }

    @Test
    @Description(value="Ensure that when composite processor chain is used with more complex/async components such as nested flow-ref there are no dead-locks.")
    public void nestedFlowRefUsingEvent() throws Exception {
        Event flowResultEvent = ((ExecutionResult)this.byPassFlow.execute(this.createInputEvent()).get()).getEvent();
        CompletableFuture completableFuture = this.flowRefCompositeChainRouter.execute(flowResultEvent);
        Event returnedEvent = (Event)completableFuture.get();
        this.assertProcessorChainResult(returnedEvent);
    }

    @Test
    public void executeCompositeRouterWithError() throws Exception {
        InputEvent event = this.createInputEvent();
        CompletableFuture completableFuture = this.compositeChainRouterError.execute(event);
        try {
            ((ExecutionResult)completableFuture.get()).getEvent();
            Assert.fail();
        }
        catch (ExecutionException e) {
            ComponentExecutionException componentExecutionException = (ComponentExecutionException)e.getCause();
            Event returnedEvent = componentExecutionException.getEvent();
            Assert.assertThat((Object)returnedEvent, (Matcher)IsNull.notNullValue());
            Assert.assertThat((Object)returnedEvent.getError().isPresent(), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)((Error)returnedEvent.getError().get()).getErrorType().getIdentifier(), (Matcher)Is.is((Object)"CLIENT_SECURITY"));
        }
    }

    @Test
    public void executeChainUsingInputEvent() throws Exception {
        InputEvent event = this.createInputEvent();
        CompletableFuture completableFuture = this.chainRouter.execute(event);
        Event returnedEvent = ((ExecutionResult)completableFuture.get()).getEvent();
        Assert.assertThat((Object)returnedEvent, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)returnedEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"testPayload custom"));
    }

    @Test
    public void executeChainWithError() throws Exception {
        InputEvent event = this.createInputEvent();
        CompletableFuture completableFuture = this.chainRouterError.execute(event);
        try {
            completableFuture.get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            ComponentExecutionException componentExecutionException = (ComponentExecutionException)e.getCause();
            Event returnedEvent = componentExecutionException.getEvent();
            Assert.assertThat((Object)returnedEvent, (Matcher)IsNull.notNullValue());
            Assert.assertThat((Object)returnedEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"testPayload custom"));
        }
    }

    @Test
    public void executeChainFlowConstructDependantComponents() throws Exception {
        InputEvent event = this.createInputEvent();
        CompletableFuture completableFuture = this.chainRouterComponents.execute(event);
        Event returnedEvent = ((ExecutionResult)completableFuture.get()).getEvent();
        Assert.assertThat((Object)returnedEvent, (Matcher)IsNull.notNullValue());
        TestConnectorQueueHandler queueHandler = new TestConnectorQueueHandler(this.registry);
        Assert.assertThat((Object)(queueHandler.read("asyncQueue", 5000L) != null ? 1 : 0), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)(queueHandler.read("sgRoute1Queue", 5000L) != null ? 1 : 0), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)(queueHandler.read("sgRoute2Queue", 5000L) != null ? 1 : 0), (Matcher)Is.is((Object)true));
    }

    private void assertProcessorChainResult(Event returnedEvent) {
        Assert.assertThat((Object)returnedEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"testPayload custom"));
        Assert.assertThat((Object)((TypedValue)returnedEvent.getVariables().get("myVar")).getValue(), (Matcher)Is.is((Object)"myVarValue"));
        Assert.assertThat((Object)((TypedValue)returnedEvent.getVariables().get("mySecondVar")).getValue(), (Matcher)Is.is((Object)"mySecondVarValue"));
        Assert.assertThat((Object)((TypedValue)returnedEvent.getVariables().get("myThirdVar")).getValue(), (Matcher)Is.is((Object)"myThirdVarValue"));
    }

    private InputEvent createInputEvent() {
        return InputEvent.create().message(Message.builder().value((Object)"testPayload").build()).addVariable("customVar", (Object)"Value");
    }
}

