/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.core.context.notification;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.api.notification.MessageProcessorNotificationListener;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.util.FlowTraceUtils;
import org.mule.test.AbstractIntegrationTestCase;

public class FlowStackTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public SystemProperty flowTraceEnabled = new SystemProperty("mule.flowTrace", "true");

    protected String getConfigFile() {
        return "org/mule/test/integration/notifications/flow-stack-config.xml";
    }

    @Before
    public void before() {
        muleContext.getNotificationManager().addInterfaceToType(MessageProcessorNotificationListener.class, MessageProcessorNotification.class);
        FlowTraceUtils.FlowStackAsserter.stackToAssert = null;
        FlowTraceUtils.FlowStackAsyncAsserter.latch = new CountDownLatch(1);
    }

    @Test
    public void flowStatic() throws Exception {
        ((FlowRunner)this.flowRunner("flowStatic").withPayload((Object)"Test Message")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowStatic", (String)"flowStatic/processors/0")});
    }

    @Test
    public void subFlowStatic() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowStatic").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowStatic", (String)"subFlowStatic/processors/0")});
    }

    @Test
    public void flowDynamic() throws Exception {
        ((FlowRunner)this.flowRunner("flowDynamic").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowDynamic", (String)"flowDynamic/processors/0")});
    }

    @Test
    public void subFlowDynamic() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowDynamic").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowDynamic", (String)"subFlowDynamic/processors/0")});
    }

    @Test
    public void secondFlowStatic() throws Exception {
        ((FlowRunner)this.flowRunner("secondFlowStatic").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"secondFlowStatic", (String)"secondFlowStatic/processors/1")});
    }

    @Test
    public void secondSubFlowStatic() throws Exception {
        ((FlowRunner)this.flowRunner("secondSubFlowStatic").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"secondSubFlowStatic", (String)"secondSubFlowStatic/processors/1")});
    }

    @Test
    public void secondFlowDynamic() throws Exception {
        ((FlowRunner)this.flowRunner("secondFlowDynamic").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"secondFlowDynamic", (String)"secondFlowDynamic/processors/1")});
    }

    @Test
    public void secondSubFlowDynamic() throws Exception {
        ((FlowRunner)this.flowRunner("secondSubFlowDynamic").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"secondSubFlowDynamic", (String)"secondSubFlowDynamic/processors/1")});
    }

    @Test
    public void flowStaticWithAsync() throws Exception {
        ((FlowRunner)this.flowRunner("flowStaticWithAsync").withPayload((Object)"payload")).run();
        FlowTraceUtils.FlowStackAsyncAsserter.latch.await(1L, TimeUnit.SECONDS);
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flowInAsync", (String)"flowInAsync/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowStaticWithAsync", (String)"flowStaticWithAsync/processors/0/processors/0")});
    }

    @Test
    public void subFlowStaticWithAsync() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowStaticWithAsync").withPayload((Object)"payload")).run();
        FlowTraceUtils.FlowStackAsyncAsserter.latch.await(1L, TimeUnit.SECONDS);
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlowInAsync", (String)"subFlowInAsync/processors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowStaticWithAsync", (String)"subFlowStaticWithAsync/processors/0/processors/0")});
    }

    @Test
    public void flowDynamicWithAsync() throws Exception {
        ((FlowRunner)this.flowRunner("flowDynamicWithAsync").withPayload((Object)"payload")).run();
        FlowTraceUtils.FlowStackAsyncAsserter.latch.await(1L, TimeUnit.SECONDS);
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flowInAsync", (String)"flowInAsync/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowDynamicWithAsync", (String)"flowDynamicWithAsync/processors/0/processors/0")});
    }

    @Test
    public void subFlowDynamicWithAsync() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowDynamicWithAsync").withPayload((Object)"payload")).run();
        FlowTraceUtils.FlowStackAsyncAsserter.latch.await(1L, TimeUnit.SECONDS);
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlowInAsync", (String)"subFlowInAsync/processors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowDynamicWithAsync", (String)"subFlowDynamicWithAsync/processors/0/processors/0")});
    }

    @Test
    public void flowStaticWithEnricher() throws Exception {
        ((FlowRunner)this.flowRunner("flowStaticWithEnricher").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowStaticWithEnricher", (String)"flowStaticWithEnricher/processors/0/processors/0")});
    }

    @Test
    public void subFlowStaticWithEnricher() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowStaticWithEnricher").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowStaticWithEnricher", (String)"subFlowStaticWithEnricher/processors/0/processors/0")});
    }

    @Test
    public void flowDynamicWithEnricher() throws Exception {
        ((FlowRunner)this.flowRunner("flowDynamicWithEnricher").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowDynamicWithEnricher", (String)"flowDynamicWithEnricher/processors/0/processors/0")});
    }

    @Test
    public void subFlowDynamicWithEnricher() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowDynamicWithEnricher").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowDynamicWithEnricher", (String)"subFlowDynamicWithEnricher/processors/0/processors/0")});
    }

    @Test
    public void flowStaticWithChoice() throws Exception {
        ((FlowRunner)this.flowRunner("flowStaticWithChoice").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowStaticWithChoice", (String)"flowStaticWithChoice/processors/0/route/0/processors/0")});
    }

    @Test
    public void subFlowStaticWithChoice() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowStaticWithChoice").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowStaticWithChoice", (String)"subFlowStaticWithChoice/processors/0/route/0/processors/0")});
    }

    @Test
    public void flowDynamicWithChoice() throws Exception {
        ((FlowRunner)this.flowRunner("flowDynamicWithChoice").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowDynamicWithChoice", (String)"flowDynamicWithChoice/processors/0/route/0/processors/0")});
    }

    @Test
    public void subFlowDynamicWithChoice() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowDynamicWithChoice").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowDynamicWithChoice", (String)"subFlowDynamicWithChoice/processors/0/route/0/processors/0")});
    }

    @Test
    public void flowStaticWithScatterGather() throws Exception {
        ((FlowRunner)this.flowRunner("flowStaticWithScatterGather").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowStaticWithScatterGather", (String)"flowStaticWithScatterGather/processors/0/route/1/processors/0")});
    }

    @Test
    public void subFlowStaticWithScatterGather() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowStaticWithScatterGather").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowStaticWithScatterGather", (String)"subFlowStaticWithScatterGather/processors/0/route/1/processors/0")});
    }

    @Test
    public void flowDynamicWithScatterGather() throws Exception {
        ((FlowRunner)this.flowRunner("flowDynamicWithScatterGather").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowDynamicWithScatterGather", (String)"flowDynamicWithScatterGather/processors/0/route/1/processors/0")});
    }

    @Test
    public void subFlowDynamicWithScatterGather() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowDynamicWithScatterGather").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowDynamicWithScatterGather", (String)"subFlowDynamicWithScatterGather/processors/0/route/1/processors/0")});
    }

    @Test
    public void flowStaticWithScatterGatherChain() throws Exception {
        ((FlowRunner)this.flowRunner("flowStaticWithScatterGatherChain").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowStaticWithScatterGatherChain", (String)"flowStaticWithScatterGatherChain/processors/0/route/1/processors/0")});
    }

    @Test
    public void subFlowStaticWithScatterGatherChain() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowStaticWithScatterGatherChain").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowStaticWithScatterGatherChain", (String)"subFlowStaticWithScatterGatherChain/processors/0/route/1/processors/0")});
    }

    @Test
    public void flowDynamicWithScatterGatherChain() throws Exception {
        ((FlowRunner)this.flowRunner("flowDynamicWithScatterGatherChain").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowDynamicWithScatterGatherChain", (String)"flowDynamicWithScatterGatherChain/processors/0/route/1/processors/0")});
    }

    @Test
    public void subFlowDynamicWithScatterGatherChain() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowDynamicWithScatterGatherChain").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowDynamicWithScatterGatherChain", (String)"subFlowDynamicWithScatterGatherChain/processors/0/route/1/processors/0")});
    }

    @Test
    public void flowForEach() throws Exception {
        ((FlowRunner)this.flowRunner("flowForEach").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowForEach", (String)"flowForEach/processors/0/processors/1")});
    }

    @Test
    public void xmlSdkOperation() throws Exception {
        ((FlowRunner)this.flowRunner("xmlSdkOperation").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"module-using-core:flow-stack-store", (String)"flow-stack-store/processors/0"), FlowTraceUtils.isFlowStackElement((String)"xmlSdkOperation", (String)"xmlSdkOperation/processors/0")});
    }

    @Test
    public void xmlSdkOperationInSubflow() throws Exception {
        ((FlowRunner)this.flowRunner("xmlSdkOperationInSubflow").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"module-using-core:flow-stack-store", (String)"flow-stack-store/processors/0"), FlowTraceUtils.isFlowStackElement((String)"xmlSdkOperation", (String)"xmlSdkOperation/processors/0"), FlowTraceUtils.isFlowStackElement((String)"xmlSdkOperationInSubflow", (String)"xmlSdkOperationInSubflow/processors/0")});
    }

    @Test
    public void xmlSdkOperationFailAfter() throws Exception {
        ((FlowRunner)this.flowRunner("xmlSdkOperationFailAfter").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"xmlSdkOperationFailAfter", (String)"xmlSdkOperationFailAfter/errorHandler/0/processors/0")});
    }

    @Test
    public void xmlSdkOperationFailAfterSubFlow() throws Exception {
        ((FlowRunner)this.flowRunner("xmlSdkOperationFailAfterSubFlow").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"xmlSdkOperationFailAfter", (String)"xmlSdkOperationFailAfter/errorHandler/0/processors/0"), FlowTraceUtils.isFlowStackElement((String)"xmlSdkOperationFailAfterSubFlow", (String)"xmlSdkOperationFailAfterSubFlow/processors/0")});
    }

    @Test
    public void xmlSdkOperationAfter() throws Exception {
        ((FlowRunner)this.flowRunner("xmlSdkOperationAfter").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"xmlSdkOperationAfter", (String)"xmlSdkOperationAfter/processors/1")});
    }

    @Test
    public void xmlSdkOperationError() throws Exception {
        ((FlowRunner)this.flowRunner("xmlSdkOperationError").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"xmlSdkOperationError", (String)"xmlSdkOperationError/processors/1")});
    }

    @Test
    public void xmlSdkOperationErrorInSubflow() throws Exception {
        ((FlowRunner)this.flowRunner("xmlSdkOperationErrorInSubflow").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"xmlSdkOperationError", (String)"xmlSdkOperationError/processors/1"), FlowTraceUtils.isFlowStackElement((String)"xmlSdkOperationErrorInSubflow", (String)"xmlSdkOperationErrorInSubflow/processors/0")});
    }
}

