/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.core.context.notification.processors;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import javax.inject.Inject;
import javax.inject.Named;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.config.api.dsl.CoreDslConstants;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.core.context.notification.processors.ProcessorNotificationStore;

@Feature(value="Configuration component locator")
@Story(value="Component location")
public class ComponentLocationTestCase
extends AbstractIntegrationTestCase {
    private static final Optional<TypedComponentIdentifier> FLOW_TYPED_COMPONENT_IDENTIFIER = Optional.of(TypedComponentIdentifier.builder().identifier(CoreDslConstants.FLOW_IDENTIFIER).type(TypedComponentIdentifier.ComponentType.FLOW).build());
    private static final Optional<TypedComponentIdentifier> SUB_FLOW_TYPED_COMPONENT_IDENTIFIER = Optional.of(TypedComponentIdentifier.builder().identifier(CoreDslConstants.SUBFLOW_IDENTIFIER).type(TypedComponentIdentifier.ComponentType.SCOPE).build());
    private static final Optional<String> CONFIG_FILE_NAME = Optional.of("org/mule/test/integration/notifications/component-path-test-flow.xml");
    private static final DefaultComponentLocation FLOW_WITH_SINGLE_MP_LOCATION = new DefaultComponentLocation(Optional.of("flowWithSingleMp"), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart("flowWithSingleMp", FLOW_TYPED_COMPONENT_IDENTIFIER, CONFIG_FILE_NAME, Optional.of(27))));
    private static final DefaultComponentLocation FLOW_WITH_MULTIPLE_MP_LOCATION = new DefaultComponentLocation(Optional.of("flowWithMultipleMps"), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart("flowWithMultipleMps", FLOW_TYPED_COMPONENT_IDENTIFIER, CONFIG_FILE_NAME, Optional.of(31))));
    private static final DefaultComponentLocation FLOW_WITH_ERROR_HANDLER = new DefaultComponentLocation(Optional.of("flowWithErrorHandler"), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart("flowWithErrorHandler", FLOW_TYPED_COMPONENT_IDENTIFIER, CONFIG_FILE_NAME, Optional.of(37))));
    private static final DefaultComponentLocation FLOW_WITH_BLOCK_WITH_ERROR_HANDLER = new DefaultComponentLocation(Optional.of("flowWithTryWithErrorHandler"), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart("flowWithTryWithErrorHandler", FLOW_TYPED_COMPONENT_IDENTIFIER, CONFIG_FILE_NAME, Optional.of(58))));
    private static final DefaultComponentLocation FLOW_WITH_SOURCE = new DefaultComponentLocation(Optional.of("flowWithSource"), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart("flowWithSource", FLOW_TYPED_COMPONENT_IDENTIFIER, CONFIG_FILE_NAME, Optional.of(70))));
    private static final DefaultComponentLocation FLOW_WITH_SCATTER_GATHER = new DefaultComponentLocation(Optional.of("flowWithScatterGather"), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart("flowWithScatterGather", FLOW_TYPED_COMPONENT_IDENTIFIER, CONFIG_FILE_NAME, Optional.of(98))));
    private static final DefaultComponentLocation FLOW_WITH_ASYNC = new DefaultComponentLocation(Optional.of("flowWithAsync"), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart("flowWithAsync", FLOW_TYPED_COMPONENT_IDENTIFIER, CONFIG_FILE_NAME, Optional.of(112))));
    private static final DefaultComponentLocation FLOW_WITH_SUBFLOW = new DefaultComponentLocation(Optional.of("flowWithSubflow"), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart("flowWithSubflow", FLOW_TYPED_COMPONENT_IDENTIFIER, CONFIG_FILE_NAME, Optional.of(87))));
    private static final DefaultComponentLocation SUBFLOW = new DefaultComponentLocation(Optional.of("subflow"), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart("subflow", SUB_FLOW_TYPED_COMPONENT_IDENTIFIER, CONFIG_FILE_NAME, Optional.of(93))));
    private static final Optional<TypedComponentIdentifier> LOGGER = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:logger")).type(TypedComponentIdentifier.ComponentType.OPERATION).build());
    private static final Optional<TypedComponentIdentifier> SET_PAYLOAD = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:set-payload")).type(TypedComponentIdentifier.ComponentType.OPERATION).build());
    private static final Optional<TypedComponentIdentifier> OBJECT_TO_STRING_TRANSFORMER = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:object-to-byte-array-transformer")).type(TypedComponentIdentifier.ComponentType.UNKNOWN).build());
    private static final Optional<TypedComponentIdentifier> CHOICE = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:choice")).type(TypedComponentIdentifier.ComponentType.ROUTER).build());
    private static final Optional<TypedComponentIdentifier> ERROR_HANDLER = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:error-handler")).type(TypedComponentIdentifier.ComponentType.ERROR_HANDLER).build());
    private static final Optional<TypedComponentIdentifier> ON_ERROR_CONTINUE = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:on-error-continue")).type(TypedComponentIdentifier.ComponentType.ON_ERROR).build());
    private static final Optional<TypedComponentIdentifier> VALIDATION_IS_FALSE = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"validation:is-false")).type(TypedComponentIdentifier.ComponentType.OPERATION).build());
    private static final Optional<TypedComponentIdentifier> TEST_PROCESSOR = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"test:processor")).type(TypedComponentIdentifier.ComponentType.UNKNOWN).build());
    private static final Optional<TypedComponentIdentifier> ON_ERROR_PROPAGATE = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:on-error-propagate")).type(TypedComponentIdentifier.ComponentType.ON_ERROR).build());
    private static final Optional<TypedComponentIdentifier> TRY = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:try")).type(TypedComponentIdentifier.ComponentType.SCOPE).build());
    private static final Optional<TypedComponentIdentifier> VALIDATION_IS_TRUE = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"validation:is-true")).type(TypedComponentIdentifier.ComponentType.OPERATION).build());
    private static final Optional<TypedComponentIdentifier> SCHEDULER_SOURCE = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:scheduler")).type(TypedComponentIdentifier.ComponentType.SOURCE).build());
    private static final Optional<TypedComponentIdentifier> SCATTER_GATHER = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:scatter-gather")).type(TypedComponentIdentifier.ComponentType.ROUTER).build());
    private static final Optional<TypedComponentIdentifier> FLOW_REF = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:flow-ref")).type(TypedComponentIdentifier.ComponentType.OPERATION).build());
    private static final Optional<TypedComponentIdentifier> ASYNC = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:async")).type(TypedComponentIdentifier.ComponentType.SCOPE).build());
    private static final Optional<TypedComponentIdentifier> ROUTE = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:route")).type(TypedComponentIdentifier.ComponentType.SCOPE).build());
    @Inject
    @Named(value="flowWithSource")
    private Flow flowWithSource;
    @Inject
    private ConfigurationComponentLocator configurationComponentLocator;

    protected String getConfigFile() {
        return CONFIG_FILE_NAME.get();
    }

    @Test
    public void flowWithSingleMp() throws Exception {
        this.flowRunner("flowWithSingleMp").run();
        this.assertNextProcessorLocationIs(FLOW_WITH_SINGLE_MP_LOCATION.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", LOGGER, CONFIG_FILE_NAME, Optional.of(28)));
        this.assertNoNextProcessorNotification();
    }

    @Test
    public void flowWithMultipleMps() throws Exception {
        this.flowRunner("flowWithMultipleMps").run();
        this.assertNextProcessorLocationIs(FLOW_WITH_MULTIPLE_MP_LOCATION.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", LOGGER, CONFIG_FILE_NAME, Optional.of(32)));
        this.assertNextProcessorLocationIs(FLOW_WITH_MULTIPLE_MP_LOCATION.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("1", SET_PAYLOAD, CONFIG_FILE_NAME, Optional.of(33)));
        this.assertNextProcessorLocationIs(FLOW_WITH_MULTIPLE_MP_LOCATION.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("2", OBJECT_TO_STRING_TRANSFORMER, CONFIG_FILE_NAME, Optional.of(34)));
        this.assertNoNextProcessorNotification();
    }

    @Test
    public void flowWithErrorHandlerExecutingOnContinue() throws Exception {
        ((FlowRunner)this.flowRunner("flowWithErrorHandler").withVariable("executeFailingComponent", (Object)false)).run();
        DefaultComponentLocation choiceLocation = FLOW_WITH_ERROR_HANDLER.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", CHOICE, CONFIG_FILE_NAME, Optional.of(38));
        this.assertNextProcessorLocationIs(choiceLocation);
        this.assertNextProcessorLocationIs(FLOW_WITH_ERROR_HANDLER.appendLocationPart("errorHandler", ERROR_HANDLER, CONFIG_FILE_NAME, Optional.of(46)).appendLocationPart("0", ON_ERROR_CONTINUE, CONFIG_FILE_NAME, Optional.of(47)).appendProcessorsPart().appendLocationPart("0", VALIDATION_IS_FALSE, CONFIG_FILE_NAME, Optional.of(48)));
        this.assertNoNextProcessorNotification();
    }

    @Test
    public void flowWithErrorHandlerExecutingOnPropagate() throws Exception {
        ((FlowRunner)this.flowRunner("flowWithErrorHandler").withVariable("executeFailingComponent", (Object)true)).runExpectingException();
        DefaultComponentLocation choiceLocation = FLOW_WITH_ERROR_HANDLER.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", CHOICE, CONFIG_FILE_NAME, Optional.of(38));
        this.assertNextProcessorLocationIs(choiceLocation);
        DefaultComponentLocation choiceRoute0 = choiceLocation.appendRoutePart().appendLocationPart("0", ROUTE, CONFIG_FILE_NAME, Optional.of(39));
        this.assertNextProcessorLocationIs(choiceRoute0.appendProcessorsPart().appendLocationPart("0", TEST_PROCESSOR, CONFIG_FILE_NAME, Optional.of(40)));
        this.assertNextProcessorLocationIs(FLOW_WITH_ERROR_HANDLER.appendLocationPart("errorHandler", ERROR_HANDLER, CONFIG_FILE_NAME, Optional.of(46)).appendLocationPart("1", ON_ERROR_PROPAGATE, CONFIG_FILE_NAME, Optional.of(50)).appendProcessorsPart().appendLocationPart("0", TRY, CONFIG_FILE_NAME, Optional.of(51)));
        this.assertNextProcessorLocationIs(FLOW_WITH_ERROR_HANDLER.appendLocationPart("errorHandler", ERROR_HANDLER, CONFIG_FILE_NAME, Optional.of(46)).appendLocationPart("1", ON_ERROR_PROPAGATE, CONFIG_FILE_NAME, Optional.of(50)).appendProcessorsPart().appendLocationPart("0", TRY, CONFIG_FILE_NAME, Optional.of(51)).appendProcessorsPart().appendLocationPart("0", VALIDATION_IS_TRUE, CONFIG_FILE_NAME, Optional.of(52)));
        this.assertNoNextProcessorNotification();
    }

    @Test
    public void flowWithBlockWithErrorHandler() throws Exception {
        this.flowRunner("flowWithTryWithErrorHandler").run();
        DefaultComponentLocation blockLocation = FLOW_WITH_BLOCK_WITH_ERROR_HANDLER.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", TRY, CONFIG_FILE_NAME, Optional.of(59));
        this.assertNextProcessorLocationIs(blockLocation);
        this.assertNextProcessorLocationIs(blockLocation.appendProcessorsPart().appendLocationPart("0", TEST_PROCESSOR, CONFIG_FILE_NAME, Optional.of(60)));
        DefaultComponentLocation blockOnErrorContinueLocation = blockLocation.appendLocationPart("errorHandler", ERROR_HANDLER, CONFIG_FILE_NAME, Optional.of(61)).appendLocationPart("0", ON_ERROR_CONTINUE, CONFIG_FILE_NAME, Optional.of(62));
        this.assertNextProcessorLocationIs(blockOnErrorContinueLocation.appendProcessorsPart().appendLocationPart("0", VALIDATION_IS_FALSE, CONFIG_FILE_NAME, Optional.of(63)));
        this.assertNextProcessorLocationIs(blockOnErrorContinueLocation.appendProcessorsPart().appendLocationPart("1", VALIDATION_IS_TRUE, CONFIG_FILE_NAME, Optional.of(64)));
        this.assertNoNextProcessorNotification();
    }

    @Test
    public void flowWithSource() throws Exception {
        DefaultComponentLocation expectedSourceLocation = FLOW_WITH_SOURCE.appendLocationPart("source", SCHEDULER_SOURCE, CONFIG_FILE_NAME, Optional.of(71));
        DefaultComponentLocation sourceLocation = (DefaultComponentLocation)this.flowWithSource.getSource().getAnnotation(AbstractComponent.LOCATION_KEY);
        Assert.assertThat((Object)sourceLocation, (Matcher)Is.is((Object)expectedSourceLocation));
        Assert.assertThat((Object)((Component)this.flowWithSource.getProcessors().get(0)).getAnnotation(AbstractComponent.LOCATION_KEY), (Matcher)Is.is((Object)FLOW_WITH_SOURCE.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", LOGGER, CONFIG_FILE_NAME, Optional.of(76))));
    }

    @Test
    public void flowWithSubflow() throws Exception {
        this.flowRunner("flowWithSubflow").run();
        DefaultComponentLocation flowWithSplitterProcessorsLocation = FLOW_WITH_SUBFLOW.appendProcessorsPart();
        this.assertNextProcessorLocationIs(flowWithSplitterProcessorsLocation.appendLocationPart("0", LOGGER, CONFIG_FILE_NAME, Optional.of(88)));
        this.assertNextProcessorLocationIs(flowWithSplitterProcessorsLocation.appendLocationPart("1", FLOW_REF, CONFIG_FILE_NAME, Optional.of(89)));
        this.assertNextProcessorLocationIs(SUBFLOW.appendProcessorsPart().appendLocationPart("0", LOGGER, CONFIG_FILE_NAME, Optional.of(94)));
        this.assertNextProcessorLocationIs(SUBFLOW.appendProcessorsPart().appendLocationPart("1", VALIDATION_IS_TRUE, CONFIG_FILE_NAME, Optional.of(95)));
        this.assertNextProcessorLocationIs(flowWithSplitterProcessorsLocation.appendLocationPart("2", VALIDATION_IS_FALSE, CONFIG_FILE_NAME, Optional.of(90)));
        this.assertNoNextProcessorNotification();
    }

    @Test
    public void flowWithScatterGather() throws Exception {
        this.flowRunner("flowWithScatterGather").run();
        this.waitUntilNotificationsArrived(4);
        DefaultComponentLocation flowWithSplitterProcessorsLocation = FLOW_WITH_SCATTER_GATHER.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty());
        DefaultComponentLocation scatterGatherLocation = flowWithSplitterProcessorsLocation.appendLocationPart("0", SCATTER_GATHER, CONFIG_FILE_NAME, Optional.of(99));
        this.assertNextProcessorLocationIs(scatterGatherLocation);
        DefaultComponentLocation scatterGatherRoute0 = scatterGatherLocation.appendRoutePart().appendLocationPart("0", ROUTE, CONFIG_FILE_NAME, Optional.of(100));
        DefaultComponentLocation scatterGatherRouter1 = scatterGatherLocation.appendRoutePart().appendLocationPart("1", ROUTE, CONFIG_FILE_NAME, Optional.of(103));
        DefaultComponentLocation scatterGatherRouter2 = scatterGatherLocation.appendRoutePart().appendLocationPart("2", ROUTE, CONFIG_FILE_NAME, Optional.of(106));
        List<DefaultComponentLocation> nextLocations = Arrays.asList(scatterGatherRoute0.appendProcessorsPart().appendLocationPart("0", LOGGER, CONFIG_FILE_NAME, Optional.of(101)), scatterGatherRouter1.appendProcessorsPart().appendLocationPart("0", VALIDATION_IS_TRUE, CONFIG_FILE_NAME, Optional.of(104)), scatterGatherRouter2.appendProcessorsPart().appendLocationPart("0", VALIDATION_IS_FALSE, CONFIG_FILE_NAME, Optional.of(107)));
        this.assertNextProcessorLocationsAre(nextLocations);
        this.assertNoNextProcessorNotification();
    }

    @Test
    public void flowWithAsync() throws Exception {
        FlowRunner runner = this.flowRunner("flowWithAsync");
        CountDownLatch terminationLatch = new CountDownLatch(1);
        ((BaseEventContext)runner.buildEvent().getContext()).onTerminated((e, t) -> terminationLatch.countDown());
        runner.run();
        this.waitUntilNotificationsArrived(3);
        DefaultComponentLocation flowWithAsyncLocation = FLOW_WITH_ASYNC.appendProcessorsPart();
        DefaultComponentLocation asyncLocation = flowWithAsyncLocation.appendLocationPart("0", ASYNC, CONFIG_FILE_NAME, Optional.of(113));
        this.assertNextProcessorLocationIs(asyncLocation);
        DefaultComponentLocation asyncProcessorsLocation = asyncLocation.appendProcessorsPart();
        this.assertNextProcessorLocationIs(asyncProcessorsLocation.appendLocationPart("0", LOGGER, CONFIG_FILE_NAME, Optional.of(114)));
        this.assertNextProcessorLocationIs(asyncProcessorsLocation.appendLocationPart("1", VALIDATION_IS_TRUE, CONFIG_FILE_NAME, Optional.of(115)));
        this.assertNoNextProcessorNotification();
        terminationLatch.await();
    }

    @Test
    public void defaultErrorHandlerFromFlowCannotBeAccesed() throws Exception {
        Location defaultErrorHandlerLoggerLocation = Location.builder().globalName("flowWithSingleMp").addErrorHandlerPart().addIndexPart(0).addProcessorsPart().addIndexPart(0).build();
        Optional component = this.configurationComponentLocator.find(defaultErrorHandlerLoggerLocation);
        Assert.assertThat((Object)component.isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void defaultErrorHandler() throws Exception {
        Location defaultErrorHandlerLoggerLocation = Location.builder().globalName("defaultErrorHandler").build();
        Optional component = this.configurationComponentLocator.find(defaultErrorHandlerLoggerLocation);
        Assert.assertThat((Object)component.isPresent(), (Matcher)Is.is((Object)false));
    }

    private void waitUntilNotificationsArrived(final int minimumRequiredNotifications) {
        new PollingProber(5000L, 100L).check(new Probe(){

            public boolean isSatisfied() {
                return ComponentLocationTestCase.this.getNotificationsStore().getNotifications().size() >= minimumRequiredNotifications;
            }

            public String describeFailure() {
                return "not all expected notifications arrived";
            }
        });
    }

    private void assertNoNextProcessorNotification() {
        ProcessorNotificationStore processorNotificationStore = this.getNotificationsStore();
        Iterator iterator = processorNotificationStore.getNotifications().iterator();
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Is.is((Object)false));
    }

    private void assertNextProcessorLocationIs(DefaultComponentLocation componentLocation) {
        ProcessorNotificationStore processorNotificationStore = this.getNotificationsStore();
        Assert.assertThat((Object)processorNotificationStore.getNotifications().isEmpty(), (Matcher)Is.is((Object)false));
        MessageProcessorNotification processorNotification = (MessageProcessorNotification)processorNotificationStore.getNotifications().get(0);
        Assert.assertThat((Object)processorNotification.getComponent().getLocation().getLocation(), (Matcher)Is.is((Object)componentLocation.getLocation()));
        Assert.assertThat((Object)processorNotification.getComponent().getLocation(), (Matcher)Is.is((Object)componentLocation));
        processorNotificationStore.getNotifications().remove(0);
    }

    private void assertNextProcessorLocationsAre(List<DefaultComponentLocation> componentLocations) {
        StringBuilder errors = new StringBuilder();
        for (int i = 0; i < componentLocations.size(); ++i) {
            String errorString;
            for (DefaultComponentLocation componentLocation : componentLocations) {
                try {
                    this.assertNextProcessorLocationIs(componentLocation);
                    errors = new StringBuilder();
                    break;
                }
                catch (AssertionError e) {
                    errors.append(((Throwable)((Object)e)).getMessage());
                }
            }
            if ((errorString = errors.toString()).isEmpty()) continue;
            Assert.fail((String)String.format("Not every componentLocation was found in the notification list. %s", errorString));
        }
    }

    private ProcessorNotificationStore getNotificationsStore() {
        return (ProcessorNotificationStore)((Object)this.registry.lookupByName("notificationsStore").get());
    }
}

