/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.core.context.notification.processors;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Configuration component locator")
@Story(value="Component type")
public class ComponentTypeTestCase
extends AbstractIntegrationTestCase {
    protected String getConfigFile() {
        return "org/mule/test/components/component-type-config.xml";
    }

    @Test
    public void routerComponentTypes() {
        Assert.assertThat((Object)this.getComponentType(ComponentIdentifier.buildFromStringRepresentation((String)"first-successful")), (Matcher)Is.is((Object)TypedComponentIdentifier.ComponentType.ROUTER));
        Assert.assertThat((Object)this.getComponentType(ComponentIdentifier.buildFromStringRepresentation((String)"scatter-gather")), (Matcher)Is.is((Object)TypedComponentIdentifier.ComponentType.ROUTER));
        Assert.assertThat((Object)this.getComponentType(ComponentIdentifier.buildFromStringRepresentation((String)"choice")), (Matcher)Is.is((Object)TypedComponentIdentifier.ComponentType.ROUTER));
        Assert.assertThat((Object)this.getComponentType(ComponentIdentifier.buildFromStringRepresentation((String)"round-robin")), (Matcher)Is.is((Object)TypedComponentIdentifier.ComponentType.ROUTER));
    }

    @Test
    public void scopeComponentTypes() {
        Assert.assertThat((Object)this.getComponentType(ComponentIdentifier.buildFromStringRepresentation((String)"try")), (Matcher)Is.is((Object)TypedComponentIdentifier.ComponentType.SCOPE));
        Assert.assertThat((Object)this.getComponentType(ComponentIdentifier.buildFromStringRepresentation((String)"until-successful")), (Matcher)Is.is((Object)TypedComponentIdentifier.ComponentType.SCOPE));
        Assert.assertThat((Object)this.getComponentType(ComponentIdentifier.buildFromStringRepresentation((String)"async")), (Matcher)Is.is((Object)TypedComponentIdentifier.ComponentType.SCOPE));
        Assert.assertThat((Object)this.getComponentType(ComponentIdentifier.buildFromStringRepresentation((String)"foreach")), (Matcher)Is.is((Object)TypedComponentIdentifier.ComponentType.SCOPE));
    }

    @Test
    public void operationsComponentTypes() {
        Assert.assertThat((Object)this.getComponentType(ComponentIdentifier.buildFromStringRepresentation((String)"set-payload")), (Matcher)Is.is((Object)TypedComponentIdentifier.ComponentType.OPERATION));
        Assert.assertThat((Object)this.getComponentType(ComponentIdentifier.buildFromStringRepresentation((String)"set-variable")), (Matcher)Is.is((Object)TypedComponentIdentifier.ComponentType.OPERATION));
        Assert.assertThat((Object)this.getComponentType(ComponentIdentifier.buildFromStringRepresentation((String)"remove-variable")), (Matcher)Is.is((Object)TypedComponentIdentifier.ComponentType.OPERATION));
        Assert.assertThat((Object)this.getComponentType(ComponentIdentifier.buildFromStringRepresentation((String)"parse-template")), (Matcher)Is.is((Object)TypedComponentIdentifier.ComponentType.OPERATION));
        Assert.assertThat((Object)this.getComponentType(ComponentIdentifier.buildFromStringRepresentation((String)"idempotent-message-validator")), (Matcher)Is.is((Object)TypedComponentIdentifier.ComponentType.OPERATION));
        Assert.assertThat((Object)this.getComponentType(ComponentIdentifier.buildFromStringRepresentation((String)"raise-error")), (Matcher)Is.is((Object)TypedComponentIdentifier.ComponentType.OPERATION));
        Assert.assertThat((Object)this.getComponentType(ComponentIdentifier.buildFromStringRepresentation((String)"http:request")), (Matcher)Is.is((Object)TypedComponentIdentifier.ComponentType.OPERATION));
        Assert.assertThat((Object)this.getComponentType(ComponentIdentifier.buildFromStringRepresentation((String)"module-using-core:set-payload-hardcoded")), (Matcher)Is.is((Object)TypedComponentIdentifier.ComponentType.OPERATION));
    }

    @Test
    public void errorComponentTypes() {
        Assert.assertThat((Object)this.getComponentType(ComponentIdentifier.buildFromStringRepresentation((String)"error-handler")), (Matcher)Is.is((Object)TypedComponentIdentifier.ComponentType.ERROR_HANDLER));
        Assert.assertThat((Object)this.getComponentType(ComponentIdentifier.buildFromStringRepresentation((String)"on-error-continue")), (Matcher)Is.is((Object)TypedComponentIdentifier.ComponentType.ON_ERROR));
    }

    @Test
    public void flowComponentType() {
        Assert.assertThat((Object)this.getComponentType(ComponentIdentifier.buildFromStringRepresentation((String)"flow")), (Matcher)Is.is((Object)TypedComponentIdentifier.ComponentType.FLOW));
    }

    @Test
    public void unknownComponentType() {
        Assert.assertThat((Object)this.getComponentType(ComponentIdentifier.buildFromStringRepresentation((String)"http:request-config")), (Matcher)Is.is((Object)TypedComponentIdentifier.ComponentType.UNKNOWN));
    }

    @Test
    public void sourceComponentType() {
        Assert.assertThat((Object)this.getComponentType(ComponentIdentifier.buildFromStringRepresentation((String)"scheduler")), (Matcher)Is.is((Object)TypedComponentIdentifier.ComponentType.SOURCE));
    }

    private TypedComponentIdentifier.ComponentType getComponentType(ComponentIdentifier componentIdentifier) {
        return ((Component)this.locator.find(componentIdentifier).get(0)).getLocation().getComponentIdentifier().getType();
    }
}

