/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.core.context.notification.processors;

import com.google.common.collect.ImmutableList;
import io.qameta.allure.junit4.DisplayName;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.util.collection.Collectors;
import org.mule.runtime.config.api.XmlConfigurationDocumentLoader;
import org.mule.runtime.config.api.dsl.CoreDslConstants;
import org.mule.runtime.config.api.dsl.processor.ArtifactConfig;
import org.mule.runtime.config.api.dsl.processor.ConfigFile;
import org.mule.runtime.config.api.dsl.processor.ConfigLine;
import org.mule.runtime.config.api.dsl.processor.xml.XmlApplicationParser;
import org.mule.runtime.config.api.dsl.xml.StaticXmlNamespaceInfo;
import org.mule.runtime.config.api.dsl.xml.StaticXmlNamespaceInfoProvider;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfoProvider;
import org.mule.runtime.extension.api.loader.xml.XmlExtensionModelLoader;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.core.context.notification.processors.ProcessorNotificationStore;
import org.w3c.dom.Document;

@DisplayName(value="XML Connectors Path generation")
public class ModuleComponentPathTestCase
extends AbstractIntegrationTestCase {
    private static final String COLON_SEPARATOR = ":";
    private static final String MODULE_SIMPLE_XML = "module-simple.xml";
    private static final String MODULE_SIMPLE_PROXY_XML = "module-simple-proxy.xml";
    private static final String FLOWS_USING_MODULE_SIMPLE_XML = "flows-using-modules.xml";
    private static final String BASE_PATH_XML_MODULES = "org/mule/test/integration/notifications/modules/";
    private static final Optional<String> CONFIG_FILE_NAME = Optional.of("org/mule/test/integration/notifications/modules/flows-using-modules.xml");
    private static final Optional<String> MODULE_SIMPLE_FILE_NAME = Optional.of("org/mule/test/integration/notifications/modules/module-simple.xml");
    private static final Optional<String> MODULE_SIMPLE_PROXY_FILE_NAME = Optional.of("org/mule/test/integration/notifications/modules/module-simple-proxy.xml");
    private static final Optional<TypedComponentIdentifier> FLOW_TYPED_COMPONENT_IDENTIFIER = Optional.of(TypedComponentIdentifier.builder().identifier(CoreDslConstants.FLOW_IDENTIFIER).type(TypedComponentIdentifier.ComponentType.FLOW).build());
    private static final String FLOW_WITH_SINGLE_MP_NAME = "flowWithSingleMp";
    private static final String FLOW_WITH_SET_PAYLOAD_HARDCODED_NAME = "flowWithSetPayloadHardcoded";
    private static final String FLOW_WITH_SET_PAYLOAD_TWO_TIMES_NAME = "flowWithSetPayloadTwoTimes";
    private static final String FLOW_WITH_SET_PAYLOAD_HARDCODED_TWICE_NAME = "flowWithSetPayloadHardcodedTwice";
    private static final String FLOW_WITH_SET_PAYLOAD_PARAM_VALUE_NAME = "flowWithSetPayloadParamValue";
    private static final String FLOW_WITH_SET_PAYLOAD_TWO_TIMES_TWICE_NAME = "flowWithSetPayloadTwoTimesTwice";
    private static final String FLOW_WITH_PROXY_SET_PAYLOAD_HARDCODED_NAME = "flowWithProxySetPayloadHardcoded";
    private static final String FLOW_WITH_PROXY_SET_PAYLOAD_HARDCODED_AND_LOGGER_NAME = "flowWithProxySetPayloadHardcodedAndLogger";
    private static final String FLOW_WITH_PROXY_AND_SIMPLE_MODULE_AND_LOGGER_NAME = "flowWithProxyAndSimpleModuleAndLogger";
    private static final String FLOW_WITH_PROXY_AND_SIMPLE_MODULE_AND_LOGGER_REVERSE_NAME = "flowWithProxyAndSimpleModuleAndLoggerReverse";
    private static final DefaultComponentLocation FLOW_WITH_SINGLE_MP_LOCATION = ModuleComponentPathTestCase.getFlowLocation("flowWithSingleMp", 15);
    private static final DefaultComponentLocation FLOW_WITH_SET_PAYLOAD_HARDCODED = ModuleComponentPathTestCase.getFlowLocation("flowWithSetPayloadHardcoded", 19);
    private static final DefaultComponentLocation FLOW_WITH_SET_PAYLOAD_HARDCODED_TWICE = ModuleComponentPathTestCase.getFlowLocation("flowWithSetPayloadHardcodedTwice", 23);
    private static final DefaultComponentLocation FLOW_WITH_SET_PAYLOAD_PARAM_VALUE = ModuleComponentPathTestCase.getFlowLocation("flowWithSetPayloadParamValue", 28);
    private static final DefaultComponentLocation FLOW_WITH_SET_PAYLOAD_TWO_TIMES = ModuleComponentPathTestCase.getFlowLocation("flowWithSetPayloadTwoTimes", 32);
    private static final DefaultComponentLocation FLOW_WITH_SET_PAYLOAD_TWO_TIMES_TWICE = ModuleComponentPathTestCase.getFlowLocation("flowWithSetPayloadTwoTimesTwice", 36);
    private static final DefaultComponentLocation FLOW_WITH_PROXY_SET_PAYLOAD_HARDCODED = ModuleComponentPathTestCase.getFlowLocation("flowWithProxySetPayloadHardcoded", 41);
    private static final DefaultComponentLocation FLOW_WITH_PROXY_SET_PAYLOAD_HARDCODED_AND_LOGGER = ModuleComponentPathTestCase.getFlowLocation("flowWithProxySetPayloadHardcodedAndLogger", 45);
    private static final DefaultComponentLocation FLOW_WITH_PROXY_AND_SIMPLE_MODULE_AND_LOGGER = ModuleComponentPathTestCase.getFlowLocation("flowWithProxyAndSimpleModuleAndLogger", 49);
    private static final DefaultComponentLocation FLOW_WITH_PROXY_AND_SIMPLE_MODULE_AND_LOGGER_REVERSE = ModuleComponentPathTestCase.getFlowLocation("flowWithProxyAndSimpleModuleAndLoggerReverse", 55);
    private static final String MODULE_SIMPLE_NAMESPACE_IN_APP = "simple-prefix";
    private static final String SET_PAYLOAD_HARDCODED_VALUE_NAME = "set-payload-hardcoded-value";
    private static final Optional<TypedComponentIdentifier> MODULE_SET_PAYLOAD_HARDCODED_VALUE = ModuleComponentPathTestCase.getModuleOperationIdentifier("simple-prefix", "set-payload-hardcoded-value");
    private static final DefaultComponentLocation OPERATION_SET_PAYLOAD_HARDCODED_VALUE_FIRST_MP = ModuleComponentPathTestCase.getModuleOperationLocation("set-payload-hardcoded-value", MODULE_SET_PAYLOAD_HARDCODED_VALUE, MODULE_SIMPLE_FILE_NAME, 13);
    private static final String SET_PAYLOAD_PARAM_VALUE_NAME = "set-payload-param-value";
    private static final Optional<TypedComponentIdentifier> MODULE_SET_PAYLOAD_PARAM_VALUE = ModuleComponentPathTestCase.getModuleOperationIdentifier("simple-prefix", "set-payload-param-value");
    private static final DefaultComponentLocation OPERATION_SET_PAYLOAD_PARAM_VALUE_FIRST_MP = ModuleComponentPathTestCase.getModuleOperationLocation("set-payload-param-value", MODULE_SET_PAYLOAD_PARAM_VALUE, MODULE_SIMPLE_FILE_NAME, 23);
    private static final String SET_PAYLOAD_TWO_TIMES_NAME = "set-payload-two-times";
    private static final Optional<TypedComponentIdentifier> MODULE_SET_PAYLOAD_TWO_TIMES = ModuleComponentPathTestCase.getModuleOperationIdentifier("simple-prefix", "set-payload-two-times");
    private static final DefaultComponentLocation OPERATION_SET_PAYLOAD_TWO_TIMES_FIRST_MP = ModuleComponentPathTestCase.getModuleOperationLocation("set-payload-two-times", MODULE_SET_PAYLOAD_TWO_TIMES, MODULE_SIMPLE_FILE_NAME, 30);
    private static final DefaultComponentLocation OPERATION_SET_PAYLOAD_TWO_TIMES_SECOND_MP = ModuleComponentPathTestCase.getModuleOperationLocation("set-payload-two-times", MODULE_SET_PAYLOAD_TWO_TIMES, MODULE_SIMPLE_FILE_NAME, 31);
    private static final String MODULE_SIMPLE_PROXY_NAMESPACE_IN_APP = "module-simple-proxy";
    private static final String PROXY_SET_PAYLOAD_NAME = "proxy-set-payload-hardcoded-value";
    private static final Optional<TypedComponentIdentifier> MODULE_PROXY_SET_PAYLOAD = ModuleComponentPathTestCase.getModuleOperationIdentifier("module-simple-proxy", "proxy-set-payload-hardcoded-value");
    private static final DefaultComponentLocation OPERATION_PROXY_SET_PAYLOAD_FIRST_MP = ModuleComponentPathTestCase.getModuleOperationLocation("proxy-set-payload-hardcoded-value", MODULE_PROXY_SET_PAYLOAD, MODULE_SIMPLE_PROXY_FILE_NAME, 13);
    private static final String PROXY_SET_PAYLOAD_AND_LOGGER_NAME = "proxy-set-payload-hardcoded-value-and-logger";
    private static final Optional<TypedComponentIdentifier> MODULE_PROXY_SET_PAYLOAD_AND_LOGGER = ModuleComponentPathTestCase.getModuleOperationIdentifier("module-simple-proxy", "proxy-set-payload-hardcoded-value-and-logger");
    private static final DefaultComponentLocation OPERATION_PROXY_SET_PAYLOAD_AND_LOGGER_FIRST_MP = ModuleComponentPathTestCase.getModuleOperationLocation("proxy-set-payload-hardcoded-value-and-logger", MODULE_PROXY_SET_PAYLOAD_AND_LOGGER, MODULE_SIMPLE_PROXY_FILE_NAME, 20);
    private static final DefaultComponentLocation OPERATION_PROXY_SET_PAYLOAD_AND_LOGGER_SECOND_MP = ModuleComponentPathTestCase.getModuleOperationLocation("proxy-set-payload-hardcoded-value-and-logger", MODULE_PROXY_SET_PAYLOAD_AND_LOGGER, MODULE_SIMPLE_PROXY_FILE_NAME, 21);
    private static final Optional<TypedComponentIdentifier> LOGGER = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:logger")).type(TypedComponentIdentifier.ComponentType.OPERATION).build());
    private static final Optional<TypedComponentIdentifier> SET_PAYLOAD = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:set-payload")).type(TypedComponentIdentifier.ComponentType.OPERATION).build());
    final ProcessorNotificationStore listener = new ProcessorNotificationStore();

    protected String getConfigFile() {
        return CONFIG_FILE_NAME.get();
    }

    private static final DefaultComponentLocation getFlowLocation(String flowName, int flowLineNumber) {
        return new DefaultComponentLocation(Optional.of(flowName), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart(flowName, FLOW_TYPED_COMPONENT_IDENTIFIER, CONFIG_FILE_NAME, Optional.of(flowLineNumber))));
    }

    private static Optional<TypedComponentIdentifier> getModuleOperationIdentifier(String namespace, String identifier) {
        return Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)(namespace + COLON_SEPARATOR + identifier))).type(TypedComponentIdentifier.ComponentType.OPERATION).build());
    }

    private static DefaultComponentLocation getModuleOperationLocation(String operationName, Optional<TypedComponentIdentifier> operationIdentifier, Optional<String> moduleFilename, int operationLineNumber) {
        return new DefaultComponentLocation(Optional.of(operationName), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart(operationName, operationIdentifier, moduleFilename, Optional.of(operationLineNumber))));
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.listener.setLogSingleNotification(true);
        muleContext.getNotificationManager().addListener((NotificationListener)this.listener);
    }

    private Optional<ConfigLine> loadConfigLines(Set<ExtensionModel> extensionModels, InputStream inputStream) {
        ImmutableList xmlNamespaceInfoProviders = ImmutableList.builder().add((Object)this.createStaticNamespaceInfoProviders(extensionModels)).addAll(this.discoverRuntimeXmlNamespaceInfoProvider()).build();
        XmlApplicationParser xmlApplicationParser = new XmlApplicationParser((List)xmlNamespaceInfoProviders);
        Document document = XmlConfigurationDocumentLoader.noValidationDocumentLoader().loadDocument("config", inputStream);
        return xmlApplicationParser.parse(document.getDocumentElement());
    }

    private XmlNamespaceInfoProvider createStaticNamespaceInfoProviders(Set<ExtensionModel> extensionModels) {
        List extensionNamespaces = (List)extensionModels.stream().map(ext -> new StaticXmlNamespaceInfo(ext.getXmlDslModel().getNamespace(), ext.getXmlDslModel().getPrefix())).collect(Collectors.toImmutableList());
        return new StaticXmlNamespaceInfoProvider((Collection)extensionNamespaces);
    }

    private List<XmlNamespaceInfoProvider> discoverRuntimeXmlNamespaceInfoProvider() {
        ImmutableList.Builder namespaceInfoProvidersBuilder = ImmutableList.builder();
        namespaceInfoProvidersBuilder.addAll((Iterable)new SpiServiceRegistry().lookupProviders(XmlNamespaceInfoProvider.class, muleContext.getClass().getClassLoader()));
        return namespaceInfoProvidersBuilder.build();
    }

    @Test
    public void validateComponentLocationCreatedFromExtensionModelsWithoutUsingParsers() throws Exception {
        Set extensionModels = muleContext.getExtensionManager().getExtensions();
        ArtifactConfig.Builder artifactConfigBuilder = new ArtifactConfig.Builder();
        artifactConfigBuilder.addConfigFile(new ConfigFile(CONFIG_FILE_NAME.get(), Collections.singletonList(this.loadConfigLines(extensionModels, this.getClass().getClassLoader().getResourceAsStream(CONFIG_FILE_NAME.get())).orElseThrow(() -> new IllegalArgumentException(String.format("Failed to parse %s.", CONFIG_FILE_NAME.get()))))));
        ApplicationModel toolingApplicationModel = new ApplicationModel(artifactConfigBuilder.build(), null, extensionModels, Collections.emptyMap(), Optional.empty(), Optional.empty(), false, uri -> {
            throw new UnsupportedOperationException();
        });
        ArrayList componentLocations = new ArrayList();
        toolingApplicationModel.executeOnEveryComponentTree(componentModel -> {
            String componentIdentifierName = componentModel.getIdentifier().getName();
            if (componentIdentifierName.equals("notification") || componentIdentifierName.equals("notifications")) {
                return;
            }
            DefaultComponentLocation componentLocation = componentModel.getComponentLocation();
            if (componentLocation != null) {
                componentLocations.add(componentLocation.getLocation());
            }
        });
        Assert.assertEquals((Object)ImmutableList.builder().add((Object)Location.builder().globalName(FLOW_WITH_SINGLE_MP_NAME).build().toString()).add((Object)Location.builder().globalName(FLOW_WITH_SINGLE_MP_NAME).addProcessorsPart().addIndexPart(0).build().toString()).add((Object)Location.builder().globalName(FLOW_WITH_SET_PAYLOAD_HARDCODED_NAME).build().toString()).add((Object)Location.builder().globalName(FLOW_WITH_SET_PAYLOAD_HARDCODED_NAME).addProcessorsPart().addIndexPart(0).build().toString()).add((Object)Location.builder().globalName(FLOW_WITH_SET_PAYLOAD_HARDCODED_TWICE_NAME).build().toString()).add((Object)Location.builder().globalName(FLOW_WITH_SET_PAYLOAD_HARDCODED_TWICE_NAME).addProcessorsPart().addIndexPart(0).build().toString()).add((Object)Location.builder().globalName(FLOW_WITH_SET_PAYLOAD_HARDCODED_TWICE_NAME).addProcessorsPart().addIndexPart(1).build().toString()).add((Object)Location.builder().globalName(FLOW_WITH_SET_PAYLOAD_PARAM_VALUE_NAME).build().toString()).add((Object)Location.builder().globalName(FLOW_WITH_SET_PAYLOAD_PARAM_VALUE_NAME).addProcessorsPart().addIndexPart(0).build().toString()).add((Object)Location.builder().globalName(FLOW_WITH_SET_PAYLOAD_TWO_TIMES_NAME).build().toString()).add((Object)Location.builder().globalName(FLOW_WITH_SET_PAYLOAD_TWO_TIMES_NAME).addProcessorsPart().addIndexPart(0).build().toString()).add((Object)Location.builder().globalName(FLOW_WITH_SET_PAYLOAD_TWO_TIMES_TWICE_NAME).build().toString()).add((Object)Location.builder().globalName(FLOW_WITH_SET_PAYLOAD_TWO_TIMES_TWICE_NAME).addProcessorsPart().addIndexPart(0).build().toString()).add((Object)Location.builder().globalName(FLOW_WITH_SET_PAYLOAD_TWO_TIMES_TWICE_NAME).addProcessorsPart().addIndexPart(1).build().toString()).add((Object)Location.builder().globalName(FLOW_WITH_PROXY_SET_PAYLOAD_HARDCODED_NAME).build().toString()).add((Object)Location.builder().globalName(FLOW_WITH_PROXY_SET_PAYLOAD_HARDCODED_NAME).addProcessorsPart().addIndexPart(0).build().toString()).add((Object)Location.builder().globalName(FLOW_WITH_PROXY_SET_PAYLOAD_HARDCODED_AND_LOGGER_NAME).build().toString()).add((Object)Location.builder().globalName(FLOW_WITH_PROXY_SET_PAYLOAD_HARDCODED_AND_LOGGER_NAME).addProcessorsPart().addIndexPart(0).build().toString()).add((Object)Location.builder().globalName(FLOW_WITH_PROXY_AND_SIMPLE_MODULE_AND_LOGGER_NAME).build().toString()).add((Object)Location.builder().globalName(FLOW_WITH_PROXY_AND_SIMPLE_MODULE_AND_LOGGER_NAME).addProcessorsPart().addIndexPart(0).build().toString()).add((Object)Location.builder().globalName(FLOW_WITH_PROXY_AND_SIMPLE_MODULE_AND_LOGGER_NAME).addProcessorsPart().addIndexPart(1).build().toString()).add((Object)Location.builder().globalName(FLOW_WITH_PROXY_AND_SIMPLE_MODULE_AND_LOGGER_NAME).addProcessorsPart().addIndexPart(2).build().toString()).add((Object)Location.builder().globalName(FLOW_WITH_PROXY_AND_SIMPLE_MODULE_AND_LOGGER_REVERSE_NAME).build().toString()).add((Object)Location.builder().globalName(FLOW_WITH_PROXY_AND_SIMPLE_MODULE_AND_LOGGER_REVERSE_NAME).addProcessorsPart().addIndexPart(0).build().toString()).add((Object)Location.builder().globalName(FLOW_WITH_PROXY_AND_SIMPLE_MODULE_AND_LOGGER_REVERSE_NAME).addProcessorsPart().addIndexPart(1).build().toString()).add((Object)Location.builder().globalName(FLOW_WITH_PROXY_AND_SIMPLE_MODULE_AND_LOGGER_REVERSE_NAME).addProcessorsPart().addIndexPart(2).build().toString()).build(), componentLocations);
    }

    @Test
    public void flowWithSingleMp() throws Exception {
        this.flowRunner(FLOW_WITH_SINGLE_MP_NAME).run();
        this.assertNextProcessorLocationIs(FLOW_WITH_SINGLE_MP_LOCATION.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", LOGGER, CONFIG_FILE_NAME, Optional.of(16)));
        this.assertNoNextProcessorNotification();
    }

    @Test
    public void flowWithSetPayloadHardcoded() throws Exception {
        this.flowRunner(FLOW_WITH_SET_PAYLOAD_HARDCODED_NAME).run();
        this.assertNextProcessorLocationIs(FLOW_WITH_SET_PAYLOAD_HARDCODED.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", MODULE_SET_PAYLOAD_HARDCODED_VALUE, CONFIG_FILE_NAME, Optional.of(20)));
        this.assertNextProcessorLocationIs(OPERATION_SET_PAYLOAD_HARDCODED_VALUE_FIRST_MP.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", SET_PAYLOAD, MODULE_SIMPLE_FILE_NAME, Optional.of(13)));
        this.assertNoNextProcessorNotification();
    }

    @Test
    public void flowWithSetPayloadHardcodedTwice() throws Exception {
        this.flowRunner(FLOW_WITH_SET_PAYLOAD_HARDCODED_TWICE_NAME).run();
        this.assertNextProcessorLocationIs(FLOW_WITH_SET_PAYLOAD_HARDCODED_TWICE.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", MODULE_SET_PAYLOAD_HARDCODED_VALUE, CONFIG_FILE_NAME, Optional.of(24)));
        this.assertNextProcessorLocationIs(OPERATION_SET_PAYLOAD_HARDCODED_VALUE_FIRST_MP.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", SET_PAYLOAD, MODULE_SIMPLE_FILE_NAME, Optional.of(13)));
        this.assertNextProcessorLocationIs(FLOW_WITH_SET_PAYLOAD_HARDCODED_TWICE.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("1", MODULE_SET_PAYLOAD_HARDCODED_VALUE, CONFIG_FILE_NAME, Optional.of(25)));
        this.assertNextProcessorLocationIs(OPERATION_SET_PAYLOAD_HARDCODED_VALUE_FIRST_MP.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", SET_PAYLOAD, MODULE_SIMPLE_FILE_NAME, Optional.of(13)));
        this.assertNoNextProcessorNotification();
    }

    @Test
    public void flowWithSetPayloadParamValue() throws Exception {
        this.flowRunner(FLOW_WITH_SET_PAYLOAD_PARAM_VALUE_NAME).run();
        this.assertNextProcessorLocationIs(FLOW_WITH_SET_PAYLOAD_PARAM_VALUE.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", MODULE_SET_PAYLOAD_PARAM_VALUE, CONFIG_FILE_NAME, Optional.of(29)));
        this.assertNextProcessorLocationIs(OPERATION_SET_PAYLOAD_PARAM_VALUE_FIRST_MP.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", SET_PAYLOAD, MODULE_SIMPLE_FILE_NAME, Optional.of(23)));
        this.assertNoNextProcessorNotification();
    }

    @Test
    public void flowWithSetPayloadTwoTimes() throws Exception {
        this.flowRunner(FLOW_WITH_SET_PAYLOAD_TWO_TIMES_NAME).run();
        this.assertNextProcessorLocationIs(FLOW_WITH_SET_PAYLOAD_TWO_TIMES.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", MODULE_SET_PAYLOAD_TWO_TIMES, CONFIG_FILE_NAME, Optional.of(33)));
        this.assertNextProcessorLocationIs(OPERATION_SET_PAYLOAD_TWO_TIMES_FIRST_MP.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", SET_PAYLOAD, MODULE_SIMPLE_FILE_NAME, Optional.of(30)));
        this.assertNextProcessorLocationIs(OPERATION_SET_PAYLOAD_TWO_TIMES_SECOND_MP.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("1", SET_PAYLOAD, MODULE_SIMPLE_FILE_NAME, Optional.of(31)));
        this.assertNoNextProcessorNotification();
    }

    @Test
    public void flowWithSetPayloadTwoTimesTwice() throws Exception {
        this.flowRunner(FLOW_WITH_SET_PAYLOAD_TWO_TIMES_TWICE_NAME).run();
        this.assertNextProcessorLocationIs(FLOW_WITH_SET_PAYLOAD_TWO_TIMES_TWICE.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", MODULE_SET_PAYLOAD_TWO_TIMES, CONFIG_FILE_NAME, Optional.of(37)));
        this.assertNextProcessorLocationIs(OPERATION_SET_PAYLOAD_TWO_TIMES_FIRST_MP.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", SET_PAYLOAD, MODULE_SIMPLE_FILE_NAME, Optional.of(30)));
        this.assertNextProcessorLocationIs(OPERATION_SET_PAYLOAD_TWO_TIMES_SECOND_MP.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("1", SET_PAYLOAD, MODULE_SIMPLE_FILE_NAME, Optional.of(31)));
        this.assertNextProcessorLocationIs(FLOW_WITH_SET_PAYLOAD_TWO_TIMES_TWICE.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("1", MODULE_SET_PAYLOAD_TWO_TIMES, CONFIG_FILE_NAME, Optional.of(38)));
        this.assertNextProcessorLocationIs(OPERATION_SET_PAYLOAD_TWO_TIMES_FIRST_MP.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", SET_PAYLOAD, MODULE_SIMPLE_FILE_NAME, Optional.of(30)));
        this.assertNextProcessorLocationIs(OPERATION_SET_PAYLOAD_TWO_TIMES_SECOND_MP.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("1", SET_PAYLOAD, MODULE_SIMPLE_FILE_NAME, Optional.of(31)));
        this.assertNoNextProcessorNotification();
    }

    @Test
    public void flowWithProxySetPayloadHardcoded() throws Exception {
        this.flowRunner(FLOW_WITH_PROXY_SET_PAYLOAD_HARDCODED_NAME).run();
        this.assertNextProcessorLocationIs(FLOW_WITH_PROXY_SET_PAYLOAD_HARDCODED.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", MODULE_PROXY_SET_PAYLOAD, CONFIG_FILE_NAME, Optional.of(42)));
        this.assertNextProcessorLocationIs(OPERATION_PROXY_SET_PAYLOAD_FIRST_MP.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", MODULE_SET_PAYLOAD_HARDCODED_VALUE, MODULE_SIMPLE_PROXY_FILE_NAME, Optional.of(13)));
        this.assertNextProcessorLocationIs(OPERATION_SET_PAYLOAD_HARDCODED_VALUE_FIRST_MP.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", SET_PAYLOAD, MODULE_SIMPLE_FILE_NAME, Optional.of(13)));
        this.assertNoNextProcessorNotification();
    }

    @Test
    public void flowWithProxySetPayloadHardcodedAndLogger() throws Exception {
        this.flowRunner(FLOW_WITH_PROXY_SET_PAYLOAD_HARDCODED_AND_LOGGER_NAME).run();
        this.assertNextProcessorLocationIs(FLOW_WITH_PROXY_SET_PAYLOAD_HARDCODED_AND_LOGGER.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", MODULE_PROXY_SET_PAYLOAD_AND_LOGGER, CONFIG_FILE_NAME, Optional.of(46)));
        this.assertNextProcessorLocationIs(OPERATION_PROXY_SET_PAYLOAD_AND_LOGGER_FIRST_MP.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", MODULE_SET_PAYLOAD_HARDCODED_VALUE, MODULE_SIMPLE_PROXY_FILE_NAME, Optional.of(20)));
        this.assertNextProcessorLocationIs(OPERATION_SET_PAYLOAD_HARDCODED_VALUE_FIRST_MP.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", SET_PAYLOAD, MODULE_SIMPLE_FILE_NAME, Optional.of(13)));
        this.assertNextProcessorLocationIs(OPERATION_PROXY_SET_PAYLOAD_AND_LOGGER_SECOND_MP.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("1", LOGGER, MODULE_SIMPLE_PROXY_FILE_NAME, Optional.of(21)));
        this.assertNoNextProcessorNotification();
    }

    @Test
    public void flowWithProxyAndSimpleModuleAndLogger() throws Exception {
        this.flowRunner(FLOW_WITH_PROXY_AND_SIMPLE_MODULE_AND_LOGGER_NAME).run();
        this.assertNextProcessorLocationIs(FLOW_WITH_PROXY_AND_SIMPLE_MODULE_AND_LOGGER.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", MODULE_PROXY_SET_PAYLOAD_AND_LOGGER, CONFIG_FILE_NAME, Optional.of(50)));
        this.assertNextProcessorLocationIs(OPERATION_PROXY_SET_PAYLOAD_AND_LOGGER_FIRST_MP.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", MODULE_SET_PAYLOAD_HARDCODED_VALUE, MODULE_SIMPLE_PROXY_FILE_NAME, Optional.of(20)));
        this.assertNextProcessorLocationIs(OPERATION_SET_PAYLOAD_HARDCODED_VALUE_FIRST_MP.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", SET_PAYLOAD, MODULE_SIMPLE_FILE_NAME, Optional.of(13)));
        this.assertNextProcessorLocationIs(OPERATION_PROXY_SET_PAYLOAD_AND_LOGGER_SECOND_MP.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("1", LOGGER, MODULE_SIMPLE_PROXY_FILE_NAME, Optional.of(21)));
        this.assertNextProcessorLocationIs(FLOW_WITH_PROXY_AND_SIMPLE_MODULE_AND_LOGGER.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("1", MODULE_SET_PAYLOAD_HARDCODED_VALUE, CONFIG_FILE_NAME, Optional.of(51)));
        this.assertNextProcessorLocationIs(OPERATION_SET_PAYLOAD_HARDCODED_VALUE_FIRST_MP.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", SET_PAYLOAD, MODULE_SIMPLE_FILE_NAME, Optional.of(13)));
        this.assertNextProcessorLocationIs(FLOW_WITH_PROXY_AND_SIMPLE_MODULE_AND_LOGGER.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("2", LOGGER, CONFIG_FILE_NAME, Optional.of(52)));
        this.assertNoNextProcessorNotification();
    }

    @Test
    public void flowWithProxyAndSimpleModuleAndLoggerReverse() throws Exception {
        this.flowRunner(FLOW_WITH_PROXY_AND_SIMPLE_MODULE_AND_LOGGER_REVERSE_NAME).run();
        this.assertNextProcessorLocationIs(FLOW_WITH_PROXY_AND_SIMPLE_MODULE_AND_LOGGER_REVERSE.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", LOGGER, CONFIG_FILE_NAME, Optional.of(56)));
        this.assertNextProcessorLocationIs(FLOW_WITH_PROXY_AND_SIMPLE_MODULE_AND_LOGGER_REVERSE.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("1", MODULE_SET_PAYLOAD_HARDCODED_VALUE, CONFIG_FILE_NAME, Optional.of(57)));
        this.assertNextProcessorLocationIs(OPERATION_SET_PAYLOAD_HARDCODED_VALUE_FIRST_MP.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", SET_PAYLOAD, MODULE_SIMPLE_FILE_NAME, Optional.of(13)));
        this.assertNextProcessorLocationIs(FLOW_WITH_PROXY_AND_SIMPLE_MODULE_AND_LOGGER_REVERSE.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("2", MODULE_PROXY_SET_PAYLOAD_AND_LOGGER, CONFIG_FILE_NAME, Optional.of(58)));
        this.assertNextProcessorLocationIs(OPERATION_PROXY_SET_PAYLOAD_AND_LOGGER_FIRST_MP.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", MODULE_SET_PAYLOAD_HARDCODED_VALUE, MODULE_SIMPLE_PROXY_FILE_NAME, Optional.of(20)));
        this.assertNextProcessorLocationIs(OPERATION_SET_PAYLOAD_HARDCODED_VALUE_FIRST_MP.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("0", SET_PAYLOAD, MODULE_SIMPLE_FILE_NAME, Optional.of(13)));
        this.assertNextProcessorLocationIs(OPERATION_PROXY_SET_PAYLOAD_AND_LOGGER_SECOND_MP.appendLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart("1", LOGGER, MODULE_SIMPLE_PROXY_FILE_NAME, Optional.of(21)));
        this.assertNoNextProcessorNotification();
    }

    private void assertNoNextProcessorNotification() {
        Iterator iterator = this.listener.getNotifications().iterator();
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Is.is((Object)false));
    }

    private void assertNextProcessorLocationIs(DefaultComponentLocation componentLocation) {
        Assert.assertThat((Object)this.listener.getNotifications().isEmpty(), (Matcher)Is.is((Object)false));
        MessageProcessorNotification processorNotification = (MessageProcessorNotification)this.listener.getNotifications().get(0);
        this.listener.getNotifications().remove(0);
        Assert.assertThat((Object)processorNotification.getComponent().getLocation().getLocation(), (Matcher)Is.is((Object)componentLocation.getLocation()));
        Assert.assertThat((Object)processorNotification.getComponent().getLocation(), (Matcher)Is.is((Object)componentLocation));
    }

    private String[] getModulePaths() {
        return new String[]{"org/mule/test/integration/notifications/modules/module-simple.xml", "org/mule/test/integration/notifications/modules/module-simple-proxy.xml"};
    }

    protected void addBuilders(List<ConfigurationBuilder> builders) {
        super.addBuilders(builders);
        builders.add(0, (ConfigurationBuilder)new AbstractConfigurationBuilder(){

            protected void doConfigure(MuleContext muleContext) throws Exception {
                ExtensionManager extensionManager;
                if (muleContext.getExtensionManager() == null) {
                    extensionManager = MuleExtensionUtils.createDefaultExtensionManager();
                    muleContext.setExtensionManager(extensionManager);
                }
                extensionManager = muleContext.getExtensionManager();
                LifecycleUtils.initialiseIfNeeded((Object)extensionManager, (MuleContext)muleContext);
                this.registerXmlExtensions(extensionManager);
            }

            private void registerXmlExtensions(ExtensionManager extensionManager) {
                HashSet<ExtensionModel> extensions = new HashSet<ExtensionModel>();
                for (String modulePath : ModuleComponentPathTestCase.this.getModulePaths()) {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("resource-xml", modulePath);
                    DslResolvingContext dslResolvingContext = DslResolvingContext.getDefault(extensions);
                    ExtensionModel extensionModel = new XmlExtensionModelLoader().loadExtensionModel(((Object)((Object)this)).getClass().getClassLoader(), dslResolvingContext, params);
                    extensions.add(extensionModel);
                }
                for (ExtensionModel extension : extensions) {
                    extensionManager.registerExtension(extension);
                }
            }
        });
    }
}

