/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.core.transformers.simple;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.transformer.AbstractTransformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.test.AbstractIntegrationTestCase;

public class RegistryTransformerLifecycleTestCase
extends AbstractIntegrationTestCase {
    protected String getConfigFile() {
        return "simple-transformer-config.xml";
    }

    @Test
    public void testLifecycleInSpring() throws Exception {
        TransformerLifecycleTracker transformer = (TransformerLifecycleTracker)((Object)this.registry.lookupByName("lifecycle").get());
        Assert.assertNotNull((Object)((Object)transformer));
        muleContext.dispose();
        this.assertInitialise(transformer);
    }

    @Test
    public void testLifecycleInFlowInSpring() throws Exception {
        Flow flow = (Flow)this.registry.lookupByName("flow").get();
        TransformerLifecycleTracker transformer = (TransformerLifecycleTracker)((Object)flow.getProcessors().get(0));
        Assert.assertNotNull((Object)((Object)transformer));
        muleContext.dispose();
        this.assertLifecycle(transformer);
    }

    private void assertLifecycle(TransformerLifecycleTracker transformer) {
        Assert.assertEquals((Object)"[setProperty, initialise, dispose]", (Object)transformer.getTracker().toString());
    }

    private void assertInitialise(TransformerLifecycleTracker transformer) {
        Assert.assertEquals((Object)"[setProperty, initialise]", (Object)transformer.getTracker().toString());
    }

    public static class TransformerLifecycleTracker
    extends AbstractTransformer
    implements Disposable {
        private final List<String> tracker = new ArrayList<String>();
        private String property;

        protected Object doTransform(Object src, Charset encoding) throws TransformerException {
            this.tracker.add("doTransform");
            return null;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.tracker.add("setProperty");
        }

        public List<String> getTracker() {
            return this.tracker;
        }

        public void initialise() throws InitialisationException {
            this.tracker.add("initialise");
        }

        public void dispose() {
            this.tracker.add("dispose");
        }
    }
}

