/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.component.TestConnectorQueueHandler;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.config.custom.ServiceConfigurator;
import org.mule.runtime.api.deployment.management.ComponentInitialStateManager;
import org.mule.runtime.api.source.SchedulerMessageSource;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.runtime.config.api.SpringXmlConfigurationBuilderFactory;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Scheduler Service")
@Story(value="Source Management")
@RunnerDelegateTo(value=Parameterized.class)
public class SchedulerInitialStateTestCase
extends AbstractIntegrationTestCase {
    private List<Component> recordedOnStartMessageSources = new ArrayList<Component>();
    @Inject
    private LazyComponentInitializer lazyComponentInitializer;
    @Parameterized.Parameter
    public boolean lazyInitEnabled;

    @Parameterized.Parameters(name="{index}: Running tests for {0} (validating XML [{2}]) ")
    public static Collection<Object[]> data() {
        return Arrays.asList({true}, {false});
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/scheduler-initial-state-management-config.xml";
    }

    protected ConfigurationBuilder getBuilder() throws Exception {
        ConfigurationBuilder configurationBuilder = SpringXmlConfigurationBuilderFactory.createConfigurationBuilder((String)this.getConfigFile(), (boolean)this.lazyInitEnabled);
        this.configureSpringXmlConfigurationBuilder(configurationBuilder);
        return configurationBuilder;
    }

    protected void addBuilders(List<ConfigurationBuilder> builders) {
        super.addBuilders(builders);
        builders.add(new ConfigurationBuilder(){

            public void configure(MuleContext muleContext) {
                muleContext.getCustomizationService().overrideDefaultServiceImpl("_muleComponentInitialStateManager", (Object)this.createCustomStateManager());
            }

            private ComponentInitialStateManager createCustomStateManager() {
                return new ComponentInitialStateManager(){

                    public boolean mustStartMessageSource(Component component) {
                        SchedulerInitialStateTestCase.this.recordedOnStartMessageSources.add(component);
                        return component.getLocation().getRootContainerName().equals("runningSchedulerOnStartup");
                    }
                };
            }

            public void addServiceConfigurator(ServiceConfigurator serviceConfigurator) {
            }
        });
    }

    @Description(value="ComponentInitialStateManager is called during startup for all message sources")
    @Test
    public void startMessageSourceRequestedOnStartup() {
        this.lazyComponentInitializer.initializeComponents(componentLocation -> true);
        Assert.assertThat(this.recordedOnStartMessageSources, (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat(this.recordedOnStartMessageSources.stream().map(component -> component.getLocation().getLocation()).collect(Collectors.toList()), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"runningSchedulerOnStartup/source", "notRunningSchedulerOnStartup/source"}));
    }

    @Description(value="ComponentInitialStateManager does not allow to start scheduler message sources")
    @Test
    public void verifyMessageSourcesAreNotStarted() {
        this.lazyComponentInitializer.initializeComponents(componentLocation -> true);
        SchedulerMessageSource schedulerMessageSource = (SchedulerMessageSource)muleContext.getConfigurationComponentLocator().find(Location.builder().globalName("runningSchedulerOnStartup").addSourcePart().build()).get();
        Assert.assertThat((Object)schedulerMessageSource.isStarted(), (Matcher)CoreMatchers.is((Object)true));
        schedulerMessageSource = (SchedulerMessageSource)muleContext.getConfigurationComponentLocator().find(Location.builder().globalName("notRunningSchedulerOnStartup").addSourcePart().build()).get();
        Assert.assertThat((Object)schedulerMessageSource.isStarted(), (Matcher)CoreMatchers.is((Object)false));
        final TestConnectorQueueHandler queueHandler = new TestConnectorQueueHandler(this.registry);
        new PollingProber(10000L, 100L).check(new Probe(){

            public boolean isSatisfied() {
                CoreEvent response = queueHandler.read("runningSchedulerOnStartupQueue", 100L);
                return response != null;
            }

            public String describeFailure() {
                return "Message expected by in flow runningSchedulerOnStartup";
            }
        });
        CoreEvent response = queueHandler.read("notRunningSchedulerOnStartupQueue", 100L);
        Assert.assertThat((Object)response, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

