/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import org.junit.AfterClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;

public class LogCheckTestCase
extends AbstractIntegrationTestCase {
    @ClassRule
    public static SystemProperty verboseExceptions = new SystemProperty("mule.verbose.exceptions", Boolean.toString(false));
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public SystemProperty logFlowStack = new SystemProperty("mule.flowTrace", Boolean.toString(false));

    @AfterClass
    public static void afterClass() {
        MuleException.refreshVerboseExceptions();
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/log-check-config.xml";
    }

    @Test
    public void runVerboseCheckEqualsVerbose() throws Exception {
        this.runSuccesses(true, "checkEqualsVerbose");
    }

    @Test
    public void runVerboseCheckStacktrace() throws Exception {
        this.runSuccesses(true, "checkStacktrace");
    }

    @Test
    public void runVerboseCheckSummary() throws Exception {
        this.runSuccesses(true, "checkSummary");
    }

    @Test
    public void runVerboseAllChecksTogetherNoneFailing() throws Exception {
        this.runSuccesses(true, "allChecksTogetherNoneFailing");
    }

    @Test
    public void checkNonVerboseEquals() throws Exception {
        this.runSuccesses(false, "checkSummary");
    }

    @Test
    public void checkNonVerboseSummary() throws Exception {
        this.runSuccesses(false, "checkSummary");
    }

    @Test
    public void unknownSummaryShowsFilteredStack() throws Exception {
        this.runSuccesses(false, "unknownFiltered");
    }

    @Test
    public void unknownVerboseShowsFullStack() throws Exception {
        this.runSuccesses(true, "unknownFull");
    }

    @Test
    public void exceptionInTryIsLogged() throws Exception {
        this.runSuccesses(false, "exceptionInTry");
    }

    @Test
    public void sameExceptionIsNotLoggedMoreThanOnceInTryScope() throws Exception {
        this.runSuccesses(false, "sameExceptionInTry");
    }

    @Test
    public void differentExceptionsAreLoggedInTryScope() throws Exception {
        this.runSuccesses(false, "differentExceptionsInTry");
    }

    @Test
    public void noLoggingFailsIfFlagIsNotSet() throws Exception {
        this.expectedException.expect(AssertionError.class);
        this.expectedException.expectMessage("Could not check exception because it was never logged");
        this.runSuccesses(false, "noLogFlowFlagNotSet");
    }

    @Test
    public void noLoggingSucceedsIfFlagIsSet() throws Exception {
        this.runSuccesses(false, "noLogFlowFlagSet");
    }

    @Test
    public void assertFailsIfNoException() throws Exception {
        this.expectedException.expect(AssertionError.class);
        this.expectedException.expectMessage("Handler could not check any exception log because no exception was raise");
        this.runSuccesses(false, "noExceptionFlow");
    }

    private void runSuccesses(boolean verboseExceptions, String flowName) throws Exception {
        System.setProperty("mule.verbose.exceptions", Boolean.toString(verboseExceptions));
        MuleException.refreshVerboseExceptions();
        this.flowRunner(flowName).run();
    }

    public static class CustomException
    extends MuleException {
        private static final String MESSAGE = "Error";

        public String getDetailedMessage() {
            return MESSAGE;
        }

        public String getVerboseMessage() {
            return MESSAGE;
        }

        public String getSummaryMessage() {
            return MESSAGE;
        }
    }
}

