/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.functional.api.component.TestConnectorQueueHandler;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.ThrowableCauseMatcher;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleFatalException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.retry.policy.RetryPolicyExhaustedException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;

@Ignore(value="MULE-19149")
@Feature(value="Error Handling")
@Story(value="On Error Continue")
public class OnErrorContinueTestCase
extends AbstractIntegrationTestCase {
    public static final int TIMEOUT = 5000;
    public static final String ERROR_PROCESSING_NEWS = "error processing news";
    public static final String JSON_RESPONSE = "{\"errorMessage\":\"error processing news\",\"userId\":15,\"title\":\"News title\"}";
    public static final String JSON_REQUEST = "{\"userId\":\"15\"}";
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");
    @Rule
    public DynamicPort dynamicPort3 = new DynamicPort("port3");
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder((HttpService)this.getService(HttpService.class)).tlsContextFactory(() -> {
        try {
            return TlsContextFactory.builder().trustStorePath("ssltest-cacerts.jks").trustStorePassword("changeit").build();
        }
        catch (CreateException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }).build();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    public static final String MESSAGE = "some message";
    public static final String MESSAGE_EXPECTED = "some message consumed successfully";

    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/on-error-continue-use-case-flow.xml";
    }

    @Test
    public void testHttpJsonErrorResponse() throws Exception {
        this.testJsonErrorResponse(this.getUrl(HttpConstants.Protocol.HTTP, this.dynamicPort1, "service"));
    }

    @Test
    public void testHttpsJsonErrorResponse() throws Exception {
        this.testJsonErrorResponse(this.getUrl(HttpConstants.Protocol.HTTPS, this.dynamicPort3, "httpsservice"));
    }

    @Test
    public void testJsonErrorResponse() throws Exception {
        this.assertResponse(((FlowRunner)this.flowRunner("continueProcessingActualMessage").withPayload((Object)JSON_REQUEST)).run().getMessage());
    }

    private void assertResponse(Message response) throws Exception {
        Assert.assertThat((Object)response, (Matcher)IsNull.notNullValue());
        JsonNode actualJsonNode = new ObjectMapper().readTree(this.getPayloadAsString(response));
        JsonNode expectedJsonNode = new ObjectMapper().readTree(JSON_RESPONSE);
        Assert.assertThat((Object)actualJsonNode, (Matcher)Is.is((Object)expectedJsonNode));
    }

    private void testJsonErrorResponse(String endpointUri) throws Exception {
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri(endpointUri).method(HttpConstants.Method.POST).entity((HttpEntity)new ByteArrayHttpEntity(JSON_REQUEST.getBytes()))).build();
        HttpEntity response = this.httpClient.send(request, 5000, false, null).getEntity();
        this.assertResponse(response);
    }

    private void assertResponse(HttpEntity responseEntity) throws Exception {
        Assert.assertThat((Object)responseEntity, (Matcher)IsNull.notNullValue());
        JsonNode actualJsonNode = new ObjectMapper().readTree(IOUtils.toString((InputStream)responseEntity.getContent()));
        JsonNode expectedJsonNode = new ObjectMapper().readTree(JSON_RESPONSE);
        Assert.assertThat((Object)actualJsonNode, (Matcher)Is.is((Object)expectedJsonNode));
    }

    @Test
    public void testCatchWithComponent() throws Exception {
        Message result = ((FlowRunner)this.flowRunner("catchWithComponent").withPayload((Object)MESSAGE)).run().getMessage();
        Assert.assertThat((Object)result, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)this.getPayloadAsString(result), (Matcher)Is.is((Object)"some message Caught"));
    }

    @Test
    public void testFullyDefinedCatchExceptionStrategyWithComponent() throws Exception {
        Message result = ((FlowRunner)this.flowRunner("fullyDefinedCatchExceptionStrategyWithComponent").withPayload((Object)MESSAGE)).run().getMessage();
        Assert.assertThat((Object)result, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)this.getPayloadAsString(result), (Matcher)Is.is((Object)"some message apt1 apt2 groovified"));
    }

    @Test
    public void onErrorTypeMatch() throws Exception {
        Message result = ((FlowRunner)this.flowRunner("onErrorTypeMatch").withPayload((Object)MESSAGE)).run().getMessage();
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)this.getPayloadAsString(result), (Matcher)Matchers.is((Object)"some message apt1 apt2"));
    }

    @Test
    public void onErrorTypeMatchAny() throws Exception {
        Message result = ((FlowRunner)this.flowRunner("onErrorTypeMatchAny").withPayload((Object)MESSAGE)).run().getMessage();
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)this.getPayloadAsString(result), (Matcher)Matchers.is((Object)"some message apt1 apt2"));
    }

    @Test
    public void onErrorTypeMatchSeveral() throws Exception {
        Message result = ((FlowRunner)this.flowRunner("onErrorTypeMatchSeveral").withPayload((Object)true)).run().getMessage();
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)this.getPayloadAsString(result), (Matcher)Matchers.is((Object)"true apt1 apt2"));
        result = ((FlowRunner)this.flowRunner("onErrorTypeMatchSeveral").withPayload((Object)false)).run().getMessage();
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)this.getPayloadAsString(result), (Matcher)Matchers.is((Object)"false apt1 apt2"));
    }

    @Test
    public void onErrorContinueFailure() throws Exception {
        this.expectedException.expectCause(Matchers.instanceOf(MuleFatalException.class));
        this.expectedException.expectCause(ThrowableCauseMatcher.hasCause((Matcher)Matchers.instanceOf(NoClassDefFoundError.class)));
        this.flowRunner("failingHandler").run();
    }

    @Test
    public void doesNotHandleSourceErrors() throws Exception {
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri(this.getUrl(HttpConstants.Protocol.HTTP, this.dynamicPort1, "sourceError")).method(HttpConstants.Method.POST).entity((HttpEntity)new ByteArrayHttpEntity("Test Message".getBytes()))).build();
        HttpResponse response = this.httpClient.send(request, 5000, false, null);
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()));
        TestConnectorQueueHandler queueHandler = new TestConnectorQueueHandler(this.registry);
        Assert.assertThat((Object)queueHandler.read("out", 5000L), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    private String getUrl(HttpConstants.Protocol protocol, DynamicPort port, String path) {
        return String.format("%s://localhost:%s/%s", protocol.getScheme(), port.getNumber(), path);
    }

    @WebService
    public static class Echo {
        @WebResult(name="text")
        public String echo(@WebParam(name="text") String string) {
            throw new RuntimeException();
        }
    }

    public static class NewsResponse {
        private int userId;
        private String title;
        private String errorMessage;

        public int getUserId() {
            return this.userId;
        }

        public void setUserId(int userId) {
            this.userId = userId;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }

    public static class NewsRequest {
        private int userId;

        public int getUserId() {
            return this.userId;
        }

        public void setUserId(int userId) {
            this.userId = userId;
        }
    }

    public static class NewsErrorProcessor
    extends AbstractComponent
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            NewsResponse newsResponse = (NewsResponse)event.getMessage().getPayload().getValue();
            newsResponse.setErrorMessage(OnErrorContinueTestCase.ERROR_PROCESSING_NEWS);
            StringWriter writer = new StringWriter();
            try {
                new ObjectMapper().writeValue((Writer)writer, (Object)newsResponse);
            }
            catch (IOException e) {
                throw new DefaultMuleException((Throwable)e);
            }
            return CoreEvent.builder((CoreEvent)event).message(Message.builder((Message)event.getMessage()).value((Object)writer.toString()).build()).build();
        }
    }

    public static class LoadNewsProcessor
    extends AbstractComponent
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            NewsRequest newsRequest;
            block5: {
                try {
                    Object payload = event.getMessage().getPayload().getValue();
                    if (payload instanceof CursorStreamProvider) {
                        newsRequest = this.handleInputStream((InputStream)((CursorStreamProvider)payload).openCursor());
                        break block5;
                    }
                    if (payload instanceof InputStream) {
                        newsRequest = this.handleInputStream((InputStream)payload);
                        break block5;
                    }
                    if (payload instanceof String) {
                        newsRequest = (NewsRequest)new ObjectMapper().readValue((String)payload, NewsRequest.class);
                        break block5;
                    }
                    throw new RuntimeException("Cannot create an object from a " + payload.getClass().getName());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            NewsResponse newsResponse = new NewsResponse();
            newsResponse.setUserId(newsRequest.getUserId());
            newsResponse.setTitle("News title");
            return CoreEvent.builder((CoreEvent)event).message(Message.builder((Message)event.getMessage()).value((Object)newsResponse).build()).build();
        }

        private NewsRequest handleInputStream(InputStream payload) throws IOException {
            InputStreamReader inputStreamReader = new InputStreamReader(payload, "UTF-8");
            NewsRequest newsRequest = (NewsRequest)new ObjectMapper().readValue((Reader)inputStreamReader, NewsRequest.class);
            return newsRequest;
        }
    }

    public static class ErrorProcessor
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            throw new NoClassDefFoundError("Test error");
        }
    }

    public static class FailingProcessor
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            throw new RetryPolicyExhaustedException(I18nMessageFactory.createStaticMessage((String)"Error."), Mockito.mock(Initialisable.class));
        }
    }
}

