/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.interception;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Interception API")
@Story(value="Component Interception Story")
public class ProcessorInterceptorFactoryFailingInterceptorsTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public ExpectedError expectedError = ExpectedError.none();
    private static RuntimeException THROWN = new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Expected exception in after()"));
    private AtomicBoolean afterCallbackCalledForFailingMP = new AtomicBoolean(false);

    protected String getConfigFile() {
        return "org/mule/test/integration/interception/processor-interceptor-factory.xml";
    }

    @Before
    public void before() {
        this.expectedError.expectErrorType("MULE", "UNKNOWN").expectCause(Matchers.sameInstance((Object)THROWN));
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        objects.put("_FailingAfterInterceptorFactory", new FailingAfterInterceptorFactory());
        objects.put("_muleProcessorInterceptorFactoryOrder", () -> Arrays.asList(FailingAfterInterceptorFactory.class.getName()));
        return objects;
    }

    @Description(value="Logger, flow-ref and splitter components are intercepted in order and the parameters are correctly sent")
    @Test
    public void injection() throws Exception {
        ArrayList payload = new ArrayList();
        ((FlowRunner)this.flowRunner("injectionInterceptionTest").withPayload(payload)).run();
    }

    @Test
    public void operationParameters() throws Exception {
        ((FlowRunner)((FlowRunner)this.flowRunner("killFromPayload").withPayload((Object)"T-1000")).withVariable("goodbye", (Object)"Hasta la vista, baby")).run();
    }

    @Test
    public void resolvedConfigOperationParameters() throws Exception {
        this.flowRunner("die").run();
    }

    @Test
    public void resolvedComplexParametersOperationParameters() throws Exception {
        ((FlowRunner)this.flowRunner("killWithCustomMessage").withVariable("goodbye", (Object)"Hasta la vista, baby")).run();
    }

    @Test
    @Description(value="The errorType set by an operation is preserved if an interceptor is applied")
    public void failingOperationErrorTypePreserved() throws Exception {
        this.flowRunner("callGusFring").run();
    }

    @Description(value="Smart Connector simple operation without parameters")
    @Test
    public void scOperation() throws Exception {
        this.flowRunner("scOperation").run();
    }

    @Description(value="Smart Connector simple operation with parameters")
    @Test
    public void scEchoOperation() throws Exception {
        String variableValue = "echo message for the win";
        ((FlowRunner)this.flowRunner("scEchoOperation").withVariable("variable", (Object)"echo message for the win")).run();
    }

    @Description(value="Smart Connector simple operation with parameters through flow-ref")
    @Test
    public void scEchoOperationFlowRef() throws Exception {
        String variableValue = "echo message for the win";
        ((FlowRunner)this.flowRunner("scEchoOperationFlowRef").withVariable("variable", (Object)"echo message for the win")).run();
    }

    @Description(value="Smart Connector that uses a Smart Connector operation without parameters")
    @Test
    public void scUsingScOperation() throws Exception {
        this.flowRunner("scUsingScOperation").run();
    }

    @Test
    @Description(value="Errors in sub-flows are handled correctly")
    public void failingSubFlow() throws Exception {
        this.flowRunner("flowWithFailingSubFlowRef").run();
    }

    @Test
    @Description(value="Processors in error handlers are intercepted correctly")
    public void errorHandler() throws Exception {
        this.flowRunner("flowFailingWithErrorHandler").run();
    }

    @Test
    @Description(value="Processors in global error handlers are intercepted correctly")
    public void globalErrorHandler() throws Exception {
        this.flowRunner("flowFailing").run();
    }

    @Test
    @Description(value="Processors in global error handlers are intercepted correctly when raise-error is used")
    public void globalErrorHandlerRaise() throws Exception {
        this.expectedError.expectErrorType("MULE", "CONNECTIVITY");
        this.flowRunner("flowRaise").run();
    }

    @Test
    @Description(value="Processors in global error handlers are intercepted correctly for errors in operations")
    public void globalErrorHandlerOperation() throws Exception {
        this.expectedError.expectErrorType("HEISENBERG", "HEALTH");
        this.flowRunner("flowFailingOperation").run();
    }

    @Test
    @Description(value="Processors in global error handlers are intercepted correctly for an unknown status code errors in http request")
    public void globalErrorHandlerUnknownStatusCodeHttpRequest() throws Exception {
        this.flowRunner("flowUnknownStatusCodeHttpRequest").run();
    }

    @Test
    @Description(value="Processors in global error handlers are intercepted correctly for errors in XML SDK operations")
    public void globalErrorHandlerScOperation() throws Exception {
        this.expectedError.expectErrorType("MODULE-USING-CORE", "RAISED");
        this.flowRunner("scFailingOperation").run();
    }

    @Test
    @Description(value="Processors in global error handlers are intercepted correctly when error is in referenced flow")
    public void globalErrorHandlerWithFlowRef() throws Exception {
        this.flowRunner("flowWithFailingFlowRef").run();
    }

    public class FailingAfterInterceptor
    implements ProcessorInterceptor {
        public void after(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
            if (!ProcessorInterceptorFactoryFailingInterceptorsTestCase.this.afterCallbackCalledForFailingMP.getAndSet(true)) {
                throw THROWN;
            }
        }
    }

    public class FailingAfterInterceptorFactory
    implements ProcessorInterceptorFactory {
        public ProcessorInterceptor get() {
            return new FailingAfterInterceptor();
        }
    }
}

