/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.interception;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.extension.http.api.request.validator.ResponseValidatorException;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.functional.api.exception.FunctionalTestException;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.http.api.HttpService;
import org.mule.tck.junit4.matcher.ErrorTypeMatcher;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.heisenberg.extension.HeisenbergConnectionProvider;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.exception.HeisenbergException;
import org.mule.test.heisenberg.extension.model.KillParameters;

@Feature(value="Interception API")
@Story(value="Component Interception Story")
public class ProcessorInterceptorFactoryTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public ExpectedError expectedError = ExpectedError.none();

    protected String getConfigFile() {
        return "org/mule/test/integration/interception/processor-interceptor-factory.xml";
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        objects.put("_AfterWithCallbackInterceptorFactory", new AfterWithCallbackInterceptorFactory());
        objects.put("_HasInjectedAttributesInterceptorFactory", new HasInjectedAttributesInterceptorFactory(false));
        objects.put("_EvaluatesExpressionInterceptorFactory", new EvaluatesExpressionInterceptorFactory());
        objects.put("_muleProcessorInterceptorFactoryOrder", () -> Arrays.asList(AfterWithCallbackInterceptorFactory.class.getName(), HasInjectedAttributesInterceptorFactory.class.getName(), EvaluatesExpressionInterceptorFactory.class.getName()));
        return objects;
    }

    @Before
    public void before() {
        HeisenbergConnectionProvider.getActiveConnections().clear();
        HasInjectedAttributesInterceptor.interceptionParameters.clear();
        AfterWithCallbackInterceptor.callback = (event, thrown) -> {};
    }

    @Description(value="Logger, flow-ref and splitter components are intercepted in order and the parameters are correctly sent")
    @Test
    public void injection() throws Exception {
        ArrayList payload = new ArrayList();
        ((FlowRunner)this.flowRunner("injectionInterceptionTest").withPayload(payload)).run();
        List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
        Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)3));
        InterceptionParameters loggerInterceptionParameter = interceptionParameters.get(0);
        InterceptionParameters flowRefInterceptionParameter = interceptionParameters.get(1);
        InterceptionParameters splitterInterceptionParameter = interceptionParameters.get(2);
        Assert.assertThat((Object)loggerInterceptionParameter.getParameters().isEmpty(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)flowRefInterceptionParameter.getParameters().get("name").resolveValue(), (Matcher)Matchers.is((Object)"anotherFlow"));
        Assert.assertThat((Object)splitterInterceptionParameter.getParameters().get("expression").resolveValue(), (Matcher)Matchers.is(payload));
    }

    @Test
    public void operationParameters() throws Exception {
        ((FlowRunner)((FlowRunner)this.flowRunner("killFromPayload").withPayload((Object)"T-1000")).withVariable("goodbye", (Object)"Hasta la vista, baby")).run();
        List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
        Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)1));
        InterceptionParameters killInterceptionParameter = interceptionParameters.get(0);
        Assert.assertThat(killInterceptionParameter.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"targetValue", "victim", "goodbyeMessage"}));
        Assert.assertThat((Object)killInterceptionParameter.getParameters().get("victim").resolveValue(), (Matcher)Matchers.is((Object)"T-1000"));
        Assert.assertThat((Object)killInterceptionParameter.getParameters().get("goodbyeMessage").resolveValue(), (Matcher)Matchers.is((Object)"Hasta la vista, baby"));
    }

    @Test
    public void resolvedConfigOperationParameters() throws Exception {
        this.flowRunner("die").run();
        Assert.assertThat((Object)HasInjectedAttributesInterceptor.interceptionParameters.size(), (Matcher)Matchers.is((Object)1));
        List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
        InterceptionParameters dieInterceptionParameter = interceptionParameters.get(0);
        Assert.assertThat(dieInterceptionParameter.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"config-ref", "config"}));
        Object config = dieInterceptionParameter.getParameters().get("config").resolveValue();
        Assert.assertThat((Object)config, (Matcher)Matchers.instanceOf(HeisenbergExtension.class));
        Assert.assertThat((Object)((HeisenbergExtension)config).getConfigName(), (Matcher)Matchers.is((Object)"heisenberg"));
        Object configRef = dieInterceptionParameter.getParameters().get("config-ref").resolveValue();
        Assert.assertThat((Object)configRef, (Matcher)Matchers.is((Object)"heisenberg"));
    }

    @Test
    public void operationThatUsesExtensionsClientInternally() throws Exception {
        Assert.assertThat((Object)this.flowRunner("executeKillWithClient").run().getMessage().getPayload().getValue().toString(), (Matcher)Matchers.is((Object)"Now he sleeps with the fishes."));
        Assert.assertThat((Object)HasInjectedAttributesInterceptor.interceptionParameters.size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void resolvedComplexParametersOperationParameters() throws Exception {
        ((FlowRunner)this.flowRunner("killWithCustomMessage").withVariable("goodbye", (Object)"Hasta la vista, baby")).run();
        List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
        Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)1));
        InterceptionParameters killInterceptionParameter = interceptionParameters.get(0);
        Assert.assertThat(killInterceptionParameter.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"targetValue", "victim", "goodbyeMessage", "killParameters"}));
        Assert.assertThat((Object)killInterceptionParameter.getParameters().get("victim").resolveValue(), (Matcher)Matchers.is((Object)"T-1000"));
        Assert.assertThat((Object)killInterceptionParameter.getParameters().get("goodbyeMessage").resolveValue(), (Matcher)Matchers.is((Object)"Hasta la vista, baby"));
        Assert.assertThat((Object)killInterceptionParameter.getParameters().get("killParameters").resolveValue(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(KillParameters.class)));
    }

    @Test
    @Description(value="The errorType set by an operation is preserved if an interceptor is applied")
    public void failingOperationErrorTypePreserved() throws Exception {
        AtomicBoolean afterCallbackCalled = new AtomicBoolean(false);
        AfterWithCallbackInterceptor.callback = (event, thrown) -> {
            Assert.assertThat(thrown.get(), (Matcher)Matchers.instanceOf(ConnectionException.class));
            Assert.assertThat((Object)((Throwable)thrown.get()).getCause(), (Matcher)Matchers.instanceOf(HeisenbergException.class));
            Assert.assertThat((Object)((Throwable)thrown.get()).getMessage(), (Matcher)Matchers.endsWith((String)"You are not allowed to speak with gus."));
            Assert.assertThat((Object)((Error)event.getError().get()).getErrorType(), (Matcher)ErrorTypeMatcher.errorType((String)"HEISENBERG", (String)"CONNECTIVITY"));
            afterCallbackCalled.set(true);
        };
        this.expectedError.expectErrorType("HEISENBERG", "CONNECTIVITY");
        try {
            this.flowRunner("callGusFring").run();
        }
        finally {
            Assert.assertThat((Object)afterCallbackCalled.get(), (Matcher)Matchers.is((Object)true));
        }
    }

    @Test
    public void expressionsInInterception() throws Exception {
        Assert.assertThat((Object)((TypedValue)this.flowRunner("expressionsInInterception").run().getVariables().get("addedVar")).getValue(), (Matcher)Matchers.is((Object)"value2"));
    }

    @Description(value="Smart Connector simple operation without parameters")
    @Test
    public void scOperation() throws Exception {
        this.flowRunner("scOperation").run();
        List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
        Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)2));
        InterceptionParameters moduleOperationChain = interceptionParameters.get(0);
        InterceptionParameters setPayloadOperation = interceptionParameters.get(1);
        Assert.assertThat(moduleOperationChain.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"moduleName", "moduleOperation"}));
        Assert.assertThat((Object)moduleOperationChain.getParameters().get("moduleName").resolveValue(), (Matcher)Matchers.is((Object)"module-using-core"));
        Assert.assertThat((Object)moduleOperationChain.getParameters().get("moduleOperation").resolveValue(), (Matcher)Matchers.is((Object)"set-payload-hardcoded"));
        Assert.assertThat(setPayloadOperation.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"value", "mimeType", "encoding"}));
        Assert.assertThat((Object)setPayloadOperation.getParameters().get("value").resolveValue(), (Matcher)Matchers.is((Object)"Wubba Lubba Dub Dub"));
        Assert.assertThat((Object)setPayloadOperation.getParameters().get("mimeType").resolveValue(), (Matcher)Matchers.is((Object)"text/plain"));
        Assert.assertThat((Object)setPayloadOperation.getParameters().get("encoding").resolveValue(), (Matcher)Matchers.is((Object)"UTF-8"));
    }

    @Description(value="Smart Connector simple operation with parameters")
    @Test
    public void scEchoOperation() throws Exception {
        String variableValue = "echo message for the win";
        ((FlowRunner)this.flowRunner("scEchoOperation").withVariable("variable", (Object)"echo message for the win")).run();
        List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
        Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)2));
        InterceptionParameters moduleOperationChain = interceptionParameters.get(0);
        InterceptionParameters setPayloadOperation = interceptionParameters.get(1);
        Assert.assertThat(moduleOperationChain.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"moduleName", "moduleOperation"}));
        Assert.assertThat((Object)moduleOperationChain.getParameters().get("moduleName").resolveValue(), (Matcher)Matchers.is((Object)"module-using-core"));
        Assert.assertThat((Object)moduleOperationChain.getParameters().get("moduleOperation").resolveValue(), (Matcher)Matchers.is((Object)"echo-set-payload"));
        Assert.assertThat(setPayloadOperation.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"value", "mimeType", "encoding"}));
        Assert.assertThat((Object)setPayloadOperation.getParameters().get("value").providedValue(), (Matcher)Matchers.is((Object)"#[vars.echoMessage]"));
        Assert.assertThat((Object)setPayloadOperation.getParameters().get("value").resolveValue(), (Matcher)Matchers.is((Object)"echo message for the win"));
        Assert.assertThat((Object)setPayloadOperation.getParameters().get("mimeType").resolveValue(), (Matcher)Matchers.is((Object)"text/plain"));
        Assert.assertThat((Object)setPayloadOperation.getParameters().get("encoding").resolveValue(), (Matcher)Matchers.is((Object)"UTF-8"));
    }

    @Description(value="Smart Connector simple operation with parameters through flow-ref")
    @Test
    public void scEchoOperationFlowRef() throws Exception {
        String variableValue = "echo message for the win";
        ((FlowRunner)this.flowRunner("scEchoOperationFlowRef").withVariable("variable", (Object)"echo message for the win")).run();
        List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
        Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)3));
        InterceptionParameters flowRef = interceptionParameters.get(0);
        InterceptionParameters moduleOperationChain = interceptionParameters.get(1);
        InterceptionParameters setPayloadOperation = interceptionParameters.get(2);
        Assert.assertThat(flowRef.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"name", "targetValue"}));
        Assert.assertThat((Object)flowRef.getParameters().get("name").resolveValue(), (Matcher)Matchers.is((Object)"scEchoOperation"));
        Assert.assertThat(moduleOperationChain.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"moduleName", "moduleOperation"}));
        Assert.assertThat((Object)moduleOperationChain.getParameters().get("moduleName").resolveValue(), (Matcher)Matchers.is((Object)"module-using-core"));
        Assert.assertThat((Object)moduleOperationChain.getParameters().get("moduleOperation").resolveValue(), (Matcher)Matchers.is((Object)"echo-set-payload"));
        Assert.assertThat(setPayloadOperation.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"value", "mimeType", "encoding"}));
        Assert.assertThat((Object)setPayloadOperation.getParameters().get("value").providedValue(), (Matcher)Matchers.is((Object)"#[vars.echoMessage]"));
        Assert.assertThat((Object)setPayloadOperation.getParameters().get("value").resolveValue(), (Matcher)Matchers.is((Object)"echo message for the win"));
        Assert.assertThat((Object)setPayloadOperation.getParameters().get("mimeType").resolveValue(), (Matcher)Matchers.is((Object)"text/plain"));
        Assert.assertThat((Object)setPayloadOperation.getParameters().get("encoding").resolveValue(), (Matcher)Matchers.is((Object)"UTF-8"));
    }

    @Description(value="Smart Connector that uses a Smart Connector operation without parameters")
    @Test
    public void scUsingScOperation() throws Exception {
        this.flowRunner("scUsingScOperation").run();
        List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
        Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)3));
        InterceptionParameters proxyModuleOperationChain = interceptionParameters.get(0);
        InterceptionParameters innerModuleOperationChain = interceptionParameters.get(1);
        InterceptionParameters setPayloadOperation = interceptionParameters.get(2);
        Assert.assertThat(proxyModuleOperationChain.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"moduleName", "moduleOperation"}));
        Assert.assertThat((Object)proxyModuleOperationChain.getParameters().get("moduleName").resolveValue(), (Matcher)Matchers.is((Object)"module-using-sc"));
        Assert.assertThat((Object)proxyModuleOperationChain.getParameters().get("moduleOperation").resolveValue(), (Matcher)Matchers.is((Object)"proxy-set-payload-hardcoded"));
        Assert.assertThat(innerModuleOperationChain.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"moduleName", "moduleOperation"}));
        Assert.assertThat((Object)innerModuleOperationChain.getParameters().get("moduleName").resolveValue(), (Matcher)Matchers.is((Object)"module-using-core"));
        Assert.assertThat((Object)innerModuleOperationChain.getParameters().get("moduleOperation").resolveValue(), (Matcher)Matchers.is((Object)"set-payload-hardcoded"));
        Assert.assertThat(setPayloadOperation.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"value", "mimeType", "encoding"}));
        Assert.assertThat((Object)setPayloadOperation.getParameters().get("value").resolveValue(), (Matcher)Matchers.is((Object)"Wubba Lubba Dub Dub"));
        Assert.assertThat((Object)setPayloadOperation.getParameters().get("mimeType").resolveValue(), (Matcher)Matchers.is((Object)"text/plain"));
        Assert.assertThat((Object)setPayloadOperation.getParameters().get("encoding").resolveValue(), (Matcher)Matchers.is((Object)"UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="Errors in sub-flows are handled correctly")
    public void failingSubFlow() throws Exception {
        List<InterceptionParameters> interceptionParameters;
        this.expectedError.expectCause(Matchers.instanceOf(FunctionalTestException.class));
        try {
            this.flowRunner("flowWithFailingSubFlowRef").run();
            interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
        }
        catch (Throwable throwable) {
            List<InterceptionParameters> interceptionParameters2 = HasInjectedAttributesInterceptor.interceptionParameters;
            Assert.assertThat(interceptionParameters2, (Matcher)Matchers.hasSize((int)3));
            InterceptionParameters flowRefParameter = interceptionParameters2.get(0);
            Assert.assertThat(flowRefParameter.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"name", "targetValue"}));
            Assert.assertThat((Object)flowRefParameter.getParameters().get("name").resolveValue(), (Matcher)Matchers.is((Object)"failing-sub-flow"));
            InterceptionParameters failParameter = interceptionParameters2.get(1);
            Assert.assertThat(failParameter.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"throwException"}));
            Assert.assertThat((Object)failParameter.getParameters().get("throwException").resolveValue(), (Matcher)Matchers.is((Object)"true"));
            throw throwable;
        }
        Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)3));
        InterceptionParameters flowRefParameter = interceptionParameters.get(0);
        Assert.assertThat(flowRefParameter.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"name", "targetValue"}));
        Assert.assertThat((Object)flowRefParameter.getParameters().get("name").resolveValue(), (Matcher)Matchers.is((Object)"failing-sub-flow"));
        InterceptionParameters failParameter = interceptionParameters.get(1);
        Assert.assertThat(failParameter.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"throwException"}));
        Assert.assertThat((Object)failParameter.getParameters().get("throwException").resolveValue(), (Matcher)Matchers.is((Object)"true"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="Processors in error handlers are intercepted correctly")
    public void errorHandler() throws Exception {
        this.expectedError.expectCause(Matchers.instanceOf(FunctionalTestException.class));
        AtomicBoolean afterCallbackCalledForFailingMP = new AtomicBoolean(false);
        AtomicBoolean afterCallbackCalledForErrorHandlingMp = new AtomicBoolean(false);
        AfterWithCallbackInterceptor.callback = (event, thrown) -> {
            if (!afterCallbackCalledForFailingMP.getAndSet(true)) {
                Assert.assertThat(thrown.get(), (Matcher)Matchers.instanceOf(FunctionalTestException.class));
            } else {
                afterCallbackCalledForErrorHandlingMp.set(true);
            }
        };
        try {
            this.flowRunner("flowFailingWithErrorHandler").run();
        }
        finally {
            Assert.assertThat((Object)afterCallbackCalledForFailingMP.get(), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)afterCallbackCalledForErrorHandlingMp.get(), (Matcher)Matchers.is((Object)true));
            List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
            Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)2));
            InterceptionParameters mpInGlobalErrorHandler = interceptionParameters.get(1);
            Assert.assertThat((Object)mpInGlobalErrorHandler.getLocation().getLocation(), (Matcher)Matchers.is((Object)"flowFailingWithErrorHandler/errorHandler/0/processors/0"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="Processors in global error handlers are intercepted correctly")
    public void globalErrorHandler() throws Exception {
        this.expectedError.expectCause(Matchers.instanceOf(FunctionalTestException.class));
        AtomicBoolean afterCallbackCalledForFailingMP = new AtomicBoolean(false);
        AtomicBoolean afterCallbackCalledForErrorHandlingMp = new AtomicBoolean(false);
        AfterWithCallbackInterceptor.callback = (event, thrown) -> {
            if (!afterCallbackCalledForFailingMP.getAndSet(true)) {
                Assert.assertThat(thrown.get(), (Matcher)Matchers.instanceOf(FunctionalTestException.class));
            } else {
                afterCallbackCalledForErrorHandlingMp.set(true);
            }
        };
        try {
            this.flowRunner("flowFailing").run();
        }
        finally {
            Assert.assertThat((Object)afterCallbackCalledForFailingMP.get(), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)afterCallbackCalledForErrorHandlingMp.get(), (Matcher)Matchers.is((Object)true));
            List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
            Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)2));
            InterceptionParameters mpInGlobalErrorHandler = interceptionParameters.get(1);
            Assert.assertThat((Object)mpInGlobalErrorHandler.getLocation().getLocation(), (Matcher)Matchers.is((Object)"globalErrorHandler/0/processors/0"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="Processors in global error handlers are intercepted correctly when raise-error is used")
    public void globalErrorHandlerRaise() throws Exception {
        this.expectedError.expectCause(Matchers.instanceOf(DefaultMuleException.class));
        AtomicBoolean afterCallbackCalledForFailingMP = new AtomicBoolean(false);
        AtomicBoolean afterCallbackCalledForErrorHandlingMp = new AtomicBoolean(false);
        AfterWithCallbackInterceptor.callback = (event, thrown) -> {
            if (!afterCallbackCalledForFailingMP.getAndSet(true)) {
                Assert.assertThat(thrown.get(), (Matcher)Matchers.instanceOf(DefaultMuleException.class));
            } else {
                afterCallbackCalledForErrorHandlingMp.set(true);
            }
        };
        try {
            this.flowRunner("flowRaise").run();
        }
        finally {
            Assert.assertThat((Object)afterCallbackCalledForFailingMP.get(), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)afterCallbackCalledForErrorHandlingMp.get(), (Matcher)Matchers.is((Object)true));
            List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
            Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)2));
            InterceptionParameters mpInGlobalErrorHandler = interceptionParameters.get(1);
            Assert.assertThat((Object)mpInGlobalErrorHandler.getLocation().getLocation(), (Matcher)Matchers.is((Object)"globalErrorHandler/0/processors/0"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="Processors in global error handlers are intercepted correctly for errors in operations")
    public void globalErrorHandlerOperation() throws Exception {
        this.expectedError.expectCause(Matchers.instanceOf(HeisenbergException.class));
        AtomicBoolean afterCallbackCalledForFailingMP = new AtomicBoolean(false);
        AtomicBoolean afterCallbackCalledForErrorHandlingMp = new AtomicBoolean(false);
        AfterWithCallbackInterceptor.callback = (event, thrown) -> {
            if (!afterCallbackCalledForFailingMP.getAndSet(true)) {
                Assert.assertThat(thrown.get(), (Matcher)Matchers.instanceOf(HeisenbergException.class));
            } else {
                afterCallbackCalledForErrorHandlingMp.set(true);
            }
        };
        try {
            this.flowRunner("flowFailingOperation").run();
        }
        finally {
            Assert.assertThat((Object)afterCallbackCalledForFailingMP.get(), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)afterCallbackCalledForErrorHandlingMp.get(), (Matcher)Matchers.is((Object)true));
            List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
            Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)2));
            InterceptionParameters mpInGlobalErrorHandler = interceptionParameters.get(1);
            Assert.assertThat((Object)mpInGlobalErrorHandler.getLocation().getLocation(), (Matcher)Matchers.is((Object)"globalErrorHandler/0/processors/0"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="Processors in global error handlers are intercepted correctly for an unknown status code errors in http request")
    public void globalErrorHandlerUnknownStatusCodeHttpRequest() throws Exception {
        this.expectedError.expectCause(Matchers.instanceOf(ResponseValidatorException.class));
        AtomicBoolean afterCallbackCalledForFailingMP = new AtomicBoolean(false);
        AtomicBoolean afterCallbackCalledForErrorHandlingMp = new AtomicBoolean(false);
        AfterWithCallbackInterceptor.callback = (event, thrown) -> {
            if (!afterCallbackCalledForFailingMP.getAndSet(true)) {
                Assert.assertThat(thrown.get(), (Matcher)Matchers.instanceOf(ResponseValidatorException.class));
            } else {
                afterCallbackCalledForErrorHandlingMp.set(true);
            }
        };
        try {
            this.flowRunner("flowUnknownStatusCodeHttpRequest").run();
        }
        finally {
            Assert.assertThat((Object)afterCallbackCalledForFailingMP.get(), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)afterCallbackCalledForErrorHandlingMp.get(), (Matcher)Matchers.is((Object)true));
            List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
            Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)2));
            InterceptionParameters mpInGlobalErrorHandler = interceptionParameters.get(1);
            Assert.assertThat((Object)mpInGlobalErrorHandler.getLocation().getLocation(), (Matcher)Matchers.is((Object)"globalErrorHandler/0/processors/0"));
        }
    }

    @Test
    public void loggerWithTemplate() throws Exception {
        ((FlowRunner)this.flowRunner("loggerWithTemplate").withVariable("v1", (Object)"value")).run();
        List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
        Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)1));
        InterceptionParameters param = interceptionParameters.get(0);
        Assert.assertThat((Object)((ProcessorParameterValue)param.parameters.get("message")).resolveValue(), (Matcher)Matchers.is((Object)"Logging value"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="Processors in global error handlers are intercepted correctly for errors in XML SDK operations")
    public void globalErrorHandlerScOperation() throws Exception {
        this.expectedError.expectErrorType("MODULE-USING-CORE", "RAISED");
        AtomicBoolean afterCallbackCalledForFailingMP = new AtomicBoolean(false);
        AtomicBoolean afterCallbackCalledForErrorHandlingMp = new AtomicBoolean(false);
        AfterWithCallbackInterceptor.callback = (event, thrown) -> {
            if (!afterCallbackCalledForFailingMP.getAndSet(true)) {
                Assert.assertThat(thrown.get(), (Matcher)Matchers.instanceOf(DefaultMuleException.class));
            } else {
                afterCallbackCalledForErrorHandlingMp.set(true);
            }
        };
        try {
            this.flowRunner("scFailingOperation").run();
        }
        finally {
            Assert.assertThat((Object)afterCallbackCalledForFailingMP.get(), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)afterCallbackCalledForErrorHandlingMp.get(), (Matcher)Matchers.is((Object)true));
            List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
            Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)3));
            InterceptionParameters mpInGlobalErrorHandler = interceptionParameters.get(2);
            Assert.assertThat((Object)mpInGlobalErrorHandler.getLocation().getLocation(), (Matcher)Matchers.is((Object)"globalErrorHandler/0/processors/0"));
        }
    }

    @Test
    @Description(value="Processors in global error handlers are intercepted correctly when error is in referenced flow")
    public void globalErrorHandlerWithFlowRef() throws Exception {
        this.expectedError.expectCause(Matchers.instanceOf(FunctionalTestException.class));
        AtomicInteger afters = new AtomicInteger(0);
        AfterWithCallbackInterceptor.callback = (event, thrown) -> afters.incrementAndGet();
        try {
            this.flowRunner("flowWithFailingFlowRef").run();
        }
        finally {
            List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
            Assert.assertThat((String)interceptionParameters.stream().map(ip -> ip.getLocation().getLocation()).collect(Collectors.toList()).toString(), interceptionParameters, (Matcher)Matchers.hasSize((int)4));
            Assert.assertThat((Object)afters.get(), (Matcher)Matchers.is((Object)4));
        }
    }

    public static class AfterWithCallbackInterceptor
    implements ProcessorInterceptor {
        static BiConsumer<InterceptionEvent, Optional<Throwable>> callback;

        public void after(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
            callback.accept(event, thrown);
        }
    }

    public static class AfterWithCallbackInterceptorFactory
    implements ProcessorInterceptorFactory {
        public ProcessorInterceptor get() {
            return new AfterWithCallbackInterceptor();
        }
    }

    public static class EvaluatesExpressionInterceptor
    implements ProcessorInterceptor {
        private MuleExpressionLanguage expressionEvaluator;

        public EvaluatesExpressionInterceptor(MuleExpressionLanguage expressionEvaluator) {
            this.expressionEvaluator = expressionEvaluator;
        }

        public void before(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event) {
            parameters.values().forEach(ProcessorParameterValue::resolveValue);
            try {
                this.expressionEvaluator.evaluate("vars.addedVar", event.asBindingContext());
            }
            catch (ExpressionRuntimeException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Unable to resolve reference of addedVar"));
            }
            event.addVariable("addedVar", (Object)"value1");
            Assert.assertThat((Object)this.expressionEvaluator.evaluate("vars.addedVar", event.asBindingContext()).getValue(), (Matcher)Matchers.is((Object)"value1"));
            event.addVariable("addedVar", (Object)"value2");
            Assert.assertThat((Object)this.expressionEvaluator.evaluate("vars.addedVar", event.asBindingContext()).getValue(), (Matcher)Matchers.is((Object)"value2"));
        }
    }

    public static class EvaluatesExpressionInterceptorFactory
    implements ProcessorInterceptorFactory {
        @Inject
        private MuleExpressionLanguage expressionEvaluator;

        public ProcessorInterceptor get() {
            return new EvaluatesExpressionInterceptor(this.expressionEvaluator);
        }

        public boolean intercept(ComponentLocation location) {
            return location.getLocation().startsWith("expressionsInInterception");
        }
    }

    public static class InterceptionParameters {
        private ComponentLocation location;
        private Map<String, ProcessorParameterValue> parameters;
        private InterceptionEvent event;

        public InterceptionParameters(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event) {
            this.location = location;
            this.parameters = parameters;
            this.event = event;
        }

        public ComponentLocation getLocation() {
            return this.location;
        }

        public Map<String, ProcessorParameterValue> getParameters() {
            return this.parameters;
        }

        public InterceptionEvent getEvent() {
            return this.event;
        }
    }

    public static class HasInjectedAttributesInterceptor
    implements ProcessorInterceptor {
        static final List<InterceptionParameters> interceptionParameters = new LinkedList<InterceptionParameters>();
        private MuleExpressionLanguage expressionEvaluator;
        private LockFactory lockFactory;
        private HttpService httpService;
        private ErrorTypeRepository errorTypeRepository;
        private SchedulerService schedulerService;
        private Registry registry;
        private boolean mutateEventBefore;

        public HasInjectedAttributesInterceptor(MuleExpressionLanguage expressionEvaluator, LockFactory lockFactory, HttpService httpService, ErrorTypeRepository errorTypeRepository, SchedulerService schedulerService, Registry registry, boolean mutateEventBefore) {
            this.expressionEvaluator = expressionEvaluator;
            this.lockFactory = lockFactory;
            this.httpService = httpService;
            this.errorTypeRepository = errorTypeRepository;
            this.schedulerService = schedulerService;
            this.registry = registry;
            this.mutateEventBefore = mutateEventBefore;
        }

        public void before(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event) {
            parameters.values().forEach(ProcessorParameterValue::resolveValue);
            interceptionParameters.add(new InterceptionParameters(location, parameters, event));
            Assert.assertThat((Object)this.expressionEvaluator, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
            Assert.assertThat((Object)this.lockFactory, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
            Assert.assertThat((Object)this.httpService, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
            Assert.assertThat((Object)this.errorTypeRepository, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
            Assert.assertThat((Object)this.schedulerService, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
            Assert.assertThat((Object)this.registry, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
            if (this.mutateEventBefore) {
                event.addVariable("mutated", (Object)Math.random());
            }
        }
    }

    public static class HasInjectedAttributesInterceptorFactory
    implements ProcessorInterceptorFactory {
        @Inject
        private MuleExpressionLanguage expressionEvaluator;
        @Inject
        private LockFactory lockFactory;
        @Inject
        private HttpService httpService;
        @Inject
        private ErrorTypeRepository errorTypeRepository;
        @Inject
        private SchedulerService schedulerService;
        @Inject
        private Registry registry;
        private boolean mutateEventBefore;

        public HasInjectedAttributesInterceptorFactory(boolean mutateEventBefore) {
            this.mutateEventBefore = mutateEventBefore;
        }

        public ProcessorInterceptor get() {
            return new HasInjectedAttributesInterceptor(this.expressionEvaluator, this.lockFactory, this.httpService, this.errorTypeRepository, this.schedulerService, this.registry, this.mutateEventBefore);
        }
    }
}

