/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.security;

import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.security.SecurityContext;
import org.mule.runtime.api.security.SecurityProviderNotFoundException;
import org.mule.runtime.api.security.UnknownAuthenticationTypeException;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.security.AbstractAuthenticationFilter;
import org.mule.runtime.core.api.security.CryptoFailureException;
import org.mule.runtime.core.api.security.EncryptionStrategyNotFoundException;
import org.mule.test.AbstractIntegrationTestCase;
import org.springframework.security.authentication.BadCredentialsException;

public class CustomSecurityFilterTestCase
extends AbstractIntegrationTestCase {
    private static final String EXPECTED_PASSWORD = "ross";

    protected String[] getConfigFiles() {
        return new String[]{"org/mule/test/integration/security/custom-security-filter-test.xml"};
    }

    @Test
    public void testOutboundAutenticationSend() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("username", EXPECTED_PASSWORD);
        props.put("pass", EXPECTED_PASSWORD);
        CoreEvent event = ((FlowRunner)((FlowRunner)this.flowRunner("test").withPayload((Object)"hi")).withInboundProperties(props)).run();
        Assert.assertThat((Object)event.getError().isPresent(), (Matcher)Is.is((Object)false));
        props.put("pass", "badpass");
        Exception e = ((FlowRunner)((FlowRunner)this.flowRunner("test").withPayload((Object)"hi")).withInboundProperties(props)).runExpectingException();
        Assert.assertThat((Object)ExceptionHelper.getRootException((Throwable)e), (Matcher)CoreMatchers.instanceOf(BadCredentialsException.class));
    }

    public static class CustomSecurityFilter
    extends AbstractAuthenticationFilter {
        private String password;

        public SecurityContext authenticate(CoreEvent event) throws SecurityException, UnknownAuthenticationTypeException, CryptoFailureException, SecurityProviderNotFoundException, EncryptionStrategyNotFoundException, InitialisationException {
            ExpressionManager expressionManager = (ExpressionManager)this.registry.lookupByName("_muleExpressionManager").get();
            Object passwordEval = expressionManager.evaluate(this.password, event).getValue();
            if (!passwordEval.equals(CustomSecurityFilterTestCase.EXPECTED_PASSWORD)) {
                throw new BadCredentialsException("Bad credentials");
            }
            return event.getSecurityContext();
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

