/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.security;

import io.qameta.allure.Feature;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.component.TestConnectorQueueHandler;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.http.functional.matcher.HttpResponseReasonPhraseMatcher;
import org.mule.test.http.functional.matcher.HttpResponseStatusCodeMatcher;

@Ignore(value="MULE-19149")
@Feature(value="HTTP Extension")
public class HttpListenerAuthenticationTestCase
extends AbstractIntegrationTestCase {
    private static final String BASIC_REALM_MULE_REALM = "Basic realm=\"mule-realm\"";
    private static final String VALID_USER = "user";
    private static final String VALID_PASSWORD = "password";
    private static final String INVALID_PASSWORD = "invalidPassword";
    private static final String EXPECTED_PAYLOAD = "TestBasicAuthOk";
    CloseableHttpClient httpClient;
    CloseableHttpResponse httpResponse;
    @Rule
    public DynamicPort listenPort = new DynamicPort("port");

    protected String getConfigFile() {
        return "org/mule/test/integration/security/http-listener-authentication-config.xml";
    }

    @After
    public void tearDown() {
        IOUtils.closeQuietly((Closeable)this.httpResponse);
        IOUtils.closeQuietly((Closeable)this.httpClient);
    }

    @Test
    public void invalidBasicAuthentication() throws Exception {
        CredentialsProvider credsProvider = this.getCredentialsProvider(VALID_USER, INVALID_PASSWORD);
        this.getHttpResponse(credsProvider);
        Assert.assertThat((Object)this.httpResponse.getStatusLine().getStatusCode(), (Matcher)Is.is((Object)HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode()));
        Header authHeader = this.httpResponse.getFirstHeader("WWW-Authenticate");
        Assert.assertThat((Object)authHeader, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)authHeader.getValue(), (Matcher)Is.is((Object)BASIC_REALM_MULE_REALM));
        TestConnectorQueueHandler queueHandler = new TestConnectorQueueHandler(this.registry);
        Assert.assertThat((Object)queueHandler.read("basicAuthentication", 5000L).getMessage(), (Matcher)Is.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void validBasicAuthentication() throws Exception {
        CredentialsProvider credsProvider = this.getCredentialsProvider(VALID_USER, VALID_PASSWORD);
        this.getHttpResponse(credsProvider);
        Assert.assertThat((Object)this.httpResponse.getStatusLine().getStatusCode(), (Matcher)Is.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        Assert.assertThat((Object)IOUtils.toString((InputStream)this.httpResponse.getEntity().getContent()), (Matcher)Is.is((Object)EXPECTED_PAYLOAD));
    }

    @Test
    public void noProvider() throws Exception {
        CredentialsProvider credsProvider = this.getCredentialsProvider(VALID_USER, VALID_PASSWORD);
        this.getHttpResponse(credsProvider, "zaraza");
        Assert.assertThat((Object)this.httpResponse, (Matcher)HttpResponseStatusCodeMatcher.hasStatusCode((int)HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()));
        Assert.assertThat((Object)this.httpResponse, (Matcher)HttpResponseReasonPhraseMatcher.hasReasonPhrase((String)HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase()));
        TestConnectorQueueHandler queueHandler = new TestConnectorQueueHandler(this.registry);
        Assert.assertThat((Object)queueHandler.read("basicAuthentication", 5000L).getMessage(), (Matcher)Is.is((Matcher)Matchers.notNullValue()));
    }

    private void getHttpResponse(CredentialsProvider credsProvider) throws IOException {
        this.getHttpResponse(credsProvider, "memory-provider");
    }

    private void getHttpResponse(CredentialsProvider credsProvider, String provider) throws IOException {
        HttpPost httpPost = new HttpPost(String.format("http://localhost:%s/basic?provider=%s", this.listenPort.getNumber(), provider));
        this.httpClient = HttpClients.custom().setDefaultCredentialsProvider(credsProvider).build();
        this.httpResponse = this.httpClient.execute((HttpUriRequest)httpPost);
    }

    private CredentialsProvider getCredentialsProvider(String user, String password) {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(user, password));
        return credsProvider;
    }
}

