/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;

public class SourceResponseTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder((HttpService)this.getService(HttpService.class)).build();

    protected String getConfigFile() {
        return "org/mule/test/integration/streaming/source-response-config.xml";
    }

    @Test
    public void responseParameterWithCursor() throws IOException, TimeoutException {
        HttpResponse httpResponse = this.httpClient.send(HttpRequest.builder().uri(String.format("http://localhost:%s/", this.httpPort.getNumber())).build(), 5000, true, null);
        Assert.assertThat((Object)httpResponse.getStatusCode(), (Matcher)Is.is((Object)200));
        String responsePayload = IOUtils.toString((InputStream)httpResponse.getEntity().getContent());
        Assert.assertThat((Object)responsePayload, (Matcher)StringContains.containsString((String)"<name>Foo</name>"));
        Assert.assertThat((Object)responsePayload, (Matcher)StringContains.containsString((String)"<lastName>Bar</lastName>"));
    }
}

