/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.processors;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.tck.junit4.matcher.ErrorTypeMatcher;
import org.mule.test.AbstractIntegrationTestCase;

public class IdempotentMessageValidatorTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public ExpectedError expectedError = ExpectedError.none();

    public String getConfigFile() {
        return "org/mule/processors/idempotent-message-validator-config.xml";
    }

    @Test
    public void validateWithGlobalObjectStore() throws Exception {
        String payload = "payload";
        CoreEvent response = ((FlowRunner)this.flowRunner("validate-global").withPayload((Object)payload)).run();
        MatcherAssert.assertThat((Object)response.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)payload)));
        this.expectedError.expectErrorType(Errors.CORE_NAMESPACE_NAME, "DUPLICATE_MESSAGE");
        ((FlowRunner)this.flowRunner("validate-global").withPayload((Object)payload)).run();
    }

    @Test
    public void validateWithGlobalObjectStoreFromDifferentValidators() throws Exception {
        String payload = "payload";
        CoreEvent response = ((FlowRunner)this.flowRunner("validate-global").withPayload((Object)payload)).run();
        MatcherAssert.assertThat((Object)response.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)payload)));
        this.expectedError.expectErrorType(Errors.CORE_NAMESPACE_NAME, "DUPLICATE_MESSAGE");
        ((FlowRunner)this.flowRunner("validate-global2").withPayload((Object)payload)).run();
    }

    @Test
    public void validateWithPrivateObjectStoreUsesADifferentObjectStore() throws Exception {
        String globalPayload = "global-payload";
        String privatePayload = "private-payload";
        CoreEvent globalResponse = ((FlowRunner)this.flowRunner("validate-global").withPayload((Object)globalPayload)).run();
        CoreEvent privateResponse = ((FlowRunner)this.flowRunner("validate-private").withPayload((Object)privatePayload)).run();
        MatcherAssert.assertThat((Object)globalResponse.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)globalPayload)));
        MatcherAssert.assertThat((Object)privateResponse.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)privatePayload)));
        ((FlowRunner)this.flowRunner("validate-global").withPayload((Object)globalPayload)).runExpectingException(ErrorTypeMatcher.errorType((String)Errors.CORE_NAMESPACE_NAME, (String)"DUPLICATE_MESSAGE"));
        ((FlowRunner)this.flowRunner("validate-private").withPayload((Object)privatePayload)).runExpectingException(ErrorTypeMatcher.errorType((String)Errors.CORE_NAMESPACE_NAME, (String)"DUPLICATE_MESSAGE"));
    }

    @Test
    public void validateWithImplicitObjectStoreUsesADifferentObjectStore() throws Exception {
        String globalPayload = "global-payload";
        String implicitPayload = "implicit-payload";
        CoreEvent globalResponse = ((FlowRunner)this.flowRunner("validate-global").withPayload((Object)globalPayload)).run();
        CoreEvent implicitResponse = ((FlowRunner)this.flowRunner("validate-implicit").withPayload((Object)implicitPayload)).run();
        MatcherAssert.assertThat((Object)globalResponse.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)globalPayload)));
        MatcherAssert.assertThat((Object)implicitResponse.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)implicitPayload)));
        ((FlowRunner)this.flowRunner("validate-global").withPayload((Object)globalPayload)).runExpectingException(ErrorTypeMatcher.errorType((String)Errors.CORE_NAMESPACE_NAME, (String)"DUPLICATE_MESSAGE"));
        ((FlowRunner)this.flowRunner("validate-implicit").withPayload((Object)implicitPayload)).runExpectingException(ErrorTypeMatcher.errorType((String)Errors.CORE_NAMESPACE_NAME, (String)"DUPLICATE_MESSAGE"));
    }
}

